/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.j3d.CubeWall;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCShape3D;
import com.klg.jclass.chart3d.j3d.JCTexture2D;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class JCCubeSquareArray
extends JCBranchGroup {
    protected static final int NUM_FACES = 6;
    private CubeWall[] cubeWall = new CubeWall[6];
    protected static final int FACE_LEFT = 0;
    protected static final int FACE_RIGHT = 1;
    protected static final int FACE_BOTTOM = 2;
    protected static final int FACE_TOP = 3;
    protected static final int FACE_FAR = 4;
    protected static final int FACE_NEAR = 5;

    protected JCCubeSquareArray(Color3f color3f, Color3f color3f2) {
        this.cubeWall[4] = new CubeWall(new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), color3f, color3f2);
        this.cubeWall[0] = new CubeWall(new Vector3d(0.0, -1.0, 0.0), new Vector3d(1.5707963267948966, 0.0, 1.5707963267948966), new Vector3d(-1.0, 0.0, 0.0), color3f, color3f2);
        this.cubeWall[5] = new CubeWall(new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, Math.PI, Math.PI), new Vector3d(0.0, 0.0, 1.0), color3f, color3f2);
        this.cubeWall[1] = new CubeWall(new Vector3d(0.0, -1.0, 0.0), new Vector3d(1.5707963267948966, 0.0, -1.5707963267948966), new Vector3d(1.0, 0.0, 0.0), color3f, color3f2);
        this.cubeWall[3] = new CubeWall(new Vector3d(0.0, -1.0, 0.0), new Vector3d(1.5707963267948966, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), color3f, color3f2);
        this.cubeWall[2] = new CubeWall(new Vector3d(0.0, 1.0, 0.0), new Vector3d(-1.5707963267948966, Math.PI, 0.0), new Vector3d(0.0, -1.0, 0.0), color3f, color3f2);
        int n2 = 0;
        while (n2 < 6) {
            this.setRotation(n2, 0.0);
            this.addChild((Node)this.cubeWall[n2].tg);
            ++n2;
        }
        this.compile();
    }

    protected void applyTexture(int n2, JCTexture2D jCTexture2D) {
        if (n2 > -1 && n2 < 6) {
            Appearance appearance = this.cubeWall[n2].filledCubeFace.getAppearance();
            appearance.setTexture((Texture)jCTexture2D);
            this.cubeWall[n2].filledCubeFace.setAppearance(appearance);
        }
    }

    protected void flipWallImage(int n2, int n3) {
        this.cubeWall[n2].flipTextureCoordinates(n3);
    }

    protected JCShape3D getFace(int n2) {
        if (n2 > -1 && n2 < 6) {
            return this.cubeWall[n2].filledCubeFace;
        }
        return null;
    }

    protected JCShape3D getFaceOutline(int n2) {
        if (n2 > -1 && n2 < 6) {
            return this.cubeWall[n2].outlineCubeFace;
        }
        return null;
    }

    protected float getPolygonOffset() {
        float f2 = 0.0f;
        Appearance appearance = this.cubeWall[0].outlineCubeFace.getAppearance();
        PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
        if (polygonAttributes != null) {
            f2 = polygonAttributes.getPolygonOffset();
        }
        return f2;
    }

    protected double getRotation(int n2) {
        return this.cubeWall[n2].getImageAngle();
    }

    protected void setPolygonOffset(float f2) {
        int n2 = 0;
        while (n2 < 6) {
            Appearance appearance = this.cubeWall[n2].outlineCubeFace.getAppearance();
            PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
            if (polygonAttributes == null) {
                polygonAttributes = new PolygonAttributes();
            }
            polygonAttributes.setPolygonOffset(f2);
            if (appearance.getPolygonAttributes() == null) {
                appearance.setPolygonAttributes(polygonAttributes);
            }
            this.cubeWall[n2].outlineCubeFace.setAppearance(appearance);
            ++n2;
        }
    }

    protected void setRotation(int n2, double d2) {
        if (n2 < 0 || n2 > 5) {
            return;
        }
        double d3 = Math.IEEEremainder(d2, 90.0);
        if (d3 != 0.0) {
            return;
        }
        double d4 = Math.toRadians(d2);
        this.cubeWall[n2].setImageAngle(d2);
        Vector3d vector3d = new Vector3d(this.cubeWall[n2].imageRotationAxis);
        vector3d.scale(d4);
        this.cubeWall[n2].eulerAngles.add(vector3d);
        Transform3D transform3D = new Transform3D();
        transform3D.setEuler(this.cubeWall[n2].eulerAngles);
        transform3D.setTranslation(this.cubeWall[n2].translation);
        this.cubeWall[n2].tg.setTransform(transform3D);
    }
}

