/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.j3d.JCChart3dJava3d;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;

public class JCCanvas3D
extends Canvas3D {
    protected JCChart3dJava3d chart3d = null;
    private boolean fWaitRenderDone;
    private GraphicsContext3D last_ctx = null;
    transient MouseListener myMouseListener = null;
    transient MouseMotionListener myMouseMotionListener = null;

    public JCCanvas3D(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        ((Component)((Object)this)).enableEvents(48L);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.myMouseListener = AWTEventMulticaster.add(this.myMouseListener, mouseListener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.myMouseMotionListener = AWTEventMulticaster.add(this.myMouseMotionListener, mouseMotionListener);
    }

    public Image getAsImage() {
        Raster raster = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, this.getBounds().width, this.getBounds().height, new ImageComponent2D(1, new BufferedImage(this.getBounds().width, this.getBounds().height, 1)), null);
        this.last_ctx.readRaster(raster);
        BufferedImage bufferedImage = raster.getImage().getImage();
        return bufferedImage;
    }

    public boolean getWaitRenderFlag() {
        return this.fWaitRenderDone;
    }

    public void postRender() {
        this.fWaitRenderDone = false;
    }

    public synchronized void postSwap() {
        super.postSwap();
        this.last_ctx = this.getGraphicsContext3D();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        MouseListener mouseListener = this.myMouseListener;
        if (mouseListener != null) {
            int n2 = mouseEvent.getID();
            mouseEvent.translatePoint(this.chart3d.convertChartAreaXToX(0), this.chart3d.convertChartAreaYToY(0));
            switch (n2) {
                case 501: {
                    mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    mouseListener.mouseEntered(mouseEvent);
                    break;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        MouseMotionListener mouseMotionListener = this.myMouseMotionListener;
        if (mouseMotionListener != null) {
            int n2 = mouseEvent.getID();
            mouseEvent.translatePoint(this.chart3d.convertChartAreaXToX(0), this.chart3d.convertChartAreaYToY(0));
            switch (n2) {
                case 503: {
                    mouseMotionListener.mouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    mouseMotionListener.mouseDragged(mouseEvent);
                    break;
                }
            }
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.myMouseListener = AWTEventMulticaster.remove(this.myMouseListener, mouseListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.myMouseMotionListener = AWTEventMulticaster.remove(this.myMouseMotionListener, mouseMotionListener);
    }

    public void setChart3d(JCChart3dJava3d jCChart3dJava3d) {
        this.chart3d = jCChart3dJava3d;
    }

    public void setWaitRenderFlag(boolean bl) {
        this.fWaitRenderDone = bl;
    }
}

