/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCCanvas3D;
import com.klg.jclass.chart3d.j3d.JCPointLight;
import com.klg.jclass.chart3d.j3d.JCSpotLight;
import com.klg.jclass.chart3d.j3d.JCTransformGroup;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Fog;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Light;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class JC3DUniverse {
    private Locale locale = null;
    private View view = null;
    private boolean fEnableDepthCue = true;
    private JCBranchGroup bgFog = null;
    private Switch fogSwitch = null;
    private LinearFog fog = null;
    private double fogFrontDistance = 0.0;
    private double fogBackDistance = 0.0;
    private double deltaDistance = 3.0;
    private final double CENTER_Z_DELTA = 0.5;
    private double centerZ = 0.0;
    private double viewPlatformDistance = 5.0;
    private double fieldOfView = Math.toRadians(43.6);
    private ArrayList lights = new ArrayList();
    private JCBranchGroup bgLighting = null;
    private JCCanvas3D myCanvas3D = null;
    private BoundingSphere boundsphere = null;
    protected JCTransformGroup tgViewPlatform = null;
    private JCBranchGroup bgScene = null;
    private JCTransformGroup objScale = null;
    private JCBranchGroup bgContent = null;
    private JCBranchGroup bgBackground = null;
    private Background background = null;
    protected final int BEHAVIOR = 550;

    public JC3DUniverse() {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        this.myCanvas3D = new JCCanvas3D(graphicsConfiguration);
        this.view = this.constructView(this.myCanvas3D);
        this.view.setSceneAntialiasingEnable(false);
        this.locale = this.constructViewBranch(this.view);
        this.bgScene = this.createSceneGraph(this.myCanvas3D);
    }

    public void addAmbientLight() {
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setInfluencingBounds((Bounds)this.boundsphere);
        ambientLight.setEnable(true);
        this.addLighting((Light)ambientLight);
    }

    public void addBackground() {
        this.bgBackground = new JCBranchGroup();
        this.background = new Background();
        this.background.setCapability(16);
        this.background.setCapability(17);
        this.background.setApplicationBounds((Bounds)this.boundsphere);
        this.bgBackground.addChild((Node)this.background);
        this.bgScene.addChild((Node)this.bgBackground);
    }

    public void addBehavior(Behavior behavior) {
        JCBranchGroup jCBranchGroup = new JCBranchGroup(550);
        jCBranchGroup.addChild((Node)behavior);
        this.bgScene.addChild((Node)jCBranchGroup);
    }

    public void addContent(JCBranchGroup jCBranchGroup) {
        jCBranchGroup.compile();
        this.bgContent.addChild((Node)jCBranchGroup);
    }

    public void addDirectionalLight() {
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f vector3f = new Vector3f(0.0f, -1.0f, -1.0f);
        DirectionalLight directionalLight = new DirectionalLight(color3f, vector3f);
        directionalLight.setInfluencingBounds((Bounds)this.boundsphere);
        directionalLight.setEnable(true);
        this.addLighting((Light)directionalLight);
    }

    public void addFog(Fog fog) {
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        jCBranchGroup.addChild((Node)fog);
        this.bgFog.addChild((Node)jCBranchGroup);
    }

    public void addLighting(Light light) {
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        jCBranchGroup.addChild((Node)light);
        jCBranchGroup.compile();
        this.bgLighting.addChild((Node)jCBranchGroup);
        this.lights.add(light);
    }

    public void addLinearFog(Color3f color3f) {
        this.removeFog();
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        this.fog = new LinearFog();
        this.fog.setCapability(14);
        this.fog.setCapability(15);
        this.fog.setCapability(13);
        this.fog.setCapability(16);
        this.fog.setCapability(17);
        this.fog.setColor(color3f);
        this.centerZ = 0.5;
        this.deltaDistance = 3.0;
        this.fog.setFrontDistance((double)((float)this.viewPlatformDistance - (float)this.centerZ) + this.fogFrontDistance);
        this.fog.setBackDistance((double)((float)this.viewPlatformDistance - (float)this.centerZ + (float)this.deltaDistance) + this.fogBackDistance);
        this.fog.setInfluencingBounds((Bounds)this.boundsphere);
        jCBranchGroup.addChild((Node)this.fog);
        this.bgFog.addChild((Node)jCBranchGroup);
    }

    public void addPointLight() {
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        Point3f point3f = new Point3f(1.0f, 1.0f, 3.0f);
        Point3f point3f2 = new Point3f(1.0f, 0.0f, 0.0f);
        JCPointLight jCPointLight = new JCPointLight(color3f, point3f, point3f2);
        jCPointLight.setInfluencingBounds((Bounds)this.boundsphere);
        jCPointLight.setEnable(true);
        this.addLighting((Light)jCPointLight);
    }

    public void addSpotLight() {
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -1.0f);
        Point3f point3f = new Point3f(0.0f, 0.0f, 3.0f);
        Point3f point3f2 = new Point3f(1.0f, 0.0f, 0.0f);
        float f2 = (float)Math.PI;
        float f3 = 3.0f;
        JCSpotLight jCSpotLight = new JCSpotLight(color3f, point3f, point3f2, vector3f, f2, f3);
        jCSpotLight.setInfluencingBounds((Bounds)this.boundsphere);
        jCSpotLight.setEnable(true);
        this.addLighting((Light)jCSpotLight);
    }

    public void adjustFogDistance(double d2) {
        if (this.fog == null) {
            return;
        }
        this.centerZ = d2 + 0.5;
        this.fog.setFrontDistance((double)((float)this.viewPlatformDistance - (float)this.centerZ) + this.fogFrontDistance);
        this.fog.setBackDistance((double)((float)this.viewPlatformDistance - (float)this.centerZ + (float)this.deltaDistance) + this.fogBackDistance);
    }

    private View constructView(Canvas3D canvas3D) {
        View view = new View();
        view.addCanvas3D(canvas3D);
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        view.setFrontClipDistance(0.04);
        view.setFieldOfView(this.fieldOfView);
        return view;
    }

    private Locale constructViewBranch(View view) {
        VirtualUniverse virtualUniverse = new VirtualUniverse();
        Locale locale = new Locale(virtualUniverse);
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(0.0, 0.0, this.viewPlatformDistance));
        this.tgViewPlatform = new JCTransformGroup(transform3D);
        ViewPlatform viewPlatform = new ViewPlatform();
        this.tgViewPlatform.addChild((Node)viewPlatform);
        jCBranchGroup.addChild((Node)this.tgViewPlatform);
        locale.addBranchGraph((BranchGroup)jCBranchGroup);
        view.attachViewPlatform(viewPlatform);
        return locale;
    }

    public JCBranchGroup createSceneGraph(Canvas3D canvas3D) {
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        this.objScale = new JCTransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(1.0);
        this.objScale.setTransform(transform3D);
        jCBranchGroup.addChild((Node)this.objScale);
        this.bgContent = new JCBranchGroup();
        this.objScale.addChild((Node)this.bgContent);
        this.boundsphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.bgLighting = new JCBranchGroup();
        this.objScale.addChild((Node)this.bgLighting);
        this.bgFog = new JCBranchGroup();
        this.fogSwitch = new Switch();
        this.fogSwitch.setCapability(18);
        this.fogSwitch.setCapability(17);
        this.fogSwitch.addChild((Node)this.bgFog);
        jCBranchGroup.addChild((Node)this.fogSwitch);
        if (this.fEnableDepthCue) {
            this.fogSwitch.setWhichChild(-2);
        } else {
            this.fogSwitch.setWhichChild(-1);
        }
        return jCBranchGroup;
    }

    public void enableFog(boolean bl) {
        if (this.fog == null) {
            return;
        }
        this.fEnableDepthCue = bl;
        if (this.fEnableDepthCue) {
            this.fogSwitch.setWhichChild(-2);
        } else {
            this.fogSwitch.setWhichChild(-1);
        }
    }

    public Background getBackgroundNode() {
        return this.background;
    }

    public BoundingSphere getBoundingSphere() {
        return this.boundsphere;
    }

    protected JCCanvas3D getCanvas3D() {
        return this.myCanvas3D;
    }

    public JCBranchGroup getContent() {
        return this.bgContent;
    }

    protected Point3d getEyeCoordinate() {
        return new Point3d(0.0, 0.0, this.viewPlatformDistance);
    }

    public Fog getFog() {
        return this.fog;
    }

    public double getFogBackDistance() {
        return this.fogBackDistance;
    }

    public void getFogColor(Color3f color3f) {
        if (this.fog != null) {
            this.fog.getColor(color3f);
        }
    }

    public double getFogFrontDistance() {
        return this.fogFrontDistance;
    }

    public ArrayList getLighting() {
        return this.lights;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected JCBranchGroup getSceneBranchGroup() {
        return this.bgScene;
    }

    public double getViewPlatformDistance() {
        return this.viewPlatformDistance;
    }

    protected JCTransformGroup getViewPlatformTransformGroup() {
        return this.tgViewPlatform;
    }

    public boolean isFogEnabled() {
        return this.fEnableDepthCue;
    }

    protected void removeAllChildren(JCBranchGroup jCBranchGroup) {
        int n2 = jCBranchGroup.numChildren();
        int n3 = 0;
        while (n3 < n2) {
            jCBranchGroup.removeChild(0);
            ++n3;
        }
    }

    public void removeAllContent() {
        this.removeAllChildren(this.bgContent);
    }

    public void removeBackground() {
        this.bgBackground.detach();
        this.bgBackground = null;
        this.background = null;
    }

    private void removeBehavior(int n2) {
        Enumeration enumeration = this.bgScene.getAllChildren();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            int n4;
            Object e2 = enumeration.nextElement();
            if (e2 instanceof JCBranchGroup && (n4 = ((JCBranchGroup)((Object)e2)).getBranchGroupID()) == n2) {
                this.bgScene.removeChild(n3);
                continue;
            }
            ++n3;
        }
    }

    public void removeFog() {
        this.removeAllChildren(this.bgFog);
    }

    public void removeLighting() {
        this.removeAllChildren(this.bgLighting);
    }

    public void setFogBackDistance(double d2) {
        this.fogBackDistance = d2;
        if (this.fog != null) {
            this.fog.setBackDistance((double)((float)this.viewPlatformDistance - (float)this.centerZ + (float)this.deltaDistance) + this.fogBackDistance);
        }
    }

    public void setFogColor(Color3f color3f) {
        if (this.fog != null) {
            this.fog.setColor(color3f);
        }
    }

    public void setFogFrontDistance(double d2) {
        this.fogFrontDistance = d2;
        if (this.fog != null) {
            this.fog.setFrontDistance((double)((float)this.viewPlatformDistance - (float)this.centerZ) + this.fogFrontDistance);
        }
    }

    public void setPerspective(double d2) {
        if (d2 > 0.0) {
            double d3 = Math.atan(1.0 / d2);
            this.fieldOfView = 2.0 * d3;
            this.view.setFieldOfView(this.fieldOfView);
        }
    }

    public void setSceneAntialiasing(boolean bl) {
        this.view.setSceneAntialiasingEnable(bl);
    }

    public void setViewPlatformDistance(double d2) {
        this.viewPlatformDistance = d2;
    }

    public void setViewPlatformRotation(double d2, double d3, double d4) {
        double d5 = Math.toRadians(d2);
        double d6 = Math.toRadians(d3);
        double d7 = Math.toRadians(d4);
        Vector3d vector3d = new Vector3d(0.0, 1.0, 0.0);
        Point3d point3d = new Point3d(0.0, 0.0, this.viewPlatformDistance);
        Transform3D transform3D = new Transform3D();
        transform3D.setEuler(new Vector3d(-d5, -d6, -d7));
        transform3D.transform(vector3d);
        transform3D.transform(point3d);
        Transform3D transform3D2 = new Transform3D();
        this.tgViewPlatform.getTransform(transform3D2);
        Point3d point3d2 = new Point3d(0.0, 0.0, 0.0);
        transform3D2.lookAt(point3d, point3d2, vector3d);
        transform3D2.invert(transform3D2);
        this.tgViewPlatform.setTransform(transform3D2);
    }
}

