/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dGridData;

class GridDataAdjust {
    private double xValue;
    private double yValue;
    private double radiusOfInfluence;
    private double[] xGrid = null;
    private double[] yGrid = null;
    private double[][] zValues = null;

    protected GridDataAdjust(Chart3dGridData chart3dGridData, double d2, double d3, double d4) {
        this.xValue = d2;
        this.yValue = d3;
        this.radiusOfInfluence = d4;
        this.xGrid = chart3dGridData.getXGrid();
        this.yGrid = chart3dGridData.getYGrid();
        this.zValues = chart3dGridData.getZValues();
    }

    protected void adjustGridData(double d2) {
        int n2 = 0;
        while (n2 < this.xGrid.length) {
            double d3 = Math.abs(this.xGrid[n2] - this.xValue);
            double d4 = d3 * d3;
            int n3 = 0;
            while (n3 < this.yGrid.length) {
                double d5 = Math.abs(this.yGrid[n3] - this.yValue);
                double d6 = Math.sqrt(d4 + d5 * d5);
                double d7 = d2 * Math.exp(-d6 / this.radiusOfInfluence);
                double[] dArray = this.zValues[n2];
                int n4 = n3++;
                dArray[n4] = dArray[n4] + d7;
            }
            ++n2;
        }
    }
}

