/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.j3d.ContourDataBarsQA;
import com.klg.jclass.chart3d.j3d.ContourSurfaceTA;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCDataBars;
import com.klg.jclass.chart3d.j3d.JCDataPoints;
import com.klg.jclass.chart3d.j3d.JCGridDataBars;
import com.klg.jclass.chart3d.j3d.JCGridDataSurface;
import com.klg.jclass.chart3d.j3d.JCMeshDataSurface;
import com.klg.jclass.chart3d.j3d.JCPlotCubeJava3d;
import com.klg.jclass.chart3d.j3d.JCSolidDataSurface;
import com.klg.jclass.chart3d.j3d.JCZonedDataBars;
import com.klg.jclass.chart3d.j3d.JCZonedGridDataBars;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;

public class DrawGridJava3d
extends DrawGrid {
    protected DrawGridJava3d() {
    }

    protected DrawGridJava3d(Chart3dDataView chart3dDataView) {
        super(chart3dDataView);
    }

    private void createDataBars(JCChart3dAreaJava3d jCChart3dAreaJava3d) {
        JCDataBars jCDataBars;
        Matrix4d matrix4d = jCChart3dAreaJava3d.getTransform().getAbsolute();
        int n2 = ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).getIndex();
        Chart3dGridData chart3dGridData = this.getGridData();
        JCBar jCBar = jCChart3dAreaJava3d.getBar();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        if (this.dataView.getElevation().isTransparent()) {
            if (this.dataView.getElevation().isMeshed()) {
                if (this.dataView.getContour().isZoned()) {
                    jCDataBars = new JCZonedGridDataBars(jCBar, matrix4d, chart3dGridData, new Color3f(jCChart3dAreaJava3d.getForeground()), n2);
                    jCDataBars.showDataBarsZoned(true);
                    ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCDataBars);
                } else {
                    jCDataBars = new JCGridDataBars(jCBar, matrix4d, chart3dGridData, new Color3f(jCChart3dAreaJava3d.getForeground()), false, n2);
                    jCDataBars.showDataBarsZoned(false);
                    ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCDataBars);
                }
            }
        } else {
            if (this.dataView.getContour().isZoned()) {
                jCDataBars = new JCZonedDataBars(jCBar, matrix4d, chart3dGridData, new Color3f(jCChart3dAreaJava3d.getForeground()), this.dataView.getElevation().isTransparent() ^ true, n2);
                jCDataBars.showDataBarsZoned(this.dataView.getContour().isZoned());
                jCDataBars.setDataBarsLit(this.dataView.getElevation().isShaded());
                ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCDataBars);
            } else {
                jCDataBars = new JCGridDataBars(jCBar, matrix4d, chart3dGridData, new Color3f(jCChart3dAreaJava3d.getForeground()), true, n2);
                jCDataBars.showDataBarsZoned(false);
                jCDataBars.setDataBarsLit(this.dataView.getElevation().isShaded());
                ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCDataBars);
            }
            if (this.dataView.getElevation().isMeshed()) {
                jCDataBars = new JCGridDataBars(jCBar, matrix4d, chart3dGridData, new Color3f(jCChart3dAreaJava3d.getForeground()), false, n2);
                jCDataBars.showDataBarsZoned(false);
                ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCDataBars);
            }
        }
        if (this.dataView.getContour().isContoured()) {
            jCDataBars = new ContourDataBarsQA(jCBar, matrix4d, chart3dGridData, new Color3f(jCChart3dAreaJava3d.getForeground()), false, n2);
            jCDataBars.showDataBarsZoned(this.dataView.getContour().isZoned() && this.dataView.getElevation().isTransparent());
            ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCDataBars);
        }
    }

    private void createDataSurface(JCChart3dAreaJava3d jCChart3dAreaJava3d) {
        Matrix4d matrix4d = jCChart3dAreaJava3d.getTransform().getAbsolute();
        int n2 = ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).getIndex();
        Chart3dGridData chart3dGridData = this.getGridData();
        if (this.dataView.getElevation().isTransparent()) {
            if (this.dataView.getElevation().isMeshed() || this.dataView.getContour().isContoured()) {
                JCMeshDataSurface jCMeshDataSurface = new JCMeshDataSurface(matrix4d, chart3dGridData, this.dataView.getContour(), new Color3f(jCChart3dAreaJava3d.getForeground()), n2);
                jCMeshDataSurface.setContourLinesVisible(this.dataView.getContour().isContoured());
                jCMeshDataSurface.setMeshSurfaceVisible(this.dataView.getElevation().isMeshed());
                jCMeshDataSurface.setMeshSurfaceZoned(this.dataView.getContour().isZoned());
                jCMeshDataSurface.setContourLinesZoned(this.dataView.getContour().isZoned());
                ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCMeshDataSurface);
            }
        } else {
            JCBranchGroup jCBranchGroup;
            JCSolidDataSurface jCSolidDataSurface = new JCSolidDataSurface(matrix4d, chart3dGridData, this.dataView.getContour(), new Color3f(jCChart3dAreaJava3d.getForeground()), n2);
            jCSolidDataSurface.setSolidSurfaceZoned(this.dataView.getContour().isZoned());
            jCSolidDataSurface.setSolidSurfaceShaded(this.dataView.getElevation().isShaded());
            ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCSolidDataSurface);
            if (this.dataView.getElevation().isMeshed()) {
                jCBranchGroup = new JCGridDataSurface(matrix4d, chart3dGridData, new Color3f(jCChart3dAreaJava3d.getForeground()), n2);
                ((JCGridDataSurface)jCBranchGroup).setGridSurfaceVisible(true);
                ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCBranchGroup);
            }
            if (this.dataView.getContour().isContoured()) {
                jCBranchGroup = new ContourSurfaceTA(matrix4d, this.dataView.getContour(), new Color3f(jCChart3dAreaJava3d.getForeground()), n2);
                ((ContourSurfaceTA)jCBranchGroup).setContourSurfaceVisible(true);
                ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCBranchGroup);
            }
        }
    }

    private void createScatterPoints(JCChart3dAreaJava3d jCChart3dAreaJava3d) {
        Matrix4d matrix4d = jCChart3dAreaJava3d.getTransform().getAbsolute();
        int n2 = ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).getIndex();
        Chart3dGridData chart3dGridData = this.getGridData();
        JCDataPoints jCDataPoints = new JCDataPoints(matrix4d, chart3dGridData, this.dataView.getContour(), new Color3f(jCChart3dAreaJava3d.getForeground()), this.dataView.getContour().isZoned(), n2);
        ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).addDataGroup(jCDataPoints);
    }

    public void draw() {
        int n2 = this.dataView.getChartType();
        JCChart3dAreaJava3d jCChart3dAreaJava3d = (JCChart3dAreaJava3d)this.dataView.getChart3d().getChart3dArea();
        JCElevation jCElevation = this.dataView.getElevation();
        JCSurface jCSurface = jCChart3dAreaJava3d.getSurface();
        JCBar jCBar = jCChart3dAreaJava3d.getBar();
        Chart3dGridData chart3dGridData = this.getGridData();
        if ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube() != null) {
            ((JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube()).removeAllDataGroups();
        }
        int n3 = chart3dGridData.getNumX();
        int n4 = chart3dGridData.getNumY();
        if (n2 == 0 ? n3 < 2 || n4 < 2 : (n2 == 1 ? jCBar.getXFormat() == 2 && n3 < 2 || jCBar.getYFormat() == 2 && n4 < 2 : n3 < 1 || n4 < 1)) {
            return;
        }
        switch (this.dataView.getChartType()) {
            case 0: {
                this.createDataSurface(jCChart3dAreaJava3d);
                break;
            }
            case 1: {
                this.createDataBars(jCChart3dAreaJava3d);
                break;
            }
            case 2: {
                this.createScatterPoints(jCChart3dAreaJava3d);
                break;
            }
        }
    }
}

