/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.ContourCell;
import com.klg.jclass.chart3d.ContourSegment;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.Intersection;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.j3d.Corner;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.awt.Color;
import java.util.ArrayList;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;

public class DataSurfaceTA {
    private TriangleStripArray triangleStripArray = null;
    private ArrayList pntList = new ArrayList();
    private ArrayList clrList = new ArrayList();
    private JCContour contour = null;
    private JCContourLevels contourLevels = null;
    private ArrayList contourStyles = null;
    private double[] xGrid = null;
    private double[] yGrid = null;
    private double[][] zValues = null;
    private double holeValue = Double.MAX_VALUE;
    private Matrix4d absolute = null;

    public DataSurfaceTA(Matrix4d matrix4d, Chart3dGridData chart3dGridData, JCContour jCContour) {
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        this.absolute = matrix4d;
        this.xGrid = chart3dGridData.getXGrid();
        this.yGrid = chart3dGridData.getYGrid();
        this.zValues = chart3dGridData.getZValues();
        this.holeValue = chart3dGridData.getHoleValue();
        jCContour.calcContours();
        this.contour = jCContour;
        this.contourStyles = jCContour.getContourStyles();
        ContourCell[] contourCellArray = jCContour.getContourCells();
        this.contourLevels = jCContour.getContourLevels();
        ContourCell contourCell = null;
        Point3d point3d = null;
        Point3d point3d2 = null;
        Point3d point3d3 = null;
        Point3d point3d4 = null;
        int n2 = gridLimits.getNumY() - 1;
        int n3 = gridLimits.getNumX() - 1;
        int n4 = gridLimits.getXOffset();
        int n5 = gridLimits.getYOffset();
        int n6 = 0;
        int n7 = n4;
        while (n7 < n4 + n3) {
            int n8 = n5;
            while (n8 < n5 + n2) {
                contourCell = contourCellArray[n6];
                if (!this.containsHoleValue(n7, n8, this.holeValue)) {
                    int n9 = contourCell.getNIntersections();
                    if (n9 == 0) {
                        point3d = new Point3d(this.xGrid[n7 + 1], this.yGrid[n8], this.zValues[n7 + 1][n8]);
                        point3d2 = new Point3d(this.xGrid[n7 + 1], this.yGrid[n8 + 1], this.zValues[n7 + 1][n8 + 1]);
                        point3d3 = new Point3d(this.xGrid[n7], this.yGrid[n8 + 1], this.zValues[n7][n8 + 1]);
                        point3d4 = new Point3d(this.xGrid[n7], this.yGrid[n8], this.zValues[n7][n8]);
                        this.defineTriangle(point3d4, point3d, point3d2);
                        this.defineTriangle(point3d4, point3d2, point3d3);
                    } else {
                        this.triangulateCell(contourCell, jCContour, n7, n8);
                    }
                }
                ++n6;
                ++n8;
            }
            ++n7;
        }
        Point3d[] point3dArray = new Point3d[this.pntList.size()];
        this.pntList.toArray(point3dArray);
        Color3f[] color3fArray = new Color3f[this.clrList.size()];
        this.clrList.toArray(color3fArray);
        GeometryInfo geometryInfo = new GeometryInfo(1);
        geometryInfo.setCoordinates(point3dArray);
        geometryInfo.setColors(color3fArray);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        this.triangleStripArray = (TriangleStripArray)geometryInfo.getGeometryArray();
    }

    private boolean containsHoleValue(int n2, int n3, double d2) {
        Point3d point3d = null;
        int n4 = 0;
        while (n4 < 4) {
            point3d = this.getVertex(n4, n2, n3);
            if (point3d.z >= d2) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private void defineTriangle(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        Point3d point3d4 = new Point3d(point3d.x, point3d.y, point3d.z);
        this.absolute.transform(point3d4);
        Point3d point3d5 = new Point3d(point3d2.x, point3d2.y, point3d2.z);
        this.absolute.transform(point3d5);
        Point3d point3d6 = new Point3d(point3d3.x, point3d3.y, point3d3.z);
        this.absolute.transform(point3d6);
        this.pntList.add(point3d4);
        this.pntList.add(point3d5);
        this.pntList.add(point3d6);
        Color3f color3f = this.getContourColor3f(this.getMeanZValue(point3d, point3d2, point3d3));
        int n2 = 0;
        while (n2 < 3) {
            this.clrList.add(color3f);
            ++n2;
        }
    }

    private Color3f getContourColor3f(double d2) {
        int n2 = this.contourLevels.getLevelFromValue(d2);
        int n3 = this.contour.contourIndex(n2);
        JCContourStyle jCContourStyle = (JCContourStyle)this.contourStyles.get(n3);
        JCFillStyle jCFillStyle = jCContourStyle.getFillStyle();
        Color color = jCFillStyle.getColor();
        return new Color3f(color);
    }

    public TriangleStripArray getGeometryArray() {
        return this.triangleStripArray;
    }

    private double getMeanZValue(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        return (point3d.z + point3d2.z + point3d3.z) / 3.0;
    }

    private Point3d getVertex(int n2, int n3, int n4) {
        Point3d point3d = null;
        switch (n2) {
            case 0: {
                point3d = new Point3d(this.xGrid[n3 + 1], this.yGrid[n4], this.zValues[n3 + 1][n4]);
                break;
            }
            case 1: {
                point3d = new Point3d(this.xGrid[n3 + 1], this.yGrid[n4 + 1], this.zValues[n3 + 1][n4 + 1]);
                break;
            }
            case 2: {
                point3d = new Point3d(this.xGrid[n3], this.yGrid[n4 + 1], this.zValues[n3][n4 + 1]);
                break;
            }
            case 3: {
                point3d = new Point3d(this.xGrid[n3], this.yGrid[n4], this.zValues[n3][n4]);
                break;
            }
            default: {
                System.out.println("DataSurfaceTA.triangulateCell():  Invalid index for cell corner.");
            }
        }
        return point3d;
    }

    private void triangulateCell(ContourCell contourCell, JCContour jCContour, int n2, int n3) {
        int n4;
        Intersection intersection = null;
        ContourSegment contourSegment = null;
        ContourSegment contourSegment2 = null;
        Corner[] cornerArray = new Corner[4];
        Point3d point3d = null;
        Point3d point3d2 = null;
        Point3d point3d3 = null;
        Point3d point3d4 = null;
        Point3d point3d5 = null;
        ArrayList arrayList = null;
        Point3d point3d6 = null;
        Object var16_16 = null;
        Object var17_17 = null;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        while (n7 < 4) {
            point3d = this.getVertex(n7, n2, n3);
            cornerArray[n7] = new Corner(point3d);
            arrayList = contourCell.getIntersectionList(n7);
            if (arrayList != null) {
                n4 = 0;
                while (n4 < arrayList.size()) {
                    intersection = (Intersection)arrayList.get(n4);
                    contourSegment = intersection.getSegment1();
                    contourSegment2 = intersection.getSegment2();
                    point3d2 = contourSegment.getPoint();
                    point3d3 = contourSegment2.getPoint();
                    n5 = intersection.getSide1();
                    n6 = intersection.getSide2();
                    cornerArray[n7].setEndPoints(n5, n6, point3d2, point3d3);
                    if (n4 == 0) {
                        this.defineTriangle(point3d2, point3d, point3d3);
                    } else {
                        this.defineTriangle(point3d2, point3d4, point3d3);
                        this.defineTriangle(point3d3, point3d4, point3d5);
                    }
                    point3d4 = point3d2;
                    point3d5 = point3d3;
                    ++n4;
                }
            }
            ++n7;
        }
        arrayList = contourCell.getIntersectionList(4);
        if (arrayList != null) {
            int n8;
            ArrayList<Point3d> arrayList2;
            n4 = 0;
            while (n4 < arrayList.size()) {
                intersection = (Intersection)arrayList.get(n4);
                contourSegment = intersection.getSegment1();
                contourSegment2 = intersection.getSegment2();
                point3d2 = contourSegment.getPoint();
                point3d3 = contourSegment2.getPoint();
                n5 = intersection.getSide1();
                n6 = intersection.getSide2();
                if (n4 == 0) {
                    arrayList2 = new ArrayList();
                    if (n5 == 2) {
                        n8 = 3;
                        while (n8 >= 0) {
                            arrayList2.add(cornerArray[n8].point1);
                            if (cornerArray[n8].fIntersected) {
                                arrayList2.add(cornerArray[n8].point2);
                            }
                            n8 -= 3;
                        }
                    } else {
                        n8 = 0;
                        while (n8 < 2) {
                            arrayList2.add(cornerArray[n8].point1);
                            if (cornerArray[n8].fIntersected) {
                                arrayList2.add(cornerArray[n8].point2);
                            }
                            ++n8;
                        }
                    }
                    this.triangulateRegion(point3d3, point3d2, arrayList2);
                } else {
                    this.defineTriangle(point3d3, point3d2, point3d4);
                    this.defineTriangle(point3d3, point3d4, point3d5);
                }
                point3d4 = point3d2;
                point3d5 = point3d3;
                ++n4;
            }
            if (n5 == 2) {
                arrayList2 = new ArrayList<Point3d>();
                n8 = 1;
                while (n8 <= 2) {
                    arrayList2.add(cornerArray[n8].point1);
                    if (cornerArray[n8].fIntersected) {
                        arrayList2.add(cornerArray[n8].point2);
                    }
                    ++n8;
                }
                this.triangulateRegion(point3d2, point3d3, arrayList2);
            } else {
                arrayList2 = new ArrayList();
                n8 = 2;
                while (n8 <= 3) {
                    arrayList2.add(cornerArray[n8].point1);
                    if (cornerArray[n8].fIntersected) {
                        arrayList2.add(cornerArray[n8].point2);
                    }
                    ++n8;
                }
                this.triangulateRegion(point3d2, point3d3, arrayList2);
            }
        } else {
            ArrayList<Point3d> arrayList3 = new ArrayList<Point3d>();
            int n9 = 0;
            while (n9 < 4) {
                arrayList3.add(cornerArray[n9].point1);
                if (cornerArray[n9].fIntersected) {
                    arrayList3.add(cornerArray[n9].point2);
                }
                ++n9;
            }
            point3d6 = (Point3d)arrayList3.get(0);
            this.triangulatePolygon(point3d6, arrayList3, 1);
        }
    }

    private void triangulatePolygon(Point3d point3d, ArrayList arrayList, int n2) {
        Point3d point3d2 = null;
        Point3d point3d3 = null;
        int n3 = n2;
        while (n3 < arrayList.size() - 1) {
            point3d2 = (Point3d)arrayList.get(n3);
            point3d3 = (Point3d)arrayList.get(n3 + 1);
            this.defineTriangle(point3d, point3d2, point3d3);
            ++n3;
        }
    }

    private void triangulateRegion(Point3d point3d, Point3d point3d2, ArrayList arrayList) {
        Point3d point3d3 = (Point3d)arrayList.get(0);
        this.defineTriangle(point3d, point3d2, point3d3);
        this.triangulatePolygon(point3d, arrayList, 0);
    }
}

