/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.ContourCell;
import com.klg.jclass.chart3d.ContourSegment;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.Intersection;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.j3d.Corner;
import java.awt.Color;
import java.util.ArrayList;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;

class DataSurfaceLA {
    private LineArray gridLineArray = null;
    private ArrayList gridPntList = new ArrayList();
    private ArrayList gridClrList = new ArrayList();
    private LineArray[] contourLineArray = null;
    private ArrayList[] contourPntList = null;
    private ArrayList[] contourClrList = null;
    private JCContour contour = null;
    private JCContourLevels contourLevels = null;
    private ArrayList contourStyles = null;
    private double[] xGrid = null;
    private double[] yGrid = null;
    private double[][] zValues = null;
    private Matrix4d absolute = null;
    private double holeValue = Double.MAX_VALUE;

    public DataSurfaceLA(Matrix4d matrix4d, Chart3dGridData chart3dGridData, JCContour jCContour) {
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        this.absolute = matrix4d;
        this.xGrid = chart3dGridData.getXGrid();
        this.yGrid = chart3dGridData.getYGrid();
        this.zValues = chart3dGridData.getZValues();
        this.holeValue = chart3dGridData.getHoleValue();
        jCContour.calcContours();
        this.contour = jCContour;
        this.contourStyles = jCContour.getContourStyles();
        ContourCell[] contourCellArray = jCContour.getContourCells();
        this.contourLevels = jCContour.getContourLevels();
        int n2 = this.contourLevels.getNumLevels();
        this.contourPntList = new ArrayList[n2];
        this.contourClrList = new ArrayList[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.contourPntList[n3] = new ArrayList();
            this.contourClrList[n3] = new ArrayList();
            ++n3;
        }
        ContourCell contourCell = null;
        Point3d point3d = null;
        Point3d point3d2 = null;
        Point3d point3d3 = null;
        Point3d point3d4 = null;
        int n4 = gridLimits.getNumY() - 1;
        int n5 = gridLimits.getNumX() - 1;
        int n6 = gridLimits.getXOffset();
        int n7 = gridLimits.getYOffset();
        int n8 = 0;
        int n9 = n6;
        while (n9 < n6 + n5) {
            int n10 = n7;
            while (n10 < n7 + n4) {
                contourCell = contourCellArray[n8];
                int n11 = contourCell.getNIntersections();
                if (n11 == 0) {
                    point3d = new Point3d(this.xGrid[n9 + 1], this.yGrid[n10], this.zValues[n9 + 1][n10]);
                    point3d2 = new Point3d(this.xGrid[n9 + 1], this.yGrid[n10 + 1], this.zValues[n9 + 1][n10 + 1]);
                    point3d3 = new Point3d(this.xGrid[n9], this.yGrid[n10 + 1], this.zValues[n9][n10 + 1]);
                    point3d4 = new Point3d(this.xGrid[n9], this.yGrid[n10], this.zValues[n9][n10]);
                    this.defineLineSegment(point3d, point3d2);
                    this.defineLineSegment(point3d2, point3d3);
                    if (n9 == 0) {
                        this.defineLineSegment(point3d3, point3d4);
                    }
                    if (n10 == 0) {
                        this.defineLineSegment(point3d4, point3d);
                    }
                } else {
                    this.defineCellSections(contourCell, jCContour, n9, n10);
                }
                ++n8;
                ++n10;
            }
            ++n9;
        }
        this.gridLineArray = this.createLineArray(this.gridPntList, this.gridClrList);
        this.contourLineArray = this.createContourLineArrays(n2, this.contourPntList, this.contourClrList);
    }

    private LineArray[] createContourLineArrays(int n2, ArrayList[] arrayListArray, ArrayList[] arrayListArray2) {
        LineArray[] lineArrayArray = new LineArray[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (arrayListArray[n3].size() > 0) {
                Point3d[] point3dArray = new Point3d[arrayListArray[n3].size()];
                arrayListArray[n3].toArray(point3dArray);
                Color3f[] color3fArray = new Color3f[arrayListArray2[n3].size()];
                arrayListArray2[n3].toArray(color3fArray);
                lineArrayArray[n3] = new LineArray(point3dArray.length, 5);
                lineArrayArray[n3].setCoordinates(0, point3dArray);
                lineArrayArray[n3].setColors(0, color3fArray);
            } else {
                lineArrayArray[n3] = null;
            }
            ++n3;
        }
        return lineArrayArray;
    }

    private LineArray createLineArray(ArrayList arrayList, ArrayList arrayList2) {
        Point3d[] point3dArray = new Point3d[arrayList.size()];
        arrayList.toArray(point3dArray);
        Color3f[] color3fArray = new Color3f[arrayList2.size()];
        arrayList2.toArray(color3fArray);
        LineArray lineArray = new LineArray(point3dArray.length, 5);
        lineArray.setCoordinates(0, point3dArray);
        lineArray.setColors(0, color3fArray);
        return lineArray;
    }

    private void defineCellSections(ContourCell contourCell, JCContour jCContour, int n2, int n3) {
        int n4;
        Intersection intersection = null;
        ContourSegment contourSegment = null;
        ContourSegment contourSegment2 = null;
        Corner[] cornerArray = new Corner[4];
        Point3d point3d = null;
        Point3d point3d2 = null;
        Point3d point3d3 = null;
        Point3d point3d4 = null;
        Point3d point3d5 = null;
        ArrayList arrayList = null;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        while (n7 < 4) {
            point3d = this.getVertex(n7, n2, n3);
            cornerArray[n7] = new Corner(point3d);
            arrayList = contourCell.getIntersectionList(n7);
            if (arrayList != null) {
                n4 = 0;
                while (n4 < arrayList.size()) {
                    intersection = (Intersection)arrayList.get(n4);
                    contourSegment = intersection.getSegment1();
                    contourSegment2 = intersection.getSegment2();
                    point3d2 = contourSegment.getPoint();
                    point3d3 = contourSegment2.getPoint();
                    n5 = intersection.getSide1();
                    n6 = intersection.getSide2();
                    cornerArray[n7].setEndPoints(n5, n6, point3d2, point3d3);
                    if (n4 == 0) {
                        this.defineCornerSegments(n2, n3, n5, n6, point3d2, point3d3, point3d, point3d);
                    } else {
                        this.defineCornerSegments(n2, n3, n5, n6, point3d2, point3d3, point3d4, point3d5);
                    }
                    point3d4 = point3d2;
                    point3d5 = point3d3;
                    ++n4;
                }
            }
            ++n7;
        }
        arrayList = contourCell.getIntersectionList(4);
        if (arrayList != null) {
            Point3d point3d6;
            Point3d point3d7;
            n4 = 0;
            while (n4 < arrayList.size()) {
                intersection = (Intersection)arrayList.get(n4);
                contourSegment = intersection.getSegment1();
                contourSegment2 = intersection.getSegment2();
                point3d2 = contourSegment.getPoint();
                point3d3 = contourSegment2.getPoint();
                n5 = intersection.getSide1();
                n6 = intersection.getSide2();
                if (n4 == 0) {
                    if (n5 == 2) {
                        this.defineContourLineSegment(point3d2, point3d3);
                        point3d7 = null;
                        point3d6 = null;
                        point3d7 = cornerArray[0].fIntersected ? cornerArray[0].point2 : cornerArray[0].point1;
                        this.defineLineSegment(point3d3, point3d7);
                        if (n2 == 0) {
                            point3d6 = cornerArray[3].point1;
                            this.defineLineSegment(point3d2, point3d6);
                        }
                        if (n3 == 0) {
                            point3d7 = cornerArray[0].point1;
                            point3d6 = cornerArray[3].fIntersected ? cornerArray[3].point2 : cornerArray[3].point1;
                            this.defineLineSegment(point3d6, point3d7);
                        }
                    } else {
                        this.defineContourLineSegment(point3d2, point3d3);
                        point3d7 = null;
                        point3d7 = cornerArray[1].fIntersected ? cornerArray[1].point2 : cornerArray[1].point1;
                        this.defineLineSegment(point3d3, point3d7);
                        point3d7 = cornerArray[1].point1;
                        point3d6 = null;
                        point3d6 = cornerArray[0].fIntersected ? cornerArray[0].point2 : cornerArray[0].point1;
                        this.defineLineSegment(point3d6, point3d7);
                        if (n3 == 0) {
                            point3d6 = cornerArray[0].point1;
                            this.defineLineSegment(point3d2, point3d6);
                        }
                    }
                } else {
                    this.defineContourLineSegment(point3d2, point3d3);
                    this.defineLineSegment(point3d3, point3d5);
                    if (n5 == 2) {
                        if (n2 == 0) {
                            this.defineLineSegment(point3d2, point3d4);
                        }
                    } else if (n3 == 0) {
                        this.defineLineSegment(point3d2, point3d4);
                    }
                }
                point3d4 = point3d2;
                point3d5 = point3d3;
                ++n4;
            }
            if (n5 == 2) {
                point3d7 = cornerArray[1].point1;
                this.defineLineSegment(point3d3, point3d7);
                point3d6 = null;
                point3d7 = cornerArray[1].fIntersected ? cornerArray[1].point2 : cornerArray[1].point1;
                point3d6 = cornerArray[2].point1;
                this.defineLineSegment(point3d6, point3d7);
                if (n2 == 0) {
                    point3d6 = cornerArray[2].fIntersected ? cornerArray[2].point2 : cornerArray[2].point1;
                    this.defineLineSegment(point3d2, point3d6);
                }
            } else {
                point3d7 = cornerArray[2].point1;
                this.defineLineSegment(point3d3, point3d7);
                if (n2 == 0) {
                    point3d7 = cornerArray[2].fIntersected ? cornerArray[2].point2 : cornerArray[2].point1;
                    point3d6 = cornerArray[3].point1;
                    this.defineLineSegment(point3d7, point3d6);
                }
                if (n3 == 0) {
                    point3d6 = null;
                    point3d6 = cornerArray[3].fIntersected ? cornerArray[3].point2 : cornerArray[3].point1;
                    this.defineLineSegment(point3d6, point3d2);
                }
            }
        } else {
            point3d2 = cornerArray[0].fIntersected ? cornerArray[0].point2 : cornerArray[0].point1;
            point3d3 = cornerArray[1].point1;
            this.defineLineSegment(point3d2, point3d3);
            point3d2 = cornerArray[1].fIntersected ? cornerArray[1].point2 : cornerArray[1].point1;
            point3d3 = cornerArray[2].point1;
            this.defineLineSegment(point3d2, point3d3);
            if (n2 == 0) {
                point3d2 = cornerArray[2].fIntersected ? cornerArray[2].point2 : cornerArray[2].point1;
                point3d3 = cornerArray[3].point1;
                this.defineLineSegment(point3d2, point3d3);
            }
            if (n3 == 0) {
                point3d2 = cornerArray[3].fIntersected ? cornerArray[3].point2 : cornerArray[3].point1;
                point3d3 = cornerArray[0].point1;
                this.defineLineSegment(point3d2, point3d3);
            }
        }
    }

    private void defineContourLineSegment(Point3d point3d, Point3d point3d2) {
        Point3d point3d3 = new Point3d(point3d.x, point3d.y, point3d.z);
        this.absolute.transform(point3d3);
        Point3d point3d4 = new Point3d(point3d2.x, point3d2.y, point3d2.z);
        this.absolute.transform(point3d4);
        double d2 = this.getMeanZValue(point3d, point3d2);
        int n2 = this.contourLevels.getLevelFromValue(d2);
        this.contourPntList[n2].add(point3d3);
        this.contourPntList[n2].add(point3d4);
        Color3f color3f = this.getContourColor3f(d2);
        this.contourClrList[n2].add(color3f);
        this.contourClrList[n2].add(color3f);
    }

    private void defineCornerSegments(int n2, int n3, int n4, int n5, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        this.defineContourLineSegment(point3d, point3d2);
        if (n5 == 0) {
            this.defineLineSegment(point3d2, point3d4);
        }
        if (n5 == 1) {
            this.defineLineSegment(point3d2, point3d4);
            this.defineLineSegment(point3d, point3d3);
        }
        if (n4 == 1) {
            this.defineLineSegment(point3d2, point3d4);
            this.defineLineSegment(point3d, point3d3);
        }
        if (n2 == 0) {
            if (n4 == 2) {
                this.defineLineSegment(point3d, point3d3);
            }
            if (n5 == 2) {
                this.defineLineSegment(point3d2, point3d4);
            }
        }
        if (n3 == 0) {
            if (n4 == 3) {
                this.defineLineSegment(point3d, point3d3);
            }
            if (n5 == 3) {
                this.defineLineSegment(point3d2, point3d4);
            }
        }
    }

    private void defineLineSegment(Point3d point3d, Point3d point3d2) {
        if (point3d.z >= this.holeValue || point3d2.z >= this.holeValue) {
            return;
        }
        Point3d point3d3 = new Point3d(point3d.x, point3d.y, point3d.z);
        this.absolute.transform(point3d3);
        Point3d point3d4 = new Point3d(point3d2.x, point3d2.y, point3d2.z);
        this.absolute.transform(point3d4);
        this.gridPntList.add(point3d3);
        this.gridPntList.add(point3d4);
        Color3f color3f = this.getContourColor3f(this.getMeanZValue(point3d, point3d2));
        this.gridClrList.add(color3f);
        this.gridClrList.add(color3f);
    }

    private Color3f getContourColor3f(double d2) {
        int n2 = this.contourLevels.getLevelFromValue(d2);
        int n3 = this.contour.contourIndex(n2);
        JCContourStyle jCContourStyle = (JCContourStyle)this.contourStyles.get(n3);
        JCFillStyle jCFillStyle = jCContourStyle.getFillStyle();
        Color color = jCFillStyle.getColor();
        return new Color3f(color);
    }

    public LineArray[] getContourGeometry() {
        return this.contourLineArray;
    }

    public Geometry getGridGeometry() {
        return this.gridLineArray;
    }

    private double getMeanZValue(Point3d point3d, Point3d point3d2) {
        return (point3d.z + point3d2.z) / 2.0;
    }

    private Point3d getVertex(int n2, int n3, int n4) {
        Point3d point3d = null;
        switch (n2) {
            case 0: {
                point3d = new Point3d(this.xGrid[n3 + 1], this.yGrid[n4], this.zValues[n3 + 1][n4]);
                break;
            }
            case 1: {
                point3d = new Point3d(this.xGrid[n3 + 1], this.yGrid[n4 + 1], this.zValues[n3 + 1][n4 + 1]);
                break;
            }
            case 2: {
                point3d = new Point3d(this.xGrid[n3], this.yGrid[n4 + 1], this.zValues[n3][n4 + 1]);
                break;
            }
            case 3: {
                point3d = new Point3d(this.xGrid[n3], this.yGrid[n4], this.zValues[n3][n4]);
                break;
            }
            default: {
                System.out.println("DataSurfaceLA.getVertex():  Invalid index for cell corner.");
            }
        }
        return point3d;
    }
}

