/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j3d.Chart3dDataViewJava3d;
import com.klg.jclass.chart3d.j3d.DataAdjust;
import com.klg.jclass.chart3d.j3d.DataAdjustGrid;
import com.klg.jclass.chart3d.j3d.DataAdjustPoint;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCChart3dJava3d;
import com.klg.jclass.chart3d.j3d.JCPlotCubeJava3d;
import com.klg.jclass.chart3d.j3d.JCShape3D;
import com.klg.jclass.chart3d.j3d.ZLine;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class DataAdjustmentAxis {
    private JCChart3dJava3d chart3d = null;
    private JCPlotCubeJava3d plotCube = null;
    private DataAdjust dataAdjust = null;
    private Chart3dData data = null;
    private Chart3dDataViewJava3d dataView = null;
    private JCChart3dAreaJava3d area = null;
    private JCContour contour = null;
    private double zStartPoint = 3.0;
    private double zEndPoint = -3.0;
    private Color3f axisColor = null;

    public DataAdjustmentAxis(JCChart3dJava3d jCChart3dJava3d, Point3d point3d, double d2) {
        this.chart3d = jCChart3dJava3d;
        this.area = (JCChart3dAreaJava3d)jCChart3dJava3d.getChart3dArea();
        this.plotCube = (JCPlotCubeJava3d)this.area.getPlotCube();
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        Point3d point3d2 = new Point3d(point3d.x, point3d.y, this.zStartPoint);
        Point3d point3d3 = new Point3d(point3d.x, point3d.y, this.zEndPoint);
        this.axisColor = new Color3f(1.0f, 0.0f, 0.0f);
        ZLine zLine = new ZLine(point3d2, point3d3, this.axisColor);
        Appearance appearance = new Appearance();
        JCShape3D jCShape3D = new JCShape3D((Geometry)zLine, appearance);
        jCShape3D.setPickable(false);
        jCBranchGroup.addChild((Node)jCShape3D);
        this.plotCube.addPickAxis(jCBranchGroup);
        this.dataView = (Chart3dDataViewJava3d)jCChart3dJava3d.getDataView(0);
        this.data = this.dataView.getElevationData();
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = transform.getInverseAbsolute();
        matrix4d.transform(point3d);
        this.dataAdjust = this.data instanceof Chart3dGridData ? new DataAdjustGrid((Chart3dGridData)this.data, point3d.x, point3d.y, d2) : new DataAdjustPoint((Chart3dPointData)this.data, point3d.x, point3d.y, d2);
        this.contour = this.dataView.getContour();
    }

    public Color3f getAxisColor() {
        return this.axisColor;
    }

    public double getEndPointZCoord() {
        return this.zEndPoint;
    }

    public double getStartPointZCoord() {
        return this.zStartPoint;
    }

    public boolean isBusy() {
        return this.area.getChart3dUniverse().getVirtualUniverse().getCanvas3D().getWaitRenderFlag();
    }

    public void setAxisColor(Color3f color3f) {
        this.axisColor = color3f;
    }

    public void setEndPointZCoord(double d2) {
        this.zEndPoint = d2;
    }

    public void setStartPointZCoord(double d2) {
        this.zStartPoint = d2;
    }

    public void setZCoord(double d2) {
        this.area.getChart3dUniverse().getVirtualUniverse().getCanvas3D().setWaitRenderFlag(true);
        Vector3d vector3d = new Vector3d(0.0, 0.0, d2);
        this.dataAdjust.adjustData(vector3d.z);
        this.dataView.createDataViewObject();
    }
}

