/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.j3d.DataAdjust;
import javax.vecmath.Point3d;

public class DataAdjustPoint
extends DataAdjust {
    protected double scalefactor = 1.0;
    protected Chart3dPointData pointData = null;

    public DataAdjustPoint(Chart3dPointData chart3dPointData, double d2, double d3, double d4) {
        this.pointData = chart3dPointData;
        this.xValue = d2;
        this.yValue = d3;
        this.holeValue = chart3dPointData.getHoleValue();
        double d5 = chart3dPointData.getDataMax() - chart3dPointData.getDataMin();
        this.scalefactor = d5 / 50.0;
    }

    public void adjustData(double d2) {
        int n2 = 0;
        while (n2 < this.pointData.getNumSeries()) {
            Chart3dPointSeries chart3dPointSeries = this.pointData.getSeries(n2);
            JCChart3dStyle jCChart3dStyle = chart3dPointSeries.getChartStyle();
            int n3 = 0;
            while (n3 < chart3dPointSeries.getNumPoints()) {
                Point3d point3d = chart3dPointSeries.getPoint(n3);
                if (point3d.x == this.xValue && point3d.y == this.yValue && point3d.z != this.holeValue) {
                    point3d.z += d2 * this.scalefactor;
                }
                ++n3;
            }
            ++n2;
        }
    }
}

