/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.j3d.DataAdjust;

public class DataAdjustGrid
extends DataAdjust {
    protected int chartType = -1;
    protected double scalefactor = 1.0;
    protected Chart3dGridData gridData = null;
    protected double[] xGrid = null;
    protected double[] yGrid = null;
    protected double[][] zValues = null;

    public DataAdjustGrid(Chart3dGridData chart3dGridData, double d2, double d3, double d4) {
        this.xValue = d2;
        this.yValue = d3;
        if (d4 <= 0.0) {
            d4 = 1.0E-8;
        }
        this.radiusOfInfluence = d4;
        this.xGrid = chart3dGridData.getXGrid();
        this.yGrid = chart3dGridData.getYGrid();
        this.zValues = chart3dGridData.getZValues();
        this.gridData = chart3dGridData;
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        this.chartType = chart3dDataView.getChartType();
        this.holeValue = chart3dGridData.getHoleValue();
        double d5 = chart3dGridData.getDataMax() - chart3dGridData.getDataMin();
        this.scalefactor = d5 / 50.0;
    }

    public void adjustData(double d2) {
        if (this.chartType == 0) {
            int n2 = 0;
            while (n2 < this.xGrid.length) {
                double d3 = Math.abs(this.xGrid[n2] - this.xValue);
                double d4 = d3 * d3;
                int n3 = 0;
                while (n3 < this.yGrid.length) {
                    if (this.zValues[n2][n3] != this.holeValue) {
                        double d5 = Math.abs(this.yGrid[n3] - this.yValue);
                        double d6 = Math.sqrt(d4 + d5 * d5);
                        double d7 = this.scalefactor * d2 * Math.exp(-d6 / this.radiusOfInfluence);
                        double[] dArray = this.zValues[n2];
                        int n4 = n3;
                        dArray[n4] = dArray[n4] + d7;
                    }
                    ++n3;
                }
                ++n2;
            }
        } else {
            int n5;
            int n6 = this.gridData.getXClosest(this.xValue);
            if (this.zValues[n6][n5 = this.gridData.getYClosest(this.yValue)] != this.holeValue) {
                double[] dArray = this.zValues[n6];
                int n7 = n5;
                dArray[n7] = dArray[n7] + d2 * this.scalefactor;
            }
        }
    }
}

