/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Anno;
import com.klg.jclass.chart3d.Chart3dAnnoHandler;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.Justify;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j2d.actions.RotateAction;
import com.klg.jclass.chart3d.j3d.JCAppearance;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCColoringAttributes;
import com.klg.jclass.chart3d.j3d.JCPlotCubeJava3d;
import com.klg.jclass.chart3d.j3d.JCShape3D;
import com.klg.jclass.chart3d.j3d.PlotCubeTransformGroup;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

class AnnoJava3d
extends Anno {
    protected AnnoJava3d(JCChart3dAreaJava3d jCChart3dAreaJava3d) {
        super(jCChart3dAreaJava3d);
    }

    protected void addTickMarks(JCAxis jCAxis, Matrix4d matrix4d, Justify justify, double d2, boolean bl) {
        JCPlotCubeJava3d jCPlotCubeJava3d = (JCPlotCubeJava3d)this.area.getPlotCube();
        Chart3dAnnoHandler chart3dAnnoHandler = jCAxis.getAnnoHandler();
        int n2 = jCAxis.getAnnoFontCubeSize();
        double d3 = chart3dAnnoHandler.getAnnoHeight();
        double d4 = (double)n2 * 0.002 / d3;
        if (this.u0 == null) {
            this.u0 = new Point4d();
            this.u1 = new Point4d();
        }
        this.u0.set(0.0, 0.0, 0.0, 1.0);
        this.u1.set(0.0, justify.isAbove() ? -d2 / (2.0 * d4) : d2 / (2.0 * d4), 0.0, 1.0);
        if (bl) {
            this.u1.y *= 0.6;
        }
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        TransformGroup transformGroup = this.createTransformGroup(matrix4d, d4);
        LineArray lineArray = new LineArray(2, 5);
        Point3d[] point3dArray = new Point3d[2];
        Color3f[] color3fArray = new Color3f[2];
        point3dArray[0] = new Point3d(this.u0.x, this.u0.y, this.u0.z);
        point3dArray[1] = new Point3d(this.u1.x, this.u1.y, this.u1.z);
        color3fArray[0] = new Color3f(jCPlotCubeJava3d.getForeground());
        color3fArray[1] = new Color3f(jCPlotCubeJava3d.getForeground());
        lineArray.setCoordinates(0, point3dArray);
        lineArray.setColors(0, color3fArray);
        lineArray.setCapability(18);
        lineArray.setCapability(17);
        lineArray.setCapability(8);
        lineArray.setCapability(0);
        JCShape3D jCShape3D = new JCShape3D((Geometry)lineArray);
        JCAppearance jCAppearance = new JCAppearance();
        Material material = new Material();
        material.setLightingEnable(false);
        jCAppearance.setMaterial(material);
        JCColoringAttributes jCColoringAttributes = new JCColoringAttributes();
        jCColoringAttributes.setColor(new Color3f(this.area.getPlotCube().getDrawForeground()));
        jCAppearance.setColoringAttributes(jCColoringAttributes);
        jCShape3D.setAppearance(jCAppearance);
        transformGroup.addChild((Node)jCShape3D);
        jCBranchGroup.addChild((Node)transformGroup);
        jCPlotCubeJava3d.addAnnotationBranchGroup(jCBranchGroup);
    }

    private TransformGroup createTransformGroup(Matrix4d matrix4d, double d2) {
        Transform3D transform3D = new Transform3D();
        double d3 = matrix4d.getScale();
        Vector3d vector3d = new Vector3d();
        matrix4d.get(vector3d);
        Matrix3d matrix3d = new Matrix3d();
        matrix4d.get(matrix3d);
        transform3D.setScale(d2);
        transform3D.setTranslation(vector3d);
        transform3D.setRotation(matrix3d);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        return transformGroup;
    }

    protected void cubeDrawString(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d, String string, boolean bl) {
        Font font;
        if (graphics == null || jCAxis == null || string == null || string.length() == 0) {
            return;
        }
        Font font2 = font = bl ? jCAxis.getTitleFont() : jCAxis.getAnnoFont();
        if (font == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Chart3dAnnoHandler chart3dAnnoHandler = jCAxis.getAnnoHandler();
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n2 = 0;
        double d2 = 0.0;
        if (bl) {
            n2 = jCAxis.getTitleFontCubeSize();
            d2 = rectangle2D.getHeight();
        } else {
            n2 = jCAxis.getAnnoFontCubeSize();
            d2 = chart3dAnnoHandler.getAnnoHeight();
        }
        double d3 = bl ? -rectangle2D.getY() - d2 / 2.0 : chart3dAnnoHandler.getAnnoShift();
        double d4 = (double)n2 * 0.002 / d2;
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        TransformGroup transformGroup = this.createTransformGroup(matrix4d, d4);
        Font3D font3D = new Font3D(new Font(font.getName(), 1, font.getSize()), new FontExtrusion());
        Text3D text3D = new Text3D(font3D, string, new Point3f((float)(-rectangle2D.getX()), (float)(-d3), 0.0f));
        JCShape3D jCShape3D = new JCShape3D();
        JCAppearance jCAppearance = new JCAppearance();
        Material material = new Material();
        material.setLightingEnable(false);
        jCAppearance.setMaterial(material);
        JCColoringAttributes jCColoringAttributes = new JCColoringAttributes();
        jCColoringAttributes.setColor(new Color3f(this.area.getPlotCube().getDrawForeground()));
        jCAppearance.setColoringAttributes(jCColoringAttributes);
        jCShape3D.setGeometry((Geometry)text3D);
        jCShape3D.setAppearance(jCAppearance);
        transformGroup.addChild((Node)jCShape3D);
        jCBranchGroup.addChild((Node)transformGroup);
        JCPlotCubeJava3d jCPlotCubeJava3d = (JCPlotCubeJava3d)this.area.getPlotCube();
        jCPlotCubeJava3d.addAnnotationBranchGroup(jCBranchGroup);
    }

    public void draw3dAnno(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.area.getPlotCube().getDrawForeground());
        ((JCPlotCubeJava3d)((JCChart3dAreaJava3d)this.area).getPlotCube()).removeAllAnnotation();
        Matrix4d matrix4d = this.area.getTransform().getTextView();
        this.draw3dAxis(graphics, this.area.getAxis(3), matrix4d);
        this.draw3dAxis(graphics, this.area.getAxis(1), matrix4d);
        this.draw3dAxis(graphics, this.area.getAxis(2), matrix4d);
    }

    protected void draw3dAxis(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d) {
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        boolean[] blArray = this.area.getCube().getAnnotateEdge();
        Chart3dDataView chart3dDataView = this.area.getChart3d().getDataView(0);
        Justify justify = new Justify();
        int n2 = -1;
        double d2 = 1.0;
        switch (jCAxis.getAxisId()) {
            case 1: {
                n2 = 0;
                d2 = jCPlotCube.getXNormalizedScale();
                break;
            }
            case 2: {
                n2 = 4;
                d2 = jCPlotCube.getYNormalizedScale();
                break;
            }
            case 3: {
                n2 = 8;
                d2 = jCPlotCube.getZNormalizedScale();
                break;
            }
            default: {
                return;
            }
        }
        double d3 = (double)jCAxis.getAnnoFontCubeSize() * 0.002;
        double d4 = (double)jCAxis.getTitleFontCubeSize() * 0.002;
        this.determineVertical(n2, justify);
        int n3 = n2;
        while (n3 <= n2 + 3) {
            if (blArray[n3]) {
                double d5 = jCAxis.getAnnoMin();
                double d6 = jCAxis.getAnnoMax();
                double d7 = jCAxis.getAnnoStep() / 2.0;
                double d8 = jCAxis.getDataportMin();
                double d9 = jCAxis.getDataportMax();
                this.edgeMatrix = this.getEdgeMatrix(n3);
                this.orientationMatrix = this.getOrientationMatrix(n3, justify);
                Matrix4d matrix4d2 = new Matrix4d();
                matrix4d2.setIdentity();
                matrix4d2.mul(this.area.getTransform().getRotation());
                Transform.scaleMatrix(matrix4d2, jCPlotCube.getXNormalizedScale(), jCPlotCube.getYNormalizedScale(), jCPlotCube.getZNormalizedScale());
                Vector3d vector3d = new Vector3d();
                matrix4d2.get(vector3d);
                this.axisMatrix.setIdentity();
                this.axisMatrix.setTranslation(vector3d);
                this.axisMatrix.setScale(matrix4d2.getScale());
                this.axisMatrix.mul(this.edgeMatrix);
                ArrayList arrayList = jCAxis.getAnnoHandler().getValueLabels();
                if (arrayList != null && arrayList.size() != 0) {
                    double d10;
                    int n4 = 0;
                    while (n4 < arrayList.size()) {
                        JCValueLabel jCValueLabel = (JCValueLabel)arrayList.get(n4);
                        double d11 = jCValueLabel.getValue();
                        if (d5 <= d11 && d11 <= d6) {
                            String string = jCValueLabel.getLabel();
                            this.matrix.set(this.axisMatrix);
                            d10 = (2.0 * (d11 - d8) / (d9 - d8) - 1.0) * d2;
                            Transform.translateMatrix(this.matrix, d10, 0.0, 0.0);
                            this.matrix.mul(this.orientationMatrix);
                            Transform.scaleMatrix(this.matrix, 1.0, -1.0, 1.0);
                            double d12 = this.cubeTextWidth(graphics, jCAxis, string, false, true);
                            double d13 = d12 * 0.002;
                            this.drawAnnotation(graphics, jCAxis, this.matrix, string, justify, d3, d13, jCValueLabel.isTickOnly());
                        }
                        ++n4;
                    }
                    if (jCAxis.getTitle() != null) {
                        this.matrix.mul(this.axisMatrix, this.orientationMatrix);
                        Transform.scaleMatrix(this.matrix, 1.0, -1.0, 1.0);
                        double d14 = this.cubeTextWidth(graphics, jCAxis, jCAxis.getTitle(), true, true);
                        double d15 = d14 * 0.002;
                        d10 = jCAxis.getAnnoEaseway();
                        if (justify.above) {
                            d10 = -d10;
                        }
                        Transform.translateMatrix(this.matrix, -d15 / 2.0, d10, 0.0);
                        if (justify.doSpinTitle()) {
                            Transform.translateMatrix(this.matrix, d15, 0.0, 0.0);
                            Transform.rotateMatrix(this.matrix, 3, 3);
                        }
                        if (justify.doFlipY()) {
                            Transform.translateMatrix(this.matrix, d15, 0.0, 0.0);
                            Transform.rotateMatrix(this.matrix, 3, 2);
                        }
                        if (justify.doFlipX()) {
                            Transform.rotateMatrix(this.matrix, 3, 1);
                        }
                        this.cubeDrawString(graphics, jCAxis, this.matrix, jCAxis.getTitle(), true);
                    }
                }
            }
            ++n3;
        }
    }

    protected void drawAnnotation(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d, String string, Justify justify, double d2, double d3, boolean bl) {
        this.addTickMarks(jCAxis, matrix4d, justify, d2, bl);
        if (bl || string == null || string.length() == 0) {
            return;
        }
        this.justifyMatrix = this.getJustifyMatrix(d2, d3, justify);
        this.matrix.mul(matrix4d, this.justifyMatrix);
        this.cubeDrawString(graphics, jCAxis, this.matrix, string, false);
    }

    protected Matrix4d getOrientationMatrix(int n2, Justify justify) {
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = transform.getRotation();
        if (this.orientationMatrix == null) {
            this.orientationMatrix = new Matrix4d();
        }
        this.orientationMatrix.setIdentity();
        justify.setFlipX(false);
        justify.setFlipY(false);
        justify.setSpinTitle(false);
        if (this.planeMatrixInit == null) {
            this.planeMatrixInit = new Matrix4d();
            this.planeMatrixInit.setIdentity();
            Transform.scaleMatrix(this.planeMatrixInit, 1.0, -1.0, 1.0);
            this.planeMatrixInit.mul(transform.getPerspective());
            this.planeMatrixInit.mul(matrix4d);
        }
        this.matrix.mul(this.planeMatrixInit, this.edgeMatrix);
        if (this.u0 == null) {
            this.u0 = new Point4d();
            this.u1 = new Point4d();
            this.u2 = new Point4d();
            this.u3 = new Point4d();
        }
        this.u0.set(0.0, 0.0, 0.0, 1.0);
        this.u1.set(1.0, 0.0, 0.0, 1.0);
        this.u2.set(0.0, 1.0, 0.0, 1.0);
        this.u3.set(0.0, 0.0, 1.0, 1.0);
        Transform.transformPoint(this.matrix, this.u0);
        Transform.transformPoint(this.matrix, this.u1);
        Transform.transformPoint(this.matrix, this.u2);
        Transform.transformPoint(this.matrix, this.u3);
        if (this.vx == null) {
            this.vx = new Vector3d();
            this.vy = new Vector3d();
            this.vz = new Vector3d();
        }
        this.vx.set(this.u1.x - this.u0.x, this.u1.y - this.u0.y, this.u1.z - this.u0.z);
        this.vy.set(this.u2.x - this.u0.x, this.u2.y - this.u0.y, this.u2.z - this.u0.z);
        this.vz.set(this.u3.x - this.u0.x, this.u3.y - this.u0.y, this.u3.z - this.u0.z);
        this.vx.normalize();
        this.vy.normalize();
        this.vz.normalize();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.vy.z;
        double d5 = this.vz.z;
        switch (n2) {
            case 0: {
                justify.setAbove(false);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 1: {
                justify.setAbove(false);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 2: {
                justify.setAbove(true);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 3: {
                justify.setAbove(true);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 4: {
                justify.setAbove(true);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 5: {
                justify.setAbove(true);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 6: {
                justify.setAbove(false);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 7: {
                justify.setAbove(false);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 8: {
                justify.setAbove(false);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 9: {
                justify.setAbove(true);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 10: {
                justify.setAbove(false);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 11: {
                justify.setAbove(true);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                d3 = -d3;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 > 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 > 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
        }
        int n3 = 1;
        n3 = justify.isVertical() ? (d3 >= 0.0 ? 2 : 4) : (d2 >= 0.0 ? 1 : 3);
        justify.setRotate(n3);
        Point2d point2d = this.findEdgeDxDy(n2);
        if (justify.doFlipY()) {
            point2d.x = -point2d.x;
        }
        if (point2d.x < 0.0) {
            justify.setSpinTitle(true);
        } else {
            justify.setSpinTitle(false);
        }
        return this.orientationMatrix;
    }

    protected void updateChart3dRotation() {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        JCPlotCubeJava3d jCPlotCubeJava3d = (JCPlotCubeJava3d)((JCChart3dAreaJava3d)this.area).getPlotCube();
        PlotCubeTransformGroup plotCubeTransformGroup = jCPlotCubeJava3d.getTransformGroup();
        Transform3D transform3D = new Transform3D();
        plotCubeTransformGroup.getTransform(transform3D);
        Matrix3d matrix3d = new Matrix3d();
        transform3D.get(matrix3d);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.setRotation(matrix3d);
        RotateAction rotateAction = new RotateAction();
        rotateAction.extractAngles(matrix4d);
        this.area.getView3d().setXRotation(rotateAction.getXRotation() + 90.0);
        this.area.getView3d().setYRotation(rotateAction.getYRotation());
        this.area.getView3d().setZRotation(rotateAction.getZRotation());
    }
}

