/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d.actions;

import com.klg.jclass.chart3d.JCBox;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCView3d;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j2d.actions.BaseAction;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

public class ScaleAction
extends BaseAction {
    protected Point first = null;
    protected Point last = null;
    protected double scale = 1.0;
    protected double horizontalShift = 0.0;
    protected double verticalShift = 0.0;
    protected double origScale = 1.0;
    protected double origHorizontalShift = 0.0;
    protected double origVerticalShift = 0.0;

    public void animate(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        if (this.last == null) {
            return;
        }
        if (inputEvent instanceof KeyEvent) {
            switch (((KeyEvent)inputEvent).getKeyCode()) {
                case 33: {
                    n2 = this.last.x;
                    n3 = this.last.y + 1;
                    break;
                }
                case 34: {
                    n2 = this.last.x;
                    n3 = this.last.y - 1;
                    break;
                }
            }
        }
        if (n3 == this.last.y && n2 == this.last.x) {
            return;
        }
        this.status = 2;
        JCDebug.println("scaleAction", "Animate Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        int n4 = this.last.x - n2;
        int n5 = this.last.y - n3;
        this.last.x = n2;
        this.last.y = n3;
        JCViewport jCViewport = this.chart3dArea.getViewport();
        Transform transform = this.chart3dArea.getTransform();
        JCBox jCBox = transform.getCurrentViewport();
        JCBox jCBox2 = new JCBox(jCBox.x, jCBox.y, jCBox.width, jCBox.height);
        transform.adjustForUserViewport(jCBox2, jCViewport.getScale(), jCViewport.getHorizontalShift(), jCViewport.getVerticalShift());
        Rectangle rectangle = this.chart3dArea.getChart3d().getBounds();
        double d2 = -((double)n5) / rectangle.getHeight();
        double d3 = Math.pow(10.0, d2);
        this.scale = jCViewport.getScale() * d3;
        this.scale = JCNumberUtil.clamp(this.scale, 0.03333333333333333, 30.0);
        JCBox jCBox3 = new JCBox(jCBox.x, jCBox.y, jCBox.width, jCBox.height);
        transform.adjustForUserViewport(jCBox3, this.scale, jCViewport.getHorizontalShift(), jCViewport.getVerticalShift());
        jCBox3.x += (jCBox2.width - jCBox3.width) / 2.0;
        jCBox3.y += (jCBox2.height - jCBox3.height) / 2.0;
        this.horizontalShift = (jCBox3.x - jCBox.x) / jCBox.width;
        this.verticalShift = (jCBox3.y - jCBox.y) / jCBox.height;
        JCView3d jCView3d = this.chart3dArea.getView3d();
        this.drawPreview(this.scale, this.horizontalShift, this.verticalShift, jCView3d.getXRotation(), jCView3d.getYRotation(), jCView3d.getZRotation(), 0, n2, n3, false);
    }

    public void cancel() {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        this.status = 0;
        this.first = null;
        this.last = null;
        this.chart3dArea.getViewport().setViewport(this.origScale, this.origHorizontalShift, this.origVerticalShift);
    }

    public void end(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        JCDebug.println("scaleAction", "End Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        JCChart3d jCChart3d = this.chart3dArea.getChart3d();
        if (jCChart3d != null) {
            jCChart3d.sendEvent();
        }
        this.status = 0;
        this.first = null;
        this.last = null;
        JCDebug.println("scaleAction", "scale:" + this.scale + " horizontalShift:" + this.horizontalShift + " verticalShift:" + this.verticalShift);
        this.chart3dArea.getViewport().setViewport(this.scale, this.horizontalShift, this.verticalShift);
    }

    public void reanimate(int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status != 2) {
            return;
        }
        JCDebug.println("scaleAction", "Reanimate Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        JCView3d jCView3d = this.chart3dArea.getView3d();
        this.drawPreview(this.scale, this.horizontalShift, this.verticalShift, jCView3d.getXRotation(), jCView3d.getYRotation(), jCView3d.getZRotation(), 0, n2, n3, false);
    }

    public void start(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled) {
            return;
        }
        this.first = new Point(n2, n3);
        this.last = new Point(n2, n3);
        this.status = 1;
        JCDebug.println("scaleAction", "Start Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        JCViewport jCViewport = this.chart3dArea.getViewport();
        this.origScale = jCViewport.getScale();
        this.origHorizontalShift = jCViewport.getHorizontalShift();
        this.origVerticalShift = jCViewport.getVerticalShift();
    }
}

