/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d.actions;

import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCView3d;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j2d.actions.BaseAction;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple4d;

public class RotateAction
extends BaseAction {
    protected Point first = null;
    protected Point last = null;
    protected double origXRotation = 0.0;
    protected double origYRotation = 0.0;
    protected double origZRotation = 0.0;
    protected double xRotation = 0.0;
    protected double yRotation = 0.0;
    protected double zRotation = 0.0;
    protected int axisId = 0;
    protected Matrix4d rotate = null;

    public RotateAction() {
    }

    public RotateAction(int n2) {
        this.axisId = n2;
    }

    public void animate(InputEvent inputEvent, int n2, int n3) {
        Serializable serializable;
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        if (this.last == null) {
            return;
        }
        if (inputEvent instanceof KeyEvent) {
            switch (((KeyEvent)inputEvent).getKeyCode()) {
                case 38: {
                    n2 = this.last.x - 1;
                    n3 = this.last.y - 1;
                    break;
                }
                case 40: {
                    n2 = this.last.x + 1;
                    n3 = this.last.y + 1;
                    break;
                }
                case 37: {
                    n2 = this.last.x - 1;
                    n3 = this.last.y;
                    break;
                }
                case 39: {
                    n2 = this.last.x + 1;
                    n3 = this.last.y;
                    break;
                }
            }
        }
        if (n3 == this.last.y && n2 == this.last.x) {
            return;
        }
        this.status = 2;
        JCDebug.println("rotateAction", "Animate Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        int n4 = this.last.x - n2;
        int n5 = this.last.y - n3;
        this.last.x = n2;
        this.last.y = n3;
        this.rotate.setIdentity();
        Rectangle rectangle = this.chart3dArea.getBounds();
        Transform transform = this.chart3dArea.getTransform();
        JCPlotCube jCPlotCube = this.chart3dArea.getPlotCube();
        switch (this.axisId) {
            case 1: 
            case 2: 
            case 3: {
                serializable = new Point4d(0.0, 0.0, 0.0, 1.0);
                Point4d point4d = new Point4d(0.0, 0.0, 0.0, 1.0);
                if (this.axisId == 1) {
                    ((Tuple4d)serializable).x = -1.0;
                    point4d.x = 1.0;
                } else if (this.axisId == 2) {
                    ((Tuple4d)serializable).y = -1.0;
                    point4d.y = 1.0;
                } else {
                    ((Tuple4d)serializable).z = -1.0;
                    point4d.z = 1.0;
                }
                this.rotate.mul(transform.getScreen(), transform.getPerspective());
                this.rotate.mul(transform.getRotation());
                Transform.scaleMatrix(this.rotate, jCPlotCube.getXNormalizedScale(), jCPlotCube.getYNormalizedScale(), jCPlotCube.getZNormalizedScale());
                Transform.transformPoint(this.rotate, (Point4d)serializable);
                Transform.transformPoint(this.rotate, point4d);
                double d2 = point4d.y - ((Tuple4d)serializable).y;
                double d3 = ((Tuple4d)serializable).x - point4d.x;
                double d4 = d2 * d2 + d3 * d3;
                if (d4 < 100.0) {
                    d2 = 10.0;
                    d3 = 0.0;
                    d4 = 100.0;
                }
                double d5 = 100.0 * ((double)n4 * d2 + (double)n5 * d3) / d4;
                this.rotate.setIdentity();
                Transform.rotateMatrix(this.rotate, d5, this.axisId, true);
                this.rotate.mul(transform.getRotation(), this.rotate);
                break;
            }
            case 4: {
                serializable = new Point4d(0.0, 0.0, 0.0, 1.0);
                this.rotate.mul(transform.getScreen(), transform.getPerspective());
                this.rotate.mul(transform.getRotation());
                Transform.scaleMatrix(this.rotate, jCPlotCube.getXNormalizedScale(), jCPlotCube.getYNormalizedScale(), jCPlotCube.getZNormalizedScale());
                Transform.transformPoint(this.rotate, (Point4d)serializable);
                double d6 = Math.atan2((double)n3 - ((Tuple4d)serializable).y, (double)n2 - ((Tuple4d)serializable).x) - Math.atan2((double)(n3 - n5) - ((Tuple4d)serializable).y, (double)(n2 - n4) - ((Tuple4d)serializable).x);
                this.rotate.setIdentity();
                Transform.rotateMatrix(this.rotate, JCNumberUtil.radToDeg(d6), 3, true);
                this.rotate.mul(transform.getRotation());
                break;
            }
            default: {
                double d7 = Math.sqrt((double)n4 * (double)n4 + (double)n5 * (double)n5);
                double d8 = 180.0 * d7 / rectangle.getWidth();
                Transform.rotateMatrix(this.rotate, -d8 * (double)n5 / d7, 1, true);
                Transform.rotateMatrix(this.rotate, -d8 * (double)n4 / d7, 2, true);
                this.rotate.mul(transform.getRotation());
            }
        }
        this.extractAngles(this.rotate);
        this.xRotation += 90.0;
        serializable = this.chart3dArea.getViewport();
        this.drawPreview(((JCViewport)serializable).getScale(), ((JCViewport)serializable).getHorizontalShift(), ((JCViewport)serializable).getVerticalShift(), this.xRotation, this.yRotation, this.zRotation, this.axisId, n2, n3, true);
    }

    public void cancel() {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        this.status = 0;
        this.first.y = -1;
        this.first.x = -1;
        this.last.y = -1;
        this.last.x = -1;
        this.chart3dArea.getView3d().setXYZRotation(this.origXRotation, this.origYRotation, this.origZRotation);
    }

    public void end(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        JCDebug.println("rotateAction", "End Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        JCChart3d jCChart3d = this.chart3dArea.getChart3d();
        if (jCChart3d != null) {
            jCChart3d.sendEvent();
        }
        if (this.xRotation < 0.0) {
            this.xRotation += 360.0;
        }
        if (this.yRotation < 0.0) {
            this.yRotation += 360.0;
        }
        if (this.zRotation < 0.0) {
            this.zRotation += 360.0;
        }
        this.status = 0;
        this.first.y = -1;
        this.first.x = -1;
        this.last.y = -1;
        this.last.x = -1;
        JCDebug.println("rotateAction", "xRotation:" + this.xRotation + " yRotation:" + this.yRotation + " zRotation:" + this.zRotation);
        this.chart3dArea.getView3d().setXYZRotation(this.xRotation, this.yRotation, this.zRotation);
    }

    public void extractAngles(Matrix4d matrix4d) {
        this.yRotation = Math.asin(matrix4d.m02);
        if (1.0 + Math.cos(this.yRotation) == 1.0) {
            this.xRotation = Math.atan2(matrix4d.m10, matrix4d.m11);
            this.zRotation = 0.0;
        } else {
            this.xRotation = Math.atan2(-matrix4d.m12, matrix4d.m22);
            this.zRotation = Math.atan2(-matrix4d.m01, matrix4d.m00);
        }
        this.xRotation = JCNumberUtil.radToDeg(this.xRotation);
        this.yRotation = JCNumberUtil.radToDeg(this.yRotation);
        this.zRotation = JCNumberUtil.radToDeg(this.zRotation);
    }

    public double getXRotation() {
        return this.xRotation;
    }

    public double getYRotation() {
        return this.yRotation;
    }

    public double getZRotation() {
        return this.zRotation;
    }

    public void reanimate(int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status != 2) {
            return;
        }
        JCDebug.println("rotateAction", "Reanimate Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        JCViewport jCViewport = this.chart3dArea.getViewport();
        this.drawPreview(jCViewport.getScale(), jCViewport.getHorizontalShift(), jCViewport.getVerticalShift(), this.xRotation, this.yRotation, this.zRotation, 0, n2, n3, true);
    }

    public void start(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled) {
            return;
        }
        this.first = new Point(n2, n3);
        this.last = new Point(n2, n3);
        this.status = 1;
        JCDebug.println("rotateAction", "Start Action: (x, y) = (" + n2 + "," + n3 + ") status:" + this.status);
        JCView3d jCView3d = this.chart3dArea.getView3d();
        this.xRotation = this.origXRotation = jCView3d.getXRotation();
        this.yRotation = this.origYRotation = jCView3d.getYRotation();
        this.zRotation = this.origZRotation = jCView3d.getZRotation();
        if (this.rotate == null) {
            this.rotate = new Matrix4d();
        }
    }
}

