/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d.actions;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.EditableChart3dDataModel;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.j2d.actions.BaseAction;
import java.awt.Point;
import java.awt.event.InputEvent;
import javax.vecmath.Point3d;

public class EditAction
extends BaseAction {
    protected Chart3dDataView dataView = null;
    protected Chart3dData data = null;
    protected JCData3dIndex index = null;
    protected Point p = null;
    protected double origZValue = Double.MAX_VALUE;

    public void animate(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status == 0 || this.index == null || this.dataView == null || this.data == null) {
            return;
        }
        this.status = 2;
        JCChart3d jCChart3d = this.getChart3d();
        this.p.setLocation(jCChart3d.convertChartAreaXToX(n2), jCChart3d.convertChartAreaYToY(n3));
        double d2 = this.dataView.dragZValue(this.data, this.index, this.p.x, this.p.y);
        this.data.getDataHandler().editZValue(this.index, d2);
    }

    public void cancel() {
        if (this.index == null || this.dataView == null || this.data == null) {
            return;
        }
        this.data.getDataHandler().editZValue(this.index, this.origZValue);
        this.status = 0;
        this.index = null;
        this.dataView = null;
        this.data = null;
    }

    public void end(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status == 0 || this.index == null || this.dataView == null || this.data == null) {
            return;
        }
        JCChart3d jCChart3d = this.getChart3d();
        jCChart3d.sendEvent();
        double d2 = this.p.getX();
        double d3 = this.p.getY();
        this.p.setLocation(jCChart3d.convertChartAreaXToX(n2), jCChart3d.convertChartAreaYToY(n3));
        if (d2 != this.p.getX() || d3 != this.p.getY()) {
            double d4 = this.dataView.dragZValue(this.data, this.index, this.p.x, this.p.y);
            this.data.getDataHandler().editZValue(this.index, d4);
        }
        this.status = 0;
        this.index = null;
        this.dataView = null;
        this.data = null;
    }

    public void reanimate(int n2, int n3) {
        this.animate(null, n2, n3);
    }

    public void start(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled) {
            return;
        }
        this.index = null;
        JCChart3d jCChart3d = this.getChart3d();
        this.p = new Point(jCChart3d.convertChartAreaXToX(n2), jCChart3d.convertChartAreaYToY(n3));
        this.index = this.getChart3d().pick(this.p, null);
        if (this.index == null || this.index.getDataView() == null) {
            return;
        }
        this.dataView = this.index.getDataView();
        Chart3dDataModel chart3dDataModel = this.dataView.getElevationDataSource();
        if (chart3dDataModel == null || !(chart3dDataModel instanceof EditableChart3dDataModel)) {
            return;
        }
        this.data = this.dataView.getElevationData();
        if (this.index instanceof JCData3dGridIndex && !(this.data instanceof Chart3dGridData) || this.index instanceof JCData3dPointIndex && !(this.data instanceof Chart3dPointData)) {
            return;
        }
        if (this.index instanceof JCData3dGridIndex) {
            JCData3dGridIndex jCData3dGridIndex = (JCData3dGridIndex)this.index;
            Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
            int n4 = jCData3dGridIndex.getX();
            int n5 = jCData3dGridIndex.getY();
            if (n4 < 0) {
                return;
            }
            this.origZValue = chart3dGridData.getZValue(n4, n5);
        } else if (this.index instanceof JCData3dPointIndex) {
            if (this.index.getObject() == jCChart3d.getLegend()) {
                return;
            }
            JCData3dPointIndex jCData3dPointIndex = (JCData3dPointIndex)this.index;
            Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
            int n6 = jCData3dPointIndex.getSeries();
            int n7 = jCData3dPointIndex.getPoint();
            if (n6 < 0) {
                return;
            }
            Point3d point3d = chart3dPointData.getSeries(n6).getPoint(n7);
            this.origZValue = point3d.z;
        } else {
            return;
        }
        this.status = 1;
    }
}

