/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.SortPoint;
import com.klg.jclass.chart3d.j2d.MapPick;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.vecmath.Point3d;

public class MapPickPoint
extends MapPick {
    public MapPickPoint() {
    }

    public MapPickPoint(Chart3dData chart3dData) {
        super(chart3dData);
    }

    protected boolean findClosestPoint(int n2, int n3, JCData3dPointIndex jCData3dPointIndex) {
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (chart3dPointData == null || !chart3dPointData.isDataOK() || jCData3dPointIndex == null) {
            return false;
        }
        ScreenPoint[][] screenPointArray = this.getScreenPoints();
        Chart3dDataView chart3dDataView = chart3dPointData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        Rectangle rectangle = jCChart3dArea.getDrawingArea();
        chart3dPointData.sortPoints();
        ArrayList arrayList = chart3dPointData.getSortPoints();
        if (arrayList == null) {
            return false;
        }
        int n4 = 0;
        while (n4 < arrayList.size()) {
            int n5;
            SortPoint sortPoint = (SortPoint)arrayList.get(n4);
            int n6 = sortPoint.getSeries();
            ScreenPoint screenPoint = screenPointArray[n6][n5 = sortPoint.getPoint()];
            if (!screenPoint.isHoleValue() && !screenPoint.isHidden()) {
                int n7;
                int n8 = screenPoint.getXPixel();
                if (rectangle.contains(n8, n7 = screenPoint.getYPixel())) {
                    double d2 = this.calcDist(n2, n3, n8, n7);
                    if (d2 <= jCData3dPointIndex.getDistance()) {
                        jCData3dPointIndex.setDistance(d2);
                        jCData3dPointIndex.setSeries(n6);
                        jCData3dPointIndex.setPoint(n5);
                    }
                } else {
                    screenPoint.setHidden(true);
                }
            }
            ++n4;
        }
        return jCData3dPointIndex.getDistance() != Double.MAX_VALUE;
    }

    public Point3d map(int n2, int n3) {
        if (!(this.data instanceof Chart3dPointData)) {
            return null;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (chart3dPointData == null || !chart3dPointData.isDataOK()) {
            return null;
        }
        Chart3dDataView chart3dDataView = chart3dPointData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCData3dPointIndex jCData3dPointIndex = new JCData3dPointIndex(chart3dDataView, -1, -1);
        Point3d point3d = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        if (chart3dDataView.getChart3d().isProjection()) {
            double d2 = jCChart3dArea.getAxis(1).getMin();
            double d3 = jCChart3dArea.getAxis(1).getMax();
            double d4 = jCChart3dArea.getAxis(2).getMin();
            double d5 = jCChart3dArea.getAxis(2).getMax();
            Rectangle rectangle = this.interpolateXY(n2, n3, d2, d4, d3, d5, point3d);
            if (n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height) {
                if (this.findClosestPoint(n2, n3, jCData3dPointIndex)) {
                    int n4 = jCData3dPointIndex.getSeries();
                    int n5 = jCData3dPointIndex.getPoint();
                    point3d.z = chart3dPointData.getSeries((int)n4).getPoint((int)n5).z;
                }
            } else {
                point3d.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            }
        } else if (this.findClosestPoint(n2, n3, jCData3dPointIndex)) {
            int n6 = jCData3dPointIndex.getSeries();
            int n7 = jCData3dPointIndex.getPoint();
            point3d.set(chart3dPointData.getSeries(n6).getPoint(n7));
        }
        return point3d;
    }

    public JCData3dIndex pick(int n2, int n3) {
        if (!(this.data instanceof Chart3dPointData)) {
            return null;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (chart3dPointData == null || !chart3dPointData.isDataOK()) {
            return null;
        }
        JCData3dPointIndex jCData3dPointIndex = new JCData3dPointIndex(chart3dPointData.getDataView(), -1, -1);
        this.findClosestPoint(n2, n3, jCData3dPointIndex);
        return jCData3dPointIndex;
    }

    public Point unpick(JCData3dIndex jCData3dIndex) {
        Point point = new Point(-1, -1);
        if (!(this.data instanceof Chart3dPointData) || !(jCData3dIndex instanceof JCData3dPointIndex)) {
            return point;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        JCData3dPointIndex jCData3dPointIndex = (JCData3dPointIndex)jCData3dIndex;
        if (chart3dPointData == null || !chart3dPointData.isDataOK() || jCData3dPointIndex == null) {
            return point;
        }
        ScreenPoint[][] screenPointArray = this.getScreenPoints();
        int n2 = jCData3dPointIndex.getSeries();
        int n3 = jCData3dPointIndex.getPoint();
        if (n2 >= 0 && n2 < chart3dPointData.getNumSeries() && n3 >= 0 && n3 < chart3dPointData.getSeries(n2).getNumPoints()) {
            ScreenPoint screenPoint = screenPointArray[n2][n3];
            point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
        }
        jCData3dIndex.setDistance(0.0);
        return point;
    }
}

