/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.data;

import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.data.JCEditable3dGridDataSource;
import com.klg.jclass.chart3d.event.Chart3dGridDataEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JCSwing3dDataSource
extends JCEditable3dGridDataSource
implements TableModelListener {
    protected TableModel tableModel;

    public JCSwing3dDataSource(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
        this.setData();
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    protected void setData() {
        Object object;
        int n2;
        int n3 = this.tableModel.getRowCount();
        int n4 = this.tableModel.getColumnCount();
        double[][] dArray = new double[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            n2 = 0;
            while (n2 < n4) {
                object = this.tableModel.getValueAt(n5, n2);
                if (object == null) {
                    dArray[n5][n2] = this.getHoleValue();
                } else if (object instanceof Number) {
                    dArray[n5][n2] = ((Number)object).doubleValue();
                } else if (object instanceof String) {
                    try {
                        dArray[n5][n2] = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        dArray[n5][n2] = 0.0;
                    }
                } else {
                    dArray[n5][n2] = 0.0;
                }
                ++n2;
            }
            ++n5;
        }
        this.setZValues(dArray);
        this.setXGrid(null);
        this.setYGrid(null);
        n2 = 2;
        object = new JCData3dGridIndex(-100, -100);
        this.fireChart3dDataEvent(new Chart3dGridDataEvent((Object)this, n2, (JCData3dGridIndex)object));
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
        this.setData();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        int n4 = tableModelEvent.getColumn();
        if (n2 == -1 || n3 != n2 || tableModelEvent.getType() != 0 || n4 == -1) {
            this.setTableModel((TableModel)tableModelEvent.getSource());
        } else {
            double d2;
            Object object;
            try {
                object = this.tableModel.getValueAt(n2, n4);
                d2 = ((Number)object).doubleValue();
            }
            catch (Exception exception) {
                d2 = 0.0;
            }
            object = new JCData3dGridIndex(n2, n4);
            this.setZValue((JCData3dIndex)object, d2);
            int n5 = 9;
            this.fireChart3dDataEvent(new Chart3dGridDataEvent((Object)this, n5, (JCData3dGridIndex)object));
        }
    }
}

