/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer.util;

import com.klg.jclass.chart3d.customizer.util.JCColorList;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;

public class JCColorChooser
extends JPanel
implements ActionListener,
FocusListener {
    protected JCLocaleManager lm = JCLocaleManager.getDefault();
    protected EventListenerList listeners;
    protected JTextField colorRGB;
    protected JComboBox colorName;
    protected Color color;
    protected JButton colorPickButton;
    protected ArrayList colornameList;
    private static String[] rainbow;

    static {
        JCLocaleManager.getDefault().add("com.klg.jclass.chart3d.customizer.util.resources.LocaleInfo");
        rainbow = new String[]{"rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "              ", "              ", "              ", "  ..  ..  ..  ", "  ..  ..  ..  "};
    }

    public JCColorChooser() {
        this(Color.white);
    }

    public JCColorChooser(Color color) {
        if (color == null) {
            color = Color.white;
        }
        this.color = color;
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.changePerformed(actionEvent.getSource());
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener.getClass(), actionListener);
    }

    public void addColor(String string, Color color) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Color name cannot be null");
        }
        if (color == null) {
            throw new NullPointerException("Color cannot be null");
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.colorName.getModel();
        defaultComboBoxModel.addElement(color);
        this.colornameList.add(string);
    }

    public void changePerformed(Object object) {
        Color color = this.color;
        if (object == this.colorRGB) {
            try {
                this.color = JCColorList.getColorFromHexRGB(this.colorRGB.getText());
                this.setColorname(this.color);
            }
            catch (NumberFormatException numberFormatException) {
                this.colorRGB.setText("#" + JCColorList.getHexRGBFromColor(this.color));
                JOptionPane.showMessageDialog(this, this.lm.getString("com.klg.jclass.chart3d.customizer.util.Error1"), this.lm.getString("com.klg.jclass.chart3d.customizer.util.String22"), 0);
                this.colorRGB.setText("#" + JCColorList.getHexRGBFromColor(this.color));
            }
        } else if (object == this.colorName) {
            Object object2 = this.colorName.getSelectedItem();
            if (object2 instanceof Color) {
                this.color = (Color)object2;
                this.colorRGB.setText("#" + JCColorList.getHexRGBFromColor(this.color));
            } else if (object2 instanceof String) {
                this.setColorname(this.color);
            }
        } else if (object == this.colorPickButton) {
            JColorChooser jColorChooser = new JColorChooser(this.color);
            Color color2 = JColorChooser.showDialog(this, this.lm.getString("com.klg.jclass.chart3d.customizer.util.String23"), this.color);
            if (color2 != null) {
                this.color = color2;
            }
        }
        if (!this.color.equals(color)) {
            this.colorRGB.setText("#" + JCColorList.getHexRGBFromColor(this.color));
            this.setColorname(this.color);
            this.fireAction();
        }
    }

    protected void fireAction() {
        ActionEvent actionEvent = new ActionEvent(this, 0, null);
        Object[] objectArray = this.listeners.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2 + 1] instanceof ActionListener) {
                ((ActionListener)objectArray[n2 + 1]).actionPerformed(actionEvent);
            }
            n2 -= 2;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.changePerformed(focusEvent.getSource());
    }

    public Color getColor() {
        return this.color;
    }

    public void initialize() {
        this.colornameList = new ArrayList();
        Object[] objectArray = JCColorList.getColornames();
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.colornameList.add(objectArray[n2]);
            ++n2;
        }
        this.listeners = new EventListenerList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel = new JPanel();
        this.colorPickButton = new JButton(new ImageIcon(JCColorChooser.rainbowImage()));
        this.colorPickButton.addActionListener(this);
        this.colorRGB = new JTextField(9);
        this.colorRGB.addActionListener(this);
        this.colorRGB.addFocusListener(this);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(JCColorList.getColors());
        defaultComboBoxModel.addElement(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String21"));
        this.colorName = new JComboBox<Object>(defaultComboBoxModel);
        this.colorName.addActionListener(this);
        this.colorName.setRenderer(new CustomCellRenderer());
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String1")));
        jPanel2.add(new JPanel());
        jPanel2.add(new JPanel());
        jPanel2.add(this.colorRGB);
        jPanel2.add(new JPanel());
        jPanel2.add(this.colorPickButton);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.add(new JLabel(String.valueOf(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String2")) + ":"));
        jPanel2.add(new JPanel());
        jPanel2.add(this.colorName);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.colorRGB.setText("#" + JCColorList.getHexRGBFromColor(this.color));
        this.setColorname(this.color);
    }

    private static Image rainbowImage() {
        JCIconCreator jCIconCreator = new JCIconCreator(rainbow[0].length(), rainbow.length);
        jCIconCreator.setColor('.', new Color(0));
        jCIconCreator.setColor('r', new Color(0xFF0000));
        jCIconCreator.setColor('g', new Color(65280));
        jCIconCreator.setColor('b', new Color(255));
        jCIconCreator.setPixels(rainbow);
        return jCIconCreator.getIcon().getImage();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener.getClass(), actionListener);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
        this.colorRGB.setText("#" + JCColorList.getHexRGBFromColor(color));
        this.setColorname(color);
    }

    private void setColorname(Color color) {
        if (JCColorList.isColorInList(color)) {
            this.colorName.setSelectedItem(color);
        } else {
            this.colorName.setSelectedItem(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String21"));
            this.colorName.repaint();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.colorRGB.setEnabled(bl);
        this.colorName.setEnabled(bl);
        this.colorPickButton.setEnabled(bl);
    }

    private class CustomCellRenderer
    extends JLabel
    implements ListCellRenderer,
    Icon {
        int iconWidth = 12;
        int iconHeight = 12;
        Color color;

        public CustomCellRenderer() {
            this.setOpaque(true);
            this.setIcon(this);
            this.setIconTextGap(8);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public int getIconHeight() {
            return this.iconHeight;
        }

        public int getIconWidth() {
            return this.iconWidth;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            if (object instanceof String) {
                this.setText((String)object);
                this.color = JCColorChooser.this.color;
            } else if (object instanceof Color) {
                this.color = (Color)object;
                if (n2 < 0) {
                    DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jList.getModel();
                    n2 = defaultComboBoxModel.getIndexOf(object);
                }
                this.setText((String)JCColorChooser.this.colornameList.get(n2));
            } else {
                this.setText(object.toString());
            }
            this.setFont(jList.getFont());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.setColor(this.color);
            graphics.fill3DRect(n2, n3, this.iconWidth, this.iconHeight, true);
        }
    }
}

