/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer.util;

import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import com.klg.jclass.util.JCLocaleManager;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.EventListenerList;

public class JCBorderChooser
extends JPanel
implements ItemListener,
ActionListener,
FocusListener {
    protected JCLocaleManager lm = JCLocaleManager.getDefault();
    protected EventListenerList listeners;
    protected JComboBox borderList;
    protected JTextField topEmptyField;
    protected JTextField leftEmptyField;
    protected JTextField bottomEmptyField;
    protected JTextField rightEmptyField;
    protected JTextField topMatteField;
    protected JTextField leftMatteField;
    protected JTextField bottomMatteField;
    protected JTextField rightMatteField;
    protected ButtonGroup bevelGroup;
    protected JRadioButton bevelLoweredButton;
    protected JRadioButton bevelRaisedButton;
    protected JTextField thickField;
    protected JTextField titledField;
    protected JCColorChooser lineColorChooser;
    protected JCColorChooser matteColorChooser;
    protected JCColorChooser shadowColorChooser;
    protected JCColorChooser highlightColorChooser;
    protected JPanel bevelEditor;
    protected JPanel lineEditor;
    protected JPanel matteEditor;
    protected JPanel emptyEditor;
    protected JPanel titledEditor;
    protected JPanel activeEditor;
    protected JPanel editorPanel;
    protected Border border;
    protected ArrayList borderNames = new ArrayList(6);
    protected Object focusValue;
    protected static final int EMPTY = 1;
    protected static final int BEVEL = 2;
    protected static final int ETCHED = 3;
    protected static final int LINE = 4;
    protected static final int MATTE = 5;
    protected static final int TITLED = 6;
    private boolean isSetSelectedBorder = false;

    static {
        JCLocaleManager.getDefault().add("com.klg.jclass.chart3d.customizer.util.resources.LocaleInfo");
    }

    public JCBorderChooser() {
        this.initialize();
        this.setSelectedBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public JCBorderChooser(Border border) {
        this.initialize();
        this.setSelectedBorder(border);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.changePerformed(actionEvent.getSource());
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener.getClass(), actionListener);
    }

    public void changePerformed(Object object) {
        Border border = null;
        int n2 = 1;
        if (this.bevelEditor != null) {
            n2 = this.bevelLoweredButton.isSelected() ? 1 : 0;
        }
        Integer n3 = (Integer)this.borderList.getSelectedItem();
        switch (n3) {
            case 1: {
                border = BorderFactory.createEmptyBorder(this.intValue(this.topEmptyField), this.intValue(this.leftEmptyField), this.intValue(this.bottomEmptyField), this.intValue(this.rightEmptyField));
                break;
            }
            case 5: {
                border = BorderFactory.createMatteBorder(this.intValue(this.topMatteField), this.intValue(this.leftMatteField), this.intValue(this.bottomMatteField), this.intValue(this.rightMatteField), this.matteColorChooser.getColor());
                break;
            }
            case 2: {
                border = BorderFactory.createBevelBorder(n2, this.highlightColorChooser.getColor(), this.shadowColorChooser.getColor());
                break;
            }
            case 3: {
                border = BorderFactory.createEtchedBorder(this.highlightColorChooser.getColor(), this.shadowColorChooser.getColor());
                break;
            }
            case 4: {
                border = BorderFactory.createLineBorder(this.lineColorChooser.getColor(), this.intValue(this.thickField));
                break;
            }
            case 6: {
                border = BorderFactory.createTitledBorder(this.titledField.getText());
                break;
            }
        }
        this.border = border;
        this.fireAction();
    }

    public JPanel createBevelEditor() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.bevelLoweredButton = new JRadioButton(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String13"));
        this.bevelRaisedButton = new JRadioButton(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String14"));
        this.bevelLoweredButton.addActionListener(this);
        this.bevelRaisedButton.addActionListener(this);
        this.bevelLoweredButton.setSelected(true);
        buttonGroup.add(this.bevelLoweredButton);
        buttonGroup.add(this.bevelRaisedButton);
        jPanel2.add(this.bevelLoweredButton);
        jPanel2.add(new JPanel());
        jPanel2.add(this.bevelRaisedButton);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.highlightColorChooser = new JCColorChooser(Color.white);
        this.highlightColorChooser.setBorder(BorderFactory.createTitledBorder(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String15")));
        this.highlightColorChooser.addActionListener(this);
        gridBagLayout.setConstraints(this.highlightColorChooser, gridBagConstraints);
        jPanel.add(this.highlightColorChooser);
        this.shadowColorChooser = new JCColorChooser(Color.black);
        this.shadowColorChooser.setBorder(BorderFactory.createTitledBorder(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String16")));
        this.shadowColorChooser.addActionListener(this);
        gridBagLayout.setConstraints(this.shadowColorChooser, gridBagConstraints);
        jPanel.add(this.shadowColorChooser);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add(jPanel);
        return jPanel3;
    }

    public JPanel createEmptyEditor() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 2, 0, 15));
        this.topEmptyField = new JTextField("0", 8);
        this.topEmptyField.addActionListener(this);
        this.topEmptyField.addFocusListener(this);
        jPanel2.add(new JLabel(String.valueOf(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String9")) + ": "));
        jPanel2.add(this.topEmptyField);
        this.leftEmptyField = new JTextField("0", 8);
        this.leftEmptyField.addActionListener(this);
        this.leftEmptyField.addFocusListener(this);
        jPanel2.add(new JLabel(String.valueOf(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String10")) + ": "));
        jPanel2.add(this.leftEmptyField);
        this.bottomEmptyField = new JTextField("0", 8);
        this.bottomEmptyField.addActionListener(this);
        this.bottomEmptyField.addFocusListener(this);
        jPanel2.add(new JLabel(String.valueOf(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String11")) + ": "));
        jPanel2.add(this.bottomEmptyField);
        this.rightEmptyField = new JTextField("0", 8);
        this.rightEmptyField.addActionListener(this);
        this.rightEmptyField.addFocusListener(this);
        jPanel2.add(new JLabel(String.valueOf(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String12")) + ": "));
        jPanel2.add(this.rightEmptyField);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add(jPanel);
        return jPanel3;
    }

    public JPanel createLineEditor() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        this.thickField = new JTextField("0", 11);
        this.thickField.addActionListener(this);
        this.thickField.addFocusListener(this);
        jPanel2.add(new JLabel("  " + this.lm.getString("com.klg.jclass.chart3d.customizer.util.String18") + ": "));
        jPanel2.add(this.thickField);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.lineColorChooser = new JCColorChooser();
        this.lineColorChooser.setBorder(BorderFactory.createTitledBorder(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String17")));
        this.lineColorChooser.addActionListener(this);
        gridBagLayout.setConstraints(this.lineColorChooser, gridBagConstraints);
        jPanel.add(this.lineColorChooser);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add(jPanel);
        return jPanel3;
    }

    public JPanel createMatteEditor() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.matteColorChooser = new JCColorChooser();
        this.matteColorChooser.setBorder(BorderFactory.createTitledBorder(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String19")));
        this.matteColorChooser.addActionListener(this);
        gridBagLayout.setConstraints(this.matteColorChooser, gridBagConstraints);
        jPanel.add(this.matteColorChooser);
        jPanel.add(new JPanel());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 2, 0, 15));
        this.topMatteField = new JTextField("0", 8);
        this.topMatteField.addActionListener(this);
        this.topMatteField.addFocusListener(this);
        jPanel2.add(new JLabel("  " + this.lm.getString("com.klg.jclass.chart3d.customizer.util.String9") + ": "));
        jPanel2.add(this.topMatteField);
        this.leftMatteField = new JTextField("0", 8);
        this.leftMatteField.addActionListener(this);
        this.leftMatteField.addFocusListener(this);
        jPanel2.add(new JLabel("  " + this.lm.getString("com.klg.jclass.chart3d.customizer.util.String10") + ": "));
        jPanel2.add(this.leftMatteField);
        this.bottomMatteField = new JTextField("0", 8);
        this.bottomMatteField.addActionListener(this);
        this.bottomMatteField.addFocusListener(this);
        jPanel2.add(new JLabel("  " + this.lm.getString("com.klg.jclass.chart3d.customizer.util.String11") + ": "));
        jPanel2.add(this.bottomMatteField);
        this.rightMatteField = new JTextField("0", 8);
        this.rightMatteField.addActionListener(this);
        this.rightMatteField.addFocusListener(this);
        jPanel2.add(new JLabel("  " + this.lm.getString("com.klg.jclass.chart3d.customizer.util.String12") + ": "));
        jPanel2.add(this.rightMatteField);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add(jPanel);
        return jPanel3;
    }

    public JPanel createTitledEditor() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        this.titledField = new JTextField(12);
        this.titledField.addActionListener(this);
        this.titledField.addFocusListener(this);
        jPanel.add(new JLabel(String.valueOf(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String20")) + ": "));
        jPanel.add(this.titledField);
        return jPanel;
    }

    protected void fireAction() {
        ActionEvent actionEvent = new ActionEvent(this, 0, null);
        Object[] objectArray = this.listeners.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2 + 1] instanceof ActionListener) {
                ((ActionListener)objectArray[n2 + 1]).actionPerformed(actionEvent);
            }
            n2 -= 2;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.focusValue = object instanceof JTextField ? ((JTextField)object).getText() : null;
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            String string = (String)this.focusValue;
            String string2 = ((JTextField)object).getText();
            if (!string.equals(string2)) {
                this.changePerformed(focusEvent.getSource());
            }
        } else {
            this.changePerformed(focusEvent.getSource());
        }
    }

    public Border getSelectedBorder() {
        return this.border;
    }

    private void initialize() {
        this.listeners = new EventListenerList();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.setLayout(gridBagLayout);
        this.borderNames.add(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String3"));
        this.borderNames.add(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String4"));
        this.borderNames.add(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String5"));
        this.borderNames.add(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String6"));
        this.borderNames.add(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String7"));
        this.borderNames.add(this.lm.getString("com.klg.jclass.chart3d.customizer.util.String8"));
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>();
        defaultComboBoxModel.addElement(new Integer(1));
        defaultComboBoxModel.addElement(new Integer(2));
        defaultComboBoxModel.addElement(new Integer(3));
        defaultComboBoxModel.addElement(new Integer(4));
        defaultComboBoxModel.addElement(new Integer(5));
        defaultComboBoxModel.addElement(new Integer(6));
        this.borderList = new JComboBox(defaultComboBoxModel);
        this.borderList.setRenderer(new CustomCellRenderer());
        this.borderList.addItemListener(this);
        gridBagLayout.setConstraints(this.borderList, gridBagConstraints);
        this.add(this.borderList);
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new CardLayout());
        this.emptyEditor = this.createEmptyEditor();
        this.editorPanel.add((Component)this.emptyEditor, this.lm.getString("com.klg.jclass.chart3d.customizer.util.String24"));
        gridBagLayout.setConstraints(this.editorPanel, gridBagConstraints);
        this.add(this.editorPanel);
        this.activeEditor = this.emptyEditor;
    }

    private int intValue(JTextField jTextField) {
        String string = jTextField.getText();
        int n2 = 0;
        try {
            n2 = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            jTextField.setText("0");
        }
        return n2;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.activeEditor.setVisible(false);
        Integer n2 = (Integer)this.borderList.getSelectedItem();
        switch (n2) {
            case 1: {
                this.activeEditor = this.emptyEditor;
                break;
            }
            case 2: {
                if (this.bevelEditor == null) {
                    this.bevelEditor = this.createBevelEditor();
                    this.editorPanel.add((Component)this.bevelEditor, this.lm.getString("com.klg.jclass.chart3d.customizer.util.String25"));
                }
                this.activeEditor = this.bevelEditor;
                break;
            }
            case 3: {
                if (this.bevelEditor == null) {
                    this.bevelEditor = this.createBevelEditor();
                    this.editorPanel.add((Component)this.bevelEditor, this.lm.getString("com.klg.jclass.chart3d.customizer.util.String25"));
                }
                this.activeEditor = this.bevelEditor;
                break;
            }
            case 4: {
                if (this.lineEditor == null) {
                    this.lineEditor = this.createLineEditor();
                    this.editorPanel.add((Component)this.lineEditor, this.lm.getString("com.klg.jclass.chart3d.customizer.util.String26"));
                }
                this.activeEditor = this.lineEditor;
                break;
            }
            case 5: {
                if (this.matteEditor == null) {
                    this.matteEditor = this.createMatteEditor();
                    this.editorPanel.add((Component)this.matteEditor, this.lm.getString("com.klg.jclass.chart3d.customizer.util.String27"));
                }
                this.activeEditor = this.matteEditor;
                break;
            }
            case 6: {
                if (this.titledEditor == null) {
                    this.titledEditor = this.createTitledEditor();
                    this.editorPanel.add((Component)this.titledEditor, this.lm.getString("com.klg.jclass.chart3d.customizer.util.String28"));
                }
                this.activeEditor = this.titledEditor;
                break;
            }
        }
        this.activeEditor.setVisible(true);
        if (!this.isSetSelectedBorder) {
            this.actionPerformed(new ActionEvent(object, 0, null));
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener.getClass(), actionListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.borderList.setEnabled(bl);
        if (this.emptyEditor != null) {
            this.topEmptyField.setEnabled(bl);
            this.leftEmptyField.setEnabled(bl);
            this.bottomEmptyField.setEnabled(bl);
            this.rightEmptyField.setEnabled(bl);
        }
        if (this.matteEditor != null) {
            this.topMatteField.setEnabled(bl);
            this.leftMatteField.setEnabled(bl);
            this.bottomMatteField.setEnabled(bl);
            this.rightMatteField.setEnabled(bl);
            this.matteColorChooser.setEnabled(bl);
        }
        if (this.bevelEditor != null) {
            this.bevelLoweredButton.setEnabled(bl);
            this.bevelRaisedButton.setEnabled(bl);
            this.shadowColorChooser.setEnabled(bl);
            this.highlightColorChooser.setEnabled(bl);
        }
        if (this.lineEditor != null) {
            this.thickField.setEnabled(bl);
            this.lineColorChooser.setEnabled(bl);
        }
        if (this.titledEditor != null) {
            this.titledField.setEnabled(bl);
        }
    }

    public void setPanelBorder(Border border) {
        this.bevelEditor.setBorder(border);
        this.lineEditor.setBorder(border);
        this.matteEditor.setBorder(border);
        this.emptyEditor.setBorder(border);
        this.titledEditor.setBorder(border);
    }

    public void setSelectedBorder(Border border) {
        this.isSetSelectedBorder = true;
        if (border instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)border;
            this.borderList.setSelectedItem(new Integer(5));
            Insets insets = matteBorder.getBorderInsets(this);
            this.topMatteField.setText(String.valueOf(insets.top));
            this.leftMatteField.setText(String.valueOf(insets.left));
            this.bottomMatteField.setText(String.valueOf(insets.bottom));
            this.rightMatteField.setText(String.valueOf(insets.right));
            Color color = this.matteColorChooser.getColor();
            if (color == null) {
                color = Color.black;
            }
            this.matteColorChooser.setColor(color);
        } else if (border instanceof BevelBorder) {
            BevelBorder bevelBorder = (BevelBorder)border;
            this.borderList.setSelectedItem(new Integer(2));
            if (bevelBorder.getBevelType() == 1) {
                this.bevelLoweredButton.setSelected(true);
            } else {
                this.bevelRaisedButton.setSelected(true);
            }
            Color color = this.highlightColorChooser.getColor();
            if (color == null) {
                color = Color.black;
            }
            this.highlightColorChooser.setColor(color);
            color = this.shadowColorChooser.getColor();
            if (color == null) {
                color = Color.black;
            }
            this.shadowColorChooser.setColor(color);
        } else if (border instanceof EtchedBorder) {
            EtchedBorder etchedBorder = (EtchedBorder)border;
            this.borderList.setSelectedItem(new Integer(3));
            if (etchedBorder.getEtchType() == 1) {
                this.bevelLoweredButton.setSelected(true);
            } else {
                this.bevelRaisedButton.setSelected(true);
            }
        } else if (border instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)border;
            this.borderList.setSelectedItem(new Integer(4));
            this.thickField.setText(String.valueOf(lineBorder.getThickness()));
            this.lineColorChooser.setColor(lineBorder.getLineColor());
        } else if (border instanceof EmptyBorder) {
            EmptyBorder emptyBorder = (EmptyBorder)border;
            this.borderList.setSelectedItem(new Integer(1));
            Insets insets = emptyBorder.getBorderInsets(this);
            this.topEmptyField.setText(String.valueOf(insets.top));
            this.leftEmptyField.setText(String.valueOf(insets.left));
            this.bottomEmptyField.setText(String.valueOf(insets.bottom));
            this.rightEmptyField.setText(String.valueOf(insets.right));
        } else if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            this.borderList.setSelectedItem(new Integer(6));
            this.titledField.setText(titledBorder.getTitle());
        }
        this.isSetSelectedBorder = false;
        this.border = border;
    }

    private class CustomCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CustomCellRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            if (n2 < 0) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jList.getModel();
                n2 = defaultComboBoxModel.getIndexOf(object);
            }
            this.setText((String)JCBorderChooser.this.borderNames.get(n2));
            this.setFont(jList.getFont());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

