/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.customizer.PropertyEditor;
import com.klg.jclass.chart3d.customizer.PropertyEditorTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedTemplate
extends PropertyEditorTemplate
implements ChangeListener {
    public static final int DEFAULT_SELECTION = 0;
    private int selectedIndex = -1;
    private PropertyEditor selectedEditor;
    private JPanel editorComponent;
    private JTabbedPane tabbedPane;

    public TabbedTemplate(PropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    public Component getEditorComponent() {
        if (this.editorComponent == null) {
            int n2;
            JPanel jPanel = new JPanel(new BorderLayout());
            Component component = this.getSource().getEditor();
            if (component != null) {
                jPanel.add(component, "West");
            }
            if ((n2 = this.getSource().getChildCount()) > 0) {
                this.tabbedPane = new JTabbedPane();
                this.tabbedPane.setBorder(new EmptyBorder(5, 5, 5, 5));
                int n3 = 0;
                while (n3 < n2) {
                    String string = this.getSource().getChildAt(n3).getName();
                    this.tabbedPane.add(string, new ProxyComponent());
                    ++n3;
                }
                jPanel.add((Component)this.tabbedPane, "Center");
            }
            this.editorComponent = new JPanel(new BorderLayout());
            this.editorComponent.add((Component)jPanel, "North");
            if (this.tabbedPane != null) {
                this.tabbedPane.addChangeListener(this);
                this.tabbedPane.setSelectedIndex(0);
                this.handleChange();
            }
        }
        return this.editorComponent;
    }

    private void handleChange() {
        if (this.tabbedPane.getSelectedIndex() == this.selectedIndex) {
            return;
        }
        if (this.selectedEditor != null) {
            this.selectedEditor.finalizeEditorTree();
            this.tabbedPane.setComponentAt(this.selectedIndex, new ProxyComponent());
        }
        this.selectedIndex = this.tabbedPane.getSelectedIndex();
        this.selectedEditor = this.getSource().getChildAt(this.selectedIndex);
        TabbedTemplate tabbedTemplate = new TabbedTemplate(this.selectedEditor);
        this.tabbedPane.setComponentAt(this.selectedIndex, tabbedTemplate.getEditorComponent());
        this.selectedEditor.refreshEditor();
        this.tabbedPane.invalidate();
        this.tabbedPane.revalidate();
        this.tabbedPane.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.handleChange();
    }

    public static class ProxyComponent
    extends Component {
    }
}

