/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class SymbolStyleEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static String nameKey = "Symbol Style";
    private boolean refreshing = false;
    private Container content;
    private JCColorChooser colorChooser;
    private JTextField sizeField;
    private JComboBox shapesComboBox;
    private List shapeNames;
    private List shapeClassNames;

    public SymbolStyleEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.colorChooser.removeActionListener(this);
            this.colorChooser = null;
            this.sizeField.removeActionListener(this);
            this.sizeField.removeFocusListener(this);
            this.sizeField = null;
            this.shapesComboBox.removeActionListener(this);
            this.shapesComboBox = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String[] stringArray;
            String string = Chart3dPropertyEditor.getLocalizedString("Symbol");
            this.colorChooser = this.getColorChooser();
            this.colorChooser.addActionListener(this);
            this.colorChooser.setAlignmentX(0.0f);
            this.colorChooser.setBorder(BorderFactory.createTitledBorder(string));
            string = Chart3dPropertyEditor.getLocalizedString("Size");
            JLabel jLabel = new JLabel(string);
            this.sizeField = Chart3dPropertyEditor.createTextField(8, this, this);
            string = Chart3dPropertyEditor.getLocalizedString("Symbol");
            JLabel jLabel2 = new JLabel(string);
            String[] stringArray2 = JCSymbolStyle.getDefaultShapes();
            this.shapeClassNames = new ArrayList();
            this.shapeNames = new ArrayList();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                stringArray = JCSymbolStyle.getSymbolShapeInstance(stringArray2[n2]);
                if (stringArray != null) {
                    this.shapeClassNames.add(stringArray2[n2]);
                    this.shapeNames.add(stringArray.getName());
                }
                ++n2;
            }
            stringArray = this.shapeNames.toArray(new String[0]);
            this.shapesComboBox = new JComboBox<String>(stringArray);
            this.shapesComboBox.addActionListener(this);
            this.shapesComboBox.setAlignmentX(0.0f);
            JPanel jPanel = Chart3dPropertyEditor.createBorderPanel();
            jPanel.setBorder(null);
            jPanel.add((Component)jLabel, "West");
            jPanel.add(this.sizeField);
            jPanel.setAlignmentX(0.0f);
            this.content = Chart3dPropertyEditor.createBorderPanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(this.colorChooser);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(this.shapesComboBox);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(jPanel);
        }
        return this.content;
    }

    protected abstract JCSymbolStyle getSelectedSymbolStyle();

    private void handleChange(Object object) {
        JCSymbolStyle jCSymbolStyle;
        if (this.refreshing) {
            return;
        }
        if (this.content != null && (jCSymbolStyle = this.getSelectedSymbolStyle()) != null) {
            int n2;
            if (object == this.colorChooser) {
                jCSymbolStyle.setColor(this.colorChooser.getColor());
            } else if (object == this.sizeField) {
                Integer n3 = Chart3dPropertyEditor.parseIntegerInput(this.sizeField);
                if (n3 == null || n3 < 0) {
                    this.refreshEditor();
                    return;
                }
                jCSymbolStyle.setSize(n3);
            } else if (object == this.shapesComboBox && (n2 = this.shapesComboBox.getSelectedIndex()) != -1) {
                jCSymbolStyle.setShape((String)this.shapeClassNames.get(n2));
            }
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCSymbolStyle jCSymbolStyle = this.getSelectedSymbolStyle();
            if (jCSymbolStyle != null) {
                this.colorChooser.setColor(jCSymbolStyle.getColor());
                this.sizeField.setText(String.valueOf(jCSymbolStyle.getSize()));
                int n2 = this.shapeClassNames.indexOf(jCSymbolStyle.getShape());
                if (n2 != -1) {
                    this.shapesComboBox.setSelectedIndex(n2);
                }
            }
            this.refreshing = false;
        }
    }
}

