/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class PlotCubeInteriorEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private static final String nameKey = "Interior";
    private boolean refreshing;
    private Container content;
    private JCColorChooser bgColorChooser;
    private JCColorChooser fgColorChooser;

    public PlotCubeInteriorEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Object object = actionEvent.getSource();
            JCPlotCube jCPlotCube = this.getChart().getChart3dArea().getPlotCube();
            if (object == this.bgColorChooser) {
                jCPlotCube.setBackground(this.bgColorChooser.getColor());
            } else if (object == this.fgColorChooser) {
                jCPlotCube.setForeground(this.fgColorChooser.getColor());
            }
        }
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.bgColorChooser.removeActionListener(this);
            this.bgColorChooser = null;
            this.fgColorChooser.removeActionListener(this);
            this.fgColorChooser = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Background");
            this.bgColorChooser = new JCColorChooser();
            this.bgColorChooser.setBorder(BorderFactory.createTitledBorder(string));
            this.bgColorChooser.addActionListener(this);
            string = Chart3dPropertyEditor.getLocalizedString("Foreground");
            this.fgColorChooser = new JCColorChooser();
            this.fgColorChooser.setBorder(BorderFactory.createTitledBorder(string));
            this.fgColorChooser.addActionListener(this);
            JPanel jPanel = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.bgColorChooser);
            jPanel.add(this.fgColorChooser);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel);
        }
        return this.content;
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCPlotCube jCPlotCube = this.getChart().getChart3dArea().getPlotCube();
            this.bgColorChooser.setColor(jCPlotCube.getBackground());
            this.fgColorChooser.setColor(jCPlotCube.getForeground());
            this.refreshing = false;
        }
    }
}

