/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PlotCubeGeneralEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "General";
    private boolean refreshing = false;
    private Container content;
    private JTextField xScaleField;
    private JTextField yScaleField;
    private JTextField zScaleField;

    public PlotCubeGeneralEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.xScaleField.removeActionListener(this);
            this.xScaleField.removeFocusListener(this);
            this.xScaleField = null;
            this.yScaleField.removeActionListener(this);
            this.yScaleField.removeFocusListener(this);
            this.yScaleField = null;
            this.zScaleField.removeActionListener(this);
            this.zScaleField.removeFocusListener(this);
            this.zScaleField = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("X Scale");
            JLabel jLabel = new JLabel(string);
            this.xScaleField = Chart3dPropertyEditor.createTextField(8, this, this);
            string = Chart3dPropertyEditor.getLocalizedString("Y Scale");
            JLabel jLabel2 = new JLabel(string);
            this.yScaleField = Chart3dPropertyEditor.createTextField(8, this, this);
            string = Chart3dPropertyEditor.getLocalizedString("Z Scale");
            JLabel jLabel3 = new JLabel(string);
            this.zScaleField = Chart3dPropertyEditor.createTextField(8, this, this);
            JPanel jPanel = new JPanel(new GridLayout(3, 0, 5, 5));
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(jLabel3);
            JPanel jPanel2 = new JPanel(new GridLayout(3, 0, 5, 5));
            jPanel2.add(this.xScaleField);
            jPanel2.add(this.yScaleField);
            jPanel2.add(this.zScaleField);
            JPanel jPanel3 = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel3);
        }
        return this.content;
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Double d2 = Chart3dPropertyEditor.parseDoubleInput((JTextField)object);
            if (d2 == null || d2 <= 0.0) {
                this.refreshEditor();
                return;
            }
            double d3 = d2;
            JCPlotCube jCPlotCube = this.getChart().getChart3dArea().getPlotCube();
            if (object == this.xScaleField) {
                jCPlotCube.setXScale(d3);
            } else if (object == this.yScaleField) {
                jCPlotCube.setYScale(d3);
            } else if (object == this.zScaleField) {
                jCPlotCube.setZScale(d3);
            }
            this.getChart().update();
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCPlotCube jCPlotCube = this.getChart().getChart3dArea().getPlotCube();
            this.xScaleField.setText(String.valueOf(jCPlotCube.getXScale()));
            this.yScaleField.setText(String.valueOf(jCPlotCube.getYScale()));
            this.zScaleField.setText(String.valueOf(jCPlotCube.getZScale()));
            this.refreshing = false;
        }
    }
}

