/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class LocationEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private boolean refreshing = false;
    private Container content;
    private JTextField[] intFields;
    private JCheckBox[] isDefaultCheckBoxes;

    public LocationEditor(String string) {
        super(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            int n2 = 0;
            while (n2 < 4) {
                this.intFields[n2].removeActionListener(this);
                this.intFields[n2].removeFocusListener(this);
                this.intFields[n2] = null;
                this.isDefaultCheckBoxes[n2].removeActionListener(this);
                this.isDefaultCheckBoxes[n2] = null;
                ++n2;
            }
            this.intFields = null;
            this.isDefaultCheckBoxes = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String[] stringArray = new String[]{"X", "Y", "Width", "Height"};
            JLabel[] jLabelArray = new JLabel[4];
            this.intFields = new JTextField[4];
            this.isDefaultCheckBoxes = new JCheckBox[4];
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 5, 5));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 5, 5));
            String string = Chart3dPropertyEditor.getLocalizedString("Default");
            int n2 = 0;
            while (n2 < 4) {
                jLabelArray[n2] = new JLabel(Chart3dPropertyEditor.getLocalizedString(stringArray[n2]));
                jPanel.add(jLabelArray[n2]);
                this.intFields[n2] = Chart3dPropertyEditor.createTextField(7, this, this);
                jPanel2.add(this.intFields[n2]);
                this.isDefaultCheckBoxes[n2] = Chart3dPropertyEditor.createCheckBox(string, this);
                jPanel3.add(this.isDefaultCheckBoxes[n2]);
                ++n2;
            }
            JPanel jPanel4 = Chart3dPropertyEditor.createBorderPanel();
            jPanel4.setBorder(null);
            jPanel4.add((Component)jPanel, "West");
            jPanel4.add(jPanel2);
            jPanel4.add((Component)jPanel3, "East");
            JPanel jPanel5 = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel5.add(jPanel4);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel5);
        }
        return this.content;
    }

    public abstract JComponent getLocationComponent();

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            JComponent jComponent = this.getLocationComponent();
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            int n2 = 0;
            while (n2 < 4) {
                Integer n3 = Chart3dPropertyEditor.parseIntegerInput(this.intFields[n2]);
                if (n3 == null) {
                    this.refreshEditor();
                    return;
                }
                nArray[n2] = n3;
                if (this.isDefaultCheckBoxes[n2].isSelected()) {
                    this.intFields[n2].setEnabled(false);
                    nArray2[n2] = Integer.MAX_VALUE;
                } else {
                    this.intFields[n2].setEnabled(true);
                    nArray2[n2] = n3;
                }
                ++n2;
            }
            jComponent.setBounds(nArray[0], nArray[1], nArray[2], nArray[3]);
            this.getChart().setLayoutHints(jComponent, new Rectangle(nArray2[0], nArray2[1], nArray2[2], nArray2[3]));
            this.getChart().revalidate();
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JComponent jComponent = this.getLocationComponent();
            Rectangle rectangle = jComponent.getBounds();
            int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
            Rectangle rectangle2 = this.getChart().getLayoutHints(jComponent);
            int[] nArray2 = new int[]{rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height};
            int n2 = 0;
            while (n2 < 4) {
                this.intFields[n2].setText(String.valueOf(nArray[n2]));
                boolean bl = nArray2[n2] == Integer.MAX_VALUE;
                this.isDefaultCheckBoxes[n2].setSelected(bl);
                this.intFields[n2].setEnabled(bl ^ true);
                ++n2;
            }
            this.refreshing = false;
        }
    }
}

