/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCChart3dLegend;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LegendSpacingEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "Spacing";
    private boolean refreshing = false;
    private Container content;
    private JTextField[] intFields;

    public LegendSpacingEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            int n2 = 0;
            while (n2 < 5) {
                this.intFields[n2].removeActionListener(this);
                this.intFields[n2].removeFocusListener(this);
                this.intFields[n2] = null;
                ++n2;
            }
            this.intFields = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String[] stringArray = new String[]{"Margin Gap", "Group Gap", "Horizontal Item Gap", "Vertical Item Gap", "Symbol To Text Gap"};
            JLabel[] jLabelArray = new JLabel[5];
            this.intFields = new JTextField[5];
            JPanel jPanel = new JPanel(new GridLayout(5, 0, 5, 5));
            JPanel jPanel2 = new JPanel(new GridLayout(5, 0, 5, 5));
            int n2 = 0;
            while (n2 < 5) {
                jLabelArray[n2] = new JLabel(Chart3dPropertyEditor.getLocalizedString(stringArray[n2]));
                this.intFields[n2] = Chart3dPropertyEditor.createTextField(8, this, this);
                jPanel.add(jLabelArray[n2]);
                jPanel2.add(this.intFields[n2]);
                ++n2;
            }
            JPanel jPanel3 = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel3);
        }
        return this.content;
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Integer n2 = Chart3dPropertyEditor.parseIntegerInput((JTextField)object);
            if (n2 == null || n2 < 0) {
                this.refreshEditor();
                return;
            }
            int n3 = n2;
            JCChart3dLegend jCChart3dLegend = (JCChart3dLegend)this.getChart().getLegend();
            if (object == this.intFields[0]) {
                jCChart3dLegend.setMarginGap(n3);
            } else if (object == this.intFields[1]) {
                jCChart3dLegend.setGroupGap(n3);
            } else if (object == this.intFields[2]) {
                jCChart3dLegend.setHorizontalItemGap(n3);
            } else if (object == this.intFields[3]) {
                jCChart3dLegend.setVerticalItemGap(n3);
            } else if (object == this.intFields[4]) {
                jCChart3dLegend.setInsideItemGap(n3);
            }
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            if (!(this.getChart().getLegend() instanceof JCChart3dLegend)) {
                this.content.setEnabled(false);
            }
            this.content.setEnabled(true);
            JCChart3dLegend jCChart3dLegend = (JCChart3dLegend)this.getChart().getLegend();
            int[] nArray = new int[]{jCChart3dLegend.getMarginGap(), jCChart3dLegend.getGroupGap(), jCChart3dLegend.getHorizontalItemGap(), jCChart3dLegend.getVerticalItemGap(), jCChart3dLegend.getInsideItemGap()};
            int n2 = 0;
            while (n2 < 5) {
                this.intFields[n2].setText(String.valueOf(nArray[n2]));
                ++n2;
            }
            this.refreshing = false;
        }
    }
}

