/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class InteriorEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private boolean refreshing;
    private Container content;
    private JCColorChooser bgColorChooser;
    private JCColorChooser fgColorChooser;
    private JCheckBox opaqueCheckBox;

    public InteriorEditor(String string) {
        super(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Object object = actionEvent.getSource();
            if (object == this.bgColorChooser) {
                this.getInteriorComponent().setBackground(this.bgColorChooser.getColor());
                return;
            }
            if (object == this.fgColorChooser) {
                this.getInteriorComponent().setForeground(this.fgColorChooser.getColor());
                return;
            }
            if (object == this.opaqueCheckBox) {
                boolean bl = this.opaqueCheckBox.isSelected();
                this.getInteriorComponent().setOpaque(bl);
                if (bl) {
                    this.getInteriorComponent().setBackground(this.bgColorChooser.getColor());
                }
                this.getInteriorComponent().repaint();
                return;
            }
        }
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.bgColorChooser.removeActionListener(this);
            this.bgColorChooser = null;
            this.fgColorChooser.removeActionListener(this);
            this.fgColorChooser = null;
            this.opaqueCheckBox.removeActionListener(this);
            this.opaqueCheckBox = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Background");
            this.bgColorChooser = new JCColorChooser();
            this.bgColorChooser.setBorder(BorderFactory.createTitledBorder(string));
            this.bgColorChooser.addActionListener(this);
            string = Chart3dPropertyEditor.getLocalizedString("Foreground");
            this.fgColorChooser = new JCColorChooser();
            this.fgColorChooser.setBorder(BorderFactory.createTitledBorder(string));
            this.fgColorChooser.addActionListener(this);
            string = Chart3dPropertyEditor.getLocalizedString("Opaque");
            this.opaqueCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            JPanel jPanel = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.bgColorChooser);
            jPanel.add(this.fgColorChooser);
            jPanel.add(this.opaqueCheckBox);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel);
        }
        return this.content;
    }

    public abstract JComponent getInteriorComponent();

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            this.bgColorChooser.setColor(this.getInteriorComponent().getBackground());
            this.fgColorChooser.setColor(this.getInteriorComponent().getForeground());
            this.opaqueCheckBox.setSelected(this.getInteriorComponent().isOpaque());
            this.refreshing = false;
        }
    }
}

