/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.ComboBoxEntry;
import com.klg.jclass.chart3d.customizer.MutableComboBoxEntry;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public abstract class FillStyleEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private static String nameKey = "Fill Style";
    private boolean refreshing = false;
    private Container content;
    private JCColorChooser fgColorChooser;
    private JCColorChooser bgColorChooser;
    private JLabel thumbnailLabel;
    private JButton imageButton;
    private JComboBox patternComboBox;
    private JCheckBox opaqueCheckBox;
    private Object[] patternModel;

    public FillStyleEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    protected Image doImageDialog(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                return string.endsWith(".gif") || string.endsWith(".jpg");
            }

            public String getDescription() {
                return "JPEG and GIF Image Files (*.jpg, *.gif)";
            }
        });
        int n2 = jFileChooser.showOpenDialog(component);
        Image image = null;
        if (n2 == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            ImageIcon imageIcon = new ImageIcon(string);
            if (imageIcon != null) {
                image = imageIcon.getImage();
            } else {
                Chart3dPropertyEditor.doError(component, "Error Loading Image File", "Error");
            }
        }
        return image;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.fgColorChooser.removeActionListener(this);
            this.fgColorChooser = null;
            this.bgColorChooser.removeActionListener(this);
            this.bgColorChooser = null;
            this.opaqueCheckBox.removeActionListener(this);
            this.opaqueCheckBox = null;
            this.patternComboBox.removeActionListener(this);
            this.patternComboBox = null;
            this.imageButton.removeActionListener(this);
            this.imageButton = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Fill");
            this.fgColorChooser = this.getColorChooser();
            this.fgColorChooser.addActionListener(this);
            this.fgColorChooser.setAlignmentX(0.0f);
            this.fgColorChooser.setBorder(BorderFactory.createTitledBorder(string));
            this.bgColorChooser = this.getColorChooser();
            this.bgColorChooser.addActionListener(this);
            string = Chart3dPropertyEditor.getLocalizedString("Opaque");
            this.opaqueCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Background");
            JPanel jPanel = Chart3dPropertyEditor.createBorderPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
            jPanel.setAlignmentX(0.0f);
            jPanel.add(this.bgColorChooser);
            jPanel.add((Component)this.opaqueCheckBox, "South");
            string = Chart3dPropertyEditor.getLocalizedString("Pattern");
            JLabel jLabel = new JLabel(string);
            this.patternModel = new ComboBoxEntry[]{new ComboBoxEntry(0, Chart3dPropertyEditor.getLocalizedString("None")), new ComboBoxEntry(1, Chart3dPropertyEditor.getLocalizedString("Solid")), new ComboBoxEntry(2, Chart3dPropertyEditor.getLocalizedString("Per 25")), new ComboBoxEntry(3, Chart3dPropertyEditor.getLocalizedString("Per 50")), new ComboBoxEntry(4, Chart3dPropertyEditor.getLocalizedString("Per 75")), new ComboBoxEntry(5, Chart3dPropertyEditor.getLocalizedString("Horizontal Stripe")), new ComboBoxEntry(6, Chart3dPropertyEditor.getLocalizedString("Vertical Stripe")), new ComboBoxEntry(7, Chart3dPropertyEditor.getLocalizedString("Stripe 45")), new ComboBoxEntry(8, Chart3dPropertyEditor.getLocalizedString("Stripe 135")), new ComboBoxEntry(9, Chart3dPropertyEditor.getLocalizedString("Diagonal Hatched")), new ComboBoxEntry(10, Chart3dPropertyEditor.getLocalizedString("Cross Hatched")), new ComboBoxEntry(11, Chart3dPropertyEditor.getLocalizedString("Custom Fill")), new ComboBoxEntry(12, Chart3dPropertyEditor.getLocalizedString("Custom Stack")), new ComboBoxEntry(13, Chart3dPropertyEditor.getLocalizedString("Custom Paint"))};
            Arrays.sort(this.patternModel);
            this.patternComboBox = Chart3dPropertyEditor.createComboBox(this.patternModel, this);
            JPanel jPanel2 = Chart3dPropertyEditor.createBorderPanel();
            jPanel2.setBorder(null);
            jPanel2.add((Component)jLabel, "West");
            jPanel2.add(this.patternComboBox);
            jPanel2.setAlignmentX(0.0f);
            string = Chart3dPropertyEditor.getLocalizedString("Image");
            this.thumbnailLabel = new JLabel();
            this.thumbnailLabel.setBorder(BorderFactory.createEtchedBorder());
            this.thumbnailLabel.setMaximumSize(new Dimension(50, 50));
            this.thumbnailLabel.setMinimumSize(new Dimension(50, 50));
            this.thumbnailLabel.setPreferredSize(new Dimension(50, 50));
            string = Chart3dPropertyEditor.getLocalizedString("Open");
            this.imageButton = Chart3dPropertyEditor.createButton(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Image");
            JLabel jLabel2 = new JLabel(string);
            jLabel2.setHorizontalAlignment(0);
            jLabel2.setVerticalAlignment(0);
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel3.setAlignmentX(0.0f);
            jPanel3.add(jLabel2);
            jPanel3.add(this.thumbnailLabel);
            jPanel3.add(this.imageButton);
            this.content = Chart3dPropertyEditor.createBorderPanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(this.fgColorChooser);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(jPanel);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(jPanel2);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(jPanel3);
        }
        return this.content;
    }

    protected abstract JCFillStyle getSelectedFillStyle();

    private void handleChange(Object object) {
        JCFillStyle jCFillStyle;
        if (this.refreshing) {
            return;
        }
        if (this.content != null && (jCFillStyle = this.getSelectedFillStyle()) != null) {
            Image image;
            if (object == this.fgColorChooser) {
                jCFillStyle.setColor(this.fgColorChooser.getColor());
            } else if (object == this.bgColorChooser) {
                jCFillStyle.setBackground(this.bgColorChooser.getColor());
            } else if (object == this.opaqueCheckBox) {
                boolean bl = this.opaqueCheckBox.isSelected();
                this.bgColorChooser.setEnabled(bl);
                if (!bl) {
                    jCFillStyle.setBackground(null);
                } else {
                    jCFillStyle.setBackground(this.bgColorChooser.getColor());
                }
            } else if (object == this.patternComboBox) {
                int n2 = ((ComboBoxEntry)this.patternComboBox.getSelectedItem()).getConstant();
                jCFillStyle.setPattern(n2);
            } else if (object == this.imageButton && (image = this.doImageDialog(this.imageButton)) != null) {
                jCFillStyle.setImage(image);
                this.thumbnailLabel.setIcon(new ImageIcon(image));
            }
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCFillStyle jCFillStyle = this.getSelectedFillStyle();
            if (jCFillStyle != null) {
                this.fgColorChooser.setColor(jCFillStyle.getColor());
                Color color = jCFillStyle.getBackground();
                boolean bl = color != null;
                this.bgColorChooser.setEnabled(bl);
                this.bgColorChooser.setColor(color);
                this.opaqueCheckBox.setSelected(bl);
                MutableComboBoxEntry mutableComboBoxEntry = new MutableComboBoxEntry();
                mutableComboBoxEntry.setConstant(jCFillStyle.getPattern());
                this.patternComboBox.setSelectedIndex(Arrays.binarySearch(this.patternModel, mutableComboBoxEntry));
                Image image = jCFillStyle.getImage();
                if (image == null) {
                    this.thumbnailLabel.setIcon(null);
                } else {
                    this.thumbnailLabel.setIcon(new ImageIcon(image));
                }
            }
            this.refreshing = false;
        }
    }
}

