/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataViewTitleEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "Titles";
    private boolean refreshing = false;
    private Container content;
    private JTextField titleField;

    public DataViewTitleEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.titleField.removeActionListener(this);
            this.titleField.removeFocusListener(this);
            this.titleField = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString(nameKey);
            JLabel jLabel = new JLabel(string);
            this.titleField = Chart3dPropertyEditor.createTextField(16, this, this);
            JPanel jPanel = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel.add((Component)jLabel, "West");
            jPanel.add(this.titleField);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel);
        }
        return this.content;
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            chart3dDataView.setName(this.titleField.getText());
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            this.titleField.setText(chart3dDataView.getName());
            this.refreshing = false;
        }
    }
}

