/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.JCGridColor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DataViewGridColorsEditor
extends Chart3dPropertyEditor
implements ActionListener,
ListDataListener {
    private static final String nameKey = "Grid Colors";
    private static String all = Chart3dPropertyEditor.getLocalizedString("All");
    private boolean refreshing = false;
    private Container content;
    private JList gridColorsList;
    private JButton addButton;
    private JButton removeButton;
    private GridColorsModel gridColorsModel;
    private JCColorChooser colorChooser;

    public DataViewGridColorsEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            int n2;
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            Object object = actionEvent.getSource();
            if (object == this.addButton) {
                JCGridColor jCGridColor = this.showGridValueDialog(this.addButton, "Add", null);
                if (jCGridColor != null) {
                    this.gridColorsModel.add(jCGridColor);
                }
            } else if (object == this.removeButton) {
                if (this.gridColorsList.getSelectedIndex() != -1) {
                    this.gridColorsModel.remove(this.gridColorsList.getSelectedIndex());
                }
            } else if (object == this.colorChooser && (n2 = this.gridColorsList.getSelectedIndex()) != -1) {
                Color color = this.colorChooser.getColor();
                this.gridColorsModel.getGridColorAt(n2).setColor(color);
                this.handleGridColorChange();
            }
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.handleGridColorChange();
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.gridColorsModel.removeListDataListener(this);
            this.gridColorsModel = null;
            this.gridColorsList = null;
            this.addButton.removeActionListener(this);
            this.addButton = null;
            this.removeButton.removeActionListener(this);
            this.removeButton = null;
            this.colorChooser.removeActionListener(this);
            this.colorChooser = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("XY Grids");
            JLabel jLabel = new JLabel(string);
            string = Chart3dPropertyEditor.getLocalizedString("Add");
            this.addButton = Chart3dPropertyEditor.createButton(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Remove");
            this.removeButton = Chart3dPropertyEditor.createButton(string, this);
            this.gridColorsModel = new GridColorsModel();
            this.gridColorsModel.addListDataListener(this);
            this.gridColorsList = new JList(this.gridColorsModel);
            this.gridColorsList.setPrototypeCellValue("XXXXXXXXXXXX");
            JScrollPane jScrollPane = new JScrollPane(this.gridColorsList, 20, 30);
            jScrollPane.setAlignmentX(0.0f);
            string = Chart3dPropertyEditor.getLocalizedString(nameKey);
            this.colorChooser = this.getColorChooser();
            this.colorChooser.addActionListener(this);
            this.colorChooser.setBorder(BorderFactory.createTitledBorder(string));
            JPanel jPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel.add(this.addButton);
            jPanel.add(this.removeButton);
            jPanel.setAlignmentX(0.0f);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(jLabel);
            jPanel2.add(jScrollPane);
            jPanel2.add(Box.createVerticalStrut(5));
            jPanel2.add(jPanel);
            this.content = Chart3dPropertyEditor.createPreferredSizePanel();
            this.content.setLayout(new BoxLayout(this.content, 0));
            this.content.add(jPanel2);
            this.content.add(Box.createHorizontalStrut(5));
            this.content.add(this.colorChooser);
        }
        return this.content;
    }

    private void handleGridColorChange() {
        if (this.refreshing) {
            return;
        }
        DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
        Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
        chart3dDataView.setGridColors(this.gridColorsModel.getGridColors());
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.handleGridColorChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.handleGridColorChange();
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            boolean bl = chart3dDataView.getElevationData() instanceof Chart3dGridData;
            this.gridColorsList.setEnabled(bl);
            this.addButton.setEnabled(bl);
            this.removeButton.setEnabled(bl);
            this.colorChooser.setEnabled(bl);
            if (!bl) {
                return;
            }
            Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dDataView.getElevationData();
            this.gridColorsModel.setGridColors(chart3dDataView.getGridColors());
            this.refreshing = false;
        }
    }

    private JCGridColor showGridValueDialog(Component component, String string, JCGridColor jCGridColor) {
        String string2 = Chart3dPropertyEditor.getLocalizedString("X");
        JLabel jLabel = new JLabel(string2);
        string2 = Chart3dPropertyEditor.getLocalizedString("Y");
        JLabel jLabel2 = new JLabel(string2);
        JPanel jPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        JTextField jTextField = new JTextField(8);
        JTextField jTextField2 = new JTextField(8);
        if (jCGridColor != null) {
            jTextField.setText(String.valueOf(jCGridColor.getX()));
            jTextField2.setText(String.valueOf(jCGridColor.getY()));
        }
        JPanel jPanel2 = new JPanel(new GridLayout(2, 0, 5, 5));
        jPanel2.add(jTextField);
        jPanel2.add(jTextField2);
        JPanel jPanel3 = Chart3dPropertyEditor.createPreferredSizePanel();
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add(jPanel2);
        int n2 = JOptionPane.showOptionDialog(component, jPanel3, Chart3dPropertyEditor.getLocalizedString(string), 2, -1, null, null, null);
        if (n2 == 0) {
            Integer n3 = null;
            Integer n4 = null;
            n3 = jTextField.getText().equalsIgnoreCase(all) ? new Integer(-100) : Chart3dPropertyEditor.parseIntegerInput(jTextField);
            if (n3 == null) {
                return null;
            }
            n4 = jTextField2.getText().equalsIgnoreCase(all) ? new Integer(-100) : Chart3dPropertyEditor.parseIntegerInput(jTextField2);
            if (n4 == null) {
                return null;
            }
            if (n4 != null) {
                if (jCGridColor != null) {
                    jCGridColor.setX(n3);
                    jCGridColor.setY(n4);
                    return null;
                }
                return new JCGridColor(n3, n4, this.colorChooser.getColor());
            }
        }
        return null;
    }

    private static class GridColorsModel
    extends AbstractListModel {
        private ArrayList gridColors = new ArrayList();

        public void add(JCGridColor jCGridColor) {
            if (jCGridColor != null) {
                this.gridColors.add(jCGridColor);
                this.fireIntervalAdded(this, this.getSize(), this.getSize());
            }
        }

        public Object getElementAt(int n2) {
            return this.toString((JCGridColor)this.gridColors.get(n2));
        }

        public JCGridColor getGridColorAt(int n2) {
            return (JCGridColor)this.gridColors.get(n2);
        }

        public ArrayList getGridColors() {
            return this.gridColors;
        }

        public int getSize() {
            if (this.gridColors == null) {
                return 0;
            }
            return this.gridColors.size();
        }

        public void remove(int n2) {
            this.gridColors.remove(n2);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public void setGridColors(ArrayList arrayList) {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
            }
            if (arrayList == null) {
                return;
            }
            this.gridColors = arrayList;
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        private String toString(JCGridColor jCGridColor) {
            if (jCGridColor == null) {
                return "";
            }
            int n2 = jCGridColor.getX();
            int n3 = jCGridColor.getY();
            String string = n2 == -100 ? all : String.valueOf(n2);
            String string2 = n3 == -100 ? all : String.valueOf(n3);
            return String.valueOf(string) + "," + string2;
        }
    }
}

