/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;

public class DataViewElevationEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private static String nameKey = "Elevation";
    private boolean refreshing = false;
    private Container content;
    private JCColorChooser colorChooser;
    private JComboBox colorComboBox;

    public DataViewElevationEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.colorChooser.removeActionListener(this);
            this.colorChooser = null;
            this.colorComboBox.removeActionListener(this);
            this.colorComboBox = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Elevation");
            this.colorChooser = this.getColorChooser();
            this.colorChooser.addActionListener(this);
            this.colorChooser.setAlignmentX(0.0f);
            this.colorChooser.setBorder(BorderFactory.createTitledBorder(string));
            String[] stringArray = new String[]{Chart3dPropertyEditor.getLocalizedString("Mesh Top Color"), Chart3dPropertyEditor.getLocalizedString("Mesh Bottom Color"), Chart3dPropertyEditor.getLocalizedString("Shaded Top Color"), Chart3dPropertyEditor.getLocalizedString("Shaded Bottom Color")};
            this.colorComboBox = new JComboBox<String>(stringArray);
            this.colorComboBox.setAlignmentX(0.0f);
            this.colorComboBox.addActionListener(this);
            this.content = Chart3dPropertyEditor.createBorderPanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(this.colorComboBox);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(this.colorChooser);
        }
        return this.content;
    }

    protected JCElevation getElevation() {
        DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
        Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
        if (chart3dDataView != null) {
            return chart3dDataView.getElevation();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content == null) return;
        if (object == this.colorChooser) {
            int n2 = this.colorComboBox.getSelectedIndex();
            if (n2 == -1) return;
            JCElevation jCElevation = this.getElevation();
            Color color = this.colorChooser.getColor();
            switch (n2) {
                case 0: {
                    jCElevation.setMeshTopColor(color);
                    return;
                }
                case 1: {
                    jCElevation.setMeshBottomColor(color);
                    return;
                }
                case 2: {
                    jCElevation.setShadedTopColor(color);
                    return;
                }
                case 3: {
                    jCElevation.setShadedBottomColor(color);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (object != this.colorComboBox) return;
        this.refreshEditor();
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            int n2 = this.colorComboBox.getSelectedIndex();
            if (n2 != -1) {
                JCElevation jCElevation = this.getElevation();
                Color color = null;
                switch (n2) {
                    case 0: {
                        color = jCElevation.getMeshTopColor();
                        break;
                    }
                    case 1: {
                        color = jCElevation.getMeshBottomColor();
                        break;
                    }
                    case 2: {
                        color = jCElevation.getShadedTopColor();
                        break;
                    }
                    case 3: {
                        color = jCElevation.getShadedBottomColor();
                        break;
                    }
                }
                if (color != null) {
                    this.colorChooser.setColor(color);
                }
            }
            this.refreshing = false;
        }
    }
}

