/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DataViewDataLabelsEditor
extends Chart3dPropertyEditor
implements ActionListener,
ListDataListener {
    private static final String nameKey = "Data Labels";
    private boolean refreshing = false;
    private Container content;
    private JComboBox axisComboBox;
    private JList dataLabelsList;
    private JButton addButton;
    private JButton removeButton;
    private DataLabelsModel dataLabelsModel;

    public DataViewDataLabelsEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Object object = actionEvent.getSource();
            if (object == this.addButton) {
                String string = this.showDataLabelsDialog(this.addButton, "Add");
                if (string != null) {
                    this.dataLabelsModel.add(string);
                }
            } else if (object == this.removeButton) {
                if (this.dataLabelsList.getSelectedIndex() != -1) {
                    this.dataLabelsModel.remove(this.dataLabelsList.getSelectedIndex());
                }
            } else if (object == this.axisComboBox) {
                this.refreshEditor();
            }
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.axisComboBox.removeActionListener(this);
            this.axisComboBox = null;
            this.dataLabelsModel.removeListDataListener(this);
            this.dataLabelsModel = null;
            this.dataLabelsList = null;
            this.addButton.removeActionListener(this);
            this.addButton = null;
            this.removeButton.removeActionListener(this);
            this.removeButton = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String[] stringArray = new String[]{Chart3dPropertyEditor.getLocalizedString("X Axis"), Chart3dPropertyEditor.getLocalizedString("Y Axis")};
            this.axisComboBox = new JComboBox<String>(stringArray);
            this.axisComboBox.setAlignmentX(0.0f);
            this.axisComboBox.addActionListener(this);
            String string = Chart3dPropertyEditor.getLocalizedString("Add");
            this.addButton = Chart3dPropertyEditor.createButton(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Remove");
            this.removeButton = Chart3dPropertyEditor.createButton(string, this);
            this.dataLabelsModel = new DataLabelsModel();
            this.dataLabelsModel.addListDataListener(this);
            this.dataLabelsList = new JList(this.dataLabelsModel);
            this.dataLabelsList.setPrototypeCellValue("XXXXXXXXXXXX");
            JScrollPane jScrollPane = new JScrollPane(this.dataLabelsList, 20, 30);
            jScrollPane.setAlignmentX(0.0f);
            JPanel jPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel.add(this.addButton);
            jPanel.add(this.removeButton);
            jPanel.setAlignmentX(0.0f);
            this.content = Chart3dPropertyEditor.createBorderPanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(this.axisComboBox);
            this.content.add(Box.createVerticalStrut(5));
            this.content.add(jScrollPane);
            this.content.add(Box.createVerticalStrut(5));
            this.content.add(jPanel);
        }
        return this.content;
    }

    public void handleChange() {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dDataView.getElevationData();
            int n2 = this.axisComboBox.getSelectedIndex();
            if (n2 != -1) {
                Object var5_5 = null;
                if (n2 == 0) {
                    chart3dGridData.setXLabels(this.dataLabelsModel.getDataLabels());
                } else {
                    chart3dGridData.setYLabels(this.dataLabelsModel.getDataLabels());
                }
            }
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            Chart3dData chart3dData = chart3dDataView.getElevationData();
            if (!(chart3dData instanceof Chart3dGridData)) {
                this.content.setEnabled(false);
                return;
            }
            this.content.setEnabled(false);
            Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dData;
            int n2 = this.axisComboBox.getSelectedIndex();
            if (n2 != -1) {
                String[] stringArray = null;
                stringArray = n2 == 0 ? chart3dGridData.getXLabels() : chart3dGridData.getYLabels();
                this.dataLabelsModel.setDataLabels(stringArray);
            }
            this.refreshing = false;
        }
    }

    private String showDataLabelsDialog(Component component, String string) {
        String string2 = Chart3dPropertyEditor.getLocalizedString(nameKey);
        JLabel jLabel = new JLabel(string2);
        JTextField jTextField = new JTextField(10);
        JPanel jPanel = Chart3dPropertyEditor.createPreferredSizePanel();
        jPanel.add((Component)jLabel, "West");
        jPanel.add(jTextField);
        int n2 = JOptionPane.showOptionDialog(component, jPanel, Chart3dPropertyEditor.getLocalizedString(string), 2, -1, null, null, null);
        if (n2 == 0) {
            return jTextField.getText();
        }
        return null;
    }

    private static class DataLabelsModel
    extends AbstractListModel {
        private List dataLabels = new ArrayList();

        public void add(String string) {
            this.dataLabels.add(string);
            this.fireIntervalAdded(this, this.getSize(), this.getSize());
        }

        public String getDataLabelAt(int n2) {
            return (String)this.dataLabels.get(n2);
        }

        public String[] getDataLabels() {
            return this.dataLabels.toArray(new String[0]);
        }

        public Object getElementAt(int n2) {
            return this.dataLabels.get(n2);
        }

        public int getSize() {
            return this.dataLabels.size();
        }

        public void remove(int n2) {
            this.dataLabels.remove(n2);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public void setDataLabels(String[] stringArray) {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
                this.dataLabels.clear();
            }
            if (stringArray == null) {
                return;
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.dataLabels.add(stringArray[n2]);
                ++n2;
            }
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }
    }
}

