/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import com.klg.jclass.chart3d.customizer.PropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataViewChartStyleEditor
extends Chart3dPropertyEditor
implements ListSelectionListener {
    private static String[] children = new String[]{"com.klg.jclass.chart3d.customizer.DataViewChartStyleLineStyleEditor", "com.klg.jclass.chart3d.customizer.DataViewChartStyleSymbolStyleEditor"};
    private static final String nameKey = "Grid Style";
    private boolean refreshing = false;
    private Container content;
    private Container dataListContainer;
    private JList dataList;

    public DataViewChartStyleEditor() {
        super(nameKey, children);
    }

    public DataViewChartStyleEditor(PropertyEditor propertyEditor) {
        super(nameKey, propertyEditor, children);
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.dataList.removeListSelectionListener(this);
            this.dataList = null;
            this.dataListContainer = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            this.dataList = new JList();
            this.dataListContainer = Chart3dPropertyEditor.createPreferredSizePanel();
            this.dataListContainer.setLayout(new GridLayout(0, 1, 5, 5));
            this.dataListContainer.add(this.dataList);
            this.content = Box.createVerticalBox();
            this.content.add(this.dataListContainer);
        }
        return this.content;
    }

    public JCChart3dStyle getSelectedChartStyle() {
        if (this.hasGridData()) {
            return ((Chart3dGridData)this.getSelectedData()).getChartStyle();
        }
        int n2 = this.dataList.getSelectedIndex();
        if (n2 != -1) {
            return ((Chart3dPointData)this.getSelectedData()).getSeries(n2).getChartStyle();
        }
        return null;
    }

    public Chart3dData getSelectedData() {
        if (this.content != null) {
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            return chart3dDataView.getElevationData();
        }
        return null;
    }

    public boolean hasGridData() {
        return this.getSelectedData() instanceof Chart3dGridData;
    }

    public boolean hasPointData() {
        return this.getSelectedData() instanceof Chart3dPointData;
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            String[] stringArray = null;
            if (this.hasPointData()) {
                Chart3dPointData chart3dPointData = (Chart3dPointData)this.getSelectedData();
                int n2 = chart3dPointData.getNumSeries();
                stringArray = new String[n2];
                String string = Chart3dPropertyEditor.getLocalizedString("Series");
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3] = String.valueOf(string) + " " + n3;
                    ++n3;
                }
            } else {
                String string = Chart3dPropertyEditor.getLocalizedString("Data View");
                stringArray = new String[]{String.valueOf(string) + " " + 0};
            }
            this.dataList.removeListSelectionListener(this);
            this.dataList = Chart3dPropertyEditor.createList(stringArray, this);
            this.dataList.setPrototypeCellValue("XXXXXXXXXXXX");
            this.dataListContainer.removeAll();
            this.dataListContainer.add(this.dataList);
            this.refreshing = false;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.refreshing) {
            return;
        }
        this.refreshEditorTree();
    }
}

