/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChartAreaSurfaceEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "Surface";
    private boolean refreshing = false;
    private Container content;
    private JCheckBox isSolidCheckBox;
    private JCheckBox isXMeshCheckBox;
    private JCheckBox isYMeshCheckBox;
    private JTextField xMeshFilterField;
    private JTextField yMeshFilterField;

    public ChartAreaSurfaceEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.changePerformed(actionEvent.getSource());
    }

    public void changePerformed(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            JCSurface jCSurface = this.getChart().getChart3dArea().getSurface();
            if (object == this.isSolidCheckBox) {
                jCSurface.setSolid(this.isSolidCheckBox.isSelected());
            } else if (object == this.isXMeshCheckBox) {
                jCSurface.setXMeshShowing(this.isXMeshCheckBox.isSelected());
            } else if (object == this.isYMeshCheckBox) {
                jCSurface.setYMeshShowing(this.isYMeshCheckBox.isSelected());
            } else if (object == this.xMeshFilterField) {
                Integer n2 = Chart3dPropertyEditor.parseIntegerInput(this.xMeshFilterField);
                if (n2 != null && n2 >= 0) {
                    jCSurface.setXMeshFilter(n2);
                } else {
                    this.refreshEditor();
                }
            } else if (object == this.yMeshFilterField) {
                Integer n3 = Chart3dPropertyEditor.parseIntegerInput(this.yMeshFilterField);
                if (n3 != null && n3 >= 0) {
                    jCSurface.setYMeshFilter(n3);
                } else {
                    this.refreshEditor();
                }
            }
        }
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.isSolidCheckBox.removeActionListener(this);
            this.isSolidCheckBox = null;
            this.isXMeshCheckBox.removeActionListener(this);
            this.isXMeshCheckBox = null;
            this.isYMeshCheckBox.removeActionListener(this);
            this.isYMeshCheckBox = null;
            this.xMeshFilterField.removeActionListener(this);
            this.xMeshFilterField.removeFocusListener(this);
            this.xMeshFilterField = null;
            this.yMeshFilterField.removeActionListener(this);
            this.yMeshFilterField.removeFocusListener(this);
            this.yMeshFilterField = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.changePerformed(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Solid");
            this.isSolidCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("X Mesh");
            this.isXMeshCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Y Mesh");
            this.isYMeshCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("X Mesh Filter");
            JLabel jLabel = new JLabel(string);
            this.xMeshFilterField = Chart3dPropertyEditor.createTextField(5, this, this);
            string = Chart3dPropertyEditor.getLocalizedString("Y Mesh Filter");
            JLabel jLabel2 = new JLabel(string);
            this.yMeshFilterField = Chart3dPropertyEditor.createTextField(5, this, this);
            JPanel jPanel = Chart3dPropertyEditor.createBorderPanel();
            jPanel.setBorder(null);
            jPanel.add((Component)jLabel, "West");
            jPanel.add(this.xMeshFilterField);
            JPanel jPanel2 = Chart3dPropertyEditor.createBorderPanel();
            jPanel2.setBorder(null);
            jPanel2.add((Component)jLabel2, "West");
            jPanel2.add(this.yMeshFilterField);
            JPanel jPanel3 = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel3.setLayout(new GridLayout(0, 1, 5, 5));
            jPanel3.add(this.isSolidCheckBox);
            jPanel3.add(this.isXMeshCheckBox);
            jPanel3.add(this.isYMeshCheckBox);
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel3);
        }
        return this.content;
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCSurface jCSurface = this.getChart().getChart3dArea().getSurface();
            this.isSolidCheckBox.setSelected(jCSurface.isSolid());
            this.isXMeshCheckBox.setSelected(jCSurface.isXMeshShowing());
            this.isYMeshCheckBox.setSelected(jCSurface.isYMeshShowing());
            this.xMeshFilterField.setText(String.valueOf(jCSurface.getXMeshFilter()));
            this.yMeshFilterField.setText(String.valueOf(jCSurface.getYMeshFilter()));
            this.refreshing = false;
        }
    }
}

