/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;

public class ChartAreaScatterEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private static final String nameKey = "Surface";
    private boolean refreshing = false;
    private Container content;
    private JCheckBox dropLinesCheckBox;

    public ChartAreaScatterEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.dropLinesCheckBox.removeActionListener(this);
            this.dropLinesCheckBox = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Drop Lines");
            this.dropLinesCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            this.content = Chart3dPropertyEditor.createBorderPanel();
            this.content.setLayout(new BoxLayout(this.content, 0));
            this.content.add(this.dropLinesCheckBox);
        }
        return this.content;
    }

    public void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            this.getChart().getChart3dArea().getScatter().setDropLines(this.dropLinesCheckBox.isSelected());
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            boolean bl = this.getChart().getChart3dArea().getScatter().hasDropLines();
            this.dropLinesCheckBox.setSelected(bl);
            this.refreshing = false;
        }
    }
}

