/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.customizer.AbstractChart3dCustomizer;
import com.klg.jclass.chart3d.customizer.AbstractPropertyEditor;
import com.klg.jclass.chart3d.customizer.NotFoundEditor;
import com.klg.jclass.chart3d.customizer.PropertyEditor;
import com.klg.jclass.chart3d.customizer.util.JCBorderChooser;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.swing.JCFontChooserPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public abstract class Chart3dPropertyEditor
extends AbstractPropertyEditor {
    private static JCLocaleManager localeManager = new JCLocaleManager("com.klg.jclass.chart3d.customizer.resources.LocaleInfo");
    private String nameKey;
    private List children;

    public Chart3dPropertyEditor(String string) {
        this(string, null);
    }

    public Chart3dPropertyEditor(String string, PropertyEditor propertyEditor, String[] stringArray) {
        super(propertyEditor);
        this.nameKey = string;
        if (stringArray != null && stringArray.length > 0) {
            int n2 = stringArray.length;
            this.children = new ArrayList(n2);
            int n3 = 0;
            while (n3 < n2) {
                this.children.add(n3, stringArray[n3]);
                ++n3;
            }
        }
        if (localeManager == null) {
            localeManager = JCLocaleManager.getDefault();
            localeManager.add("com.klg.jclass.chart3d.customizer.resources.LocaleInfo");
        }
    }

    public Chart3dPropertyEditor(String string, String[] stringArray) {
        this(string, null, stringArray);
    }

    protected boolean childExistsAt(int n2) {
        return this.children != null && this.children.get(n2) instanceof PropertyEditor;
    }

    public static JPanel createBorderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return jPanel;
    }

    public static JPanel createBorderPanel(int n2, int n3, int n4, int n5) {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(n2, n3, n4, n5));
        return jPanel;
    }

    public static JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JCheckBox createCheckBox(String string, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.addActionListener(actionListener);
        return jCheckBox;
    }

    public static JComboBox createComboBox(Object[] objectArray, ActionListener actionListener) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.addActionListener(actionListener);
        return jComboBox;
    }

    public static JList createList(String[] stringArray, ListSelectionListener listSelectionListener) {
        JList<String> jList = new JList<String>(stringArray);
        jList.setBorder(BorderFactory.createEtchedBorder());
        jList.addListSelectionListener(listSelectionListener);
        jList.setSelectedIndex(0);
        return jList;
    }

    public static JPanel createPreferredSizePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5)){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return jPanel;
    }

    public static JRadioButton createRadioButton(String string, ActionListener actionListener) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    public static JTextField createTextField(int n2, ActionListener actionListener, FocusListener focusListener) {
        JTextField jTextField = new JTextField(n2);
        jTextField.addActionListener(actionListener);
        jTextField.addFocusListener(focusListener);
        return jTextField;
    }

    public static void doError(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, Chart3dPropertyEditor.getLocalizedString(string), Chart3dPropertyEditor.getLocalizedString(string2), 0);
    }

    public void finalizeEditor() {
    }

    public void finalizeEditorTree() {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            if (this.childExistsAt(n2)) {
                this.getChildAt(n2).finalizeEditorTree();
            }
            ++n2;
        }
        this.finalizeEditor();
    }

    public JCBorderChooser getBorderChooser() {
        return new JCBorderChooser();
    }

    public JCChart3d getChart() {
        return this.getCustomizer().getTarget();
    }

    public PropertyEditor getChildAt(int n2) {
        if (this.childExistsAt(n2)) {
            return (PropertyEditor)this.children.get(n2);
        }
        PropertyEditor propertyEditor = null;
        String string = (String)this.children.remove(n2);
        try {
            Class<?> clazz = Class.forName(string);
            propertyEditor = (PropertyEditor)clazz.newInstance();
            propertyEditor.setParent(this);
        }
        catch (Exception exception) {
            System.out.println("Class " + string + " not found.");
            System.out.println(exception.toString());
            propertyEditor = new NotFoundEditor();
        }
        this.children.add(n2, propertyEditor);
        return propertyEditor;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public JCColorChooser getColorChooser() {
        return new JCColorChooser();
    }

    public AbstractChart3dCustomizer getCustomizer() {
        return (AbstractChart3dCustomizer)this.getRoot();
    }

    public Component getEditor() {
        return null;
    }

    public JCFontChooserPane getFontChooser() {
        return new JCFontChooserPane();
    }

    public int getIndexOfChild(PropertyEditor propertyEditor) {
        if (this.isLeaf()) {
            return -1;
        }
        return this.children.indexOf(propertyEditor);
    }

    public static JCLocaleManager getLocaleManager() {
        return localeManager;
    }

    public static String getLocalizedString(String string) {
        if (string == null) {
            return "";
        }
        String string2 = localeManager.getString(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String getName() {
        return Chart3dPropertyEditor.getLocalizedString(this.nameKey);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public static Double parseDoubleInput(JTextComponent jTextComponent) {
        try {
            return new Double(jTextComponent.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Chart3dPropertyEditor.doError(jTextComponent, "Illegal Value", "Error");
            return null;
        }
    }

    public static Integer parseIntegerInput(JTextComponent jTextComponent) {
        try {
            return new Integer(jTextComponent.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Chart3dPropertyEditor.doError(jTextComponent, "Integers Only", "Error");
            return null;
        }
    }

    public void refreshEditor() {
    }

    public void refreshEditorTree() {
        this.refreshEditorTree(true);
    }

    public void refreshEditorTree(boolean bl) {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            if (this.childExistsAt(n2)) {
                this.getChildAt(n2).refreshEditorTree();
            }
            ++n2;
        }
        if (bl) {
            this.refreshEditor();
        }
    }

    public String toString() {
        return this.getName();
    }
}

