/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.customizer.AxesEditor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AxisValueLabelsEditor
extends Chart3dPropertyEditor
implements ActionListener,
ListDataListener {
    private static final String nameKey = "Value Labels";
    private boolean refreshing = false;
    private Container content;
    private JList valueLabelsList;
    private JButton addButton;
    private JButton insertButton;
    private JButton editButton;
    private JButton removeButton;
    private ValueLabelsModel valueLabelsModel;

    public AxisValueLabelsEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Object object = actionEvent.getSource();
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            int n2 = this.valueLabelsList.getSelectedIndex();
            if (object == this.addButton || object == this.insertButton) {
                JCValueLabel jCValueLabel = this.showValueLabelDialog(this.addButton, "Add", null);
                if (jCValueLabel != null) {
                    if (object == this.addButton || n2 == -1) {
                        this.valueLabelsModel.add(jCValueLabel);
                    } else {
                        this.valueLabelsModel.insert(n2, jCValueLabel);
                    }
                }
            } else if (object == this.editButton) {
                if (n2 != -1) {
                    this.showValueLabelDialog(this.removeButton, "Remove", this.valueLabelsModel.getValueLabelAt(n2));
                    this.valueLabelsModel.update(n2);
                }
            } else if (object == this.removeButton && n2 != -1) {
                this.valueLabelsModel.remove(n2);
            }
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.addButton.removeActionListener(this);
            this.addButton = null;
            this.insertButton.removeActionListener(this);
            this.insertButton = null;
            this.editButton.removeActionListener(this);
            this.editButton = null;
            this.removeButton.removeActionListener(this);
            this.removeButton = null;
            this.valueLabelsModel.addListDataListener(this);
            this.valueLabelsList = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Add");
            this.addButton = Chart3dPropertyEditor.createButton(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Insert");
            this.insertButton = Chart3dPropertyEditor.createButton(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Edit");
            this.editButton = Chart3dPropertyEditor.createButton(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Remove");
            this.removeButton = Chart3dPropertyEditor.createButton(string, this);
            this.valueLabelsModel = new ValueLabelsModel();
            this.valueLabelsModel.addListDataListener(this);
            this.valueLabelsList = new JList(this.valueLabelsModel);
            this.valueLabelsList.setPrototypeCellValue("XXXXXXXXXXXXXXXXXXXXXX");
            JScrollPane jScrollPane = new JScrollPane(this.valueLabelsList, 20, 30);
            JPanel jPanel = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel.setLayout(new GridLayout(0, 1, 5, 5));
            jPanel.add(this.addButton);
            jPanel.add(this.insertButton);
            jPanel.add(this.editButton);
            jPanel.add(this.removeButton);
            jPanel.add(Box.createVerticalGlue());
            JPanel jPanel2 = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel2.add((Component)jPanel, "East");
            jPanel2.add(jScrollPane);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel2);
        }
        return this.content;
    }

    public void handleChange() {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            jCAxis.setValueLabels(this.valueLabelsModel.getValueLabels());
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            this.valueLabelsModel.setValueLabels(jCAxis.getValueLabels());
            this.refreshing = false;
        }
    }

    private JCValueLabel showValueLabelDialog(Component component, String string, JCValueLabel jCValueLabel) {
        Double d2;
        String string2 = Chart3dPropertyEditor.getLocalizedString("Value");
        JLabel jLabel = new JLabel(string2);
        string2 = Chart3dPropertyEditor.getLocalizedString("Label");
        JLabel jLabel2 = new JLabel(string2);
        JPanel jPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        JTextField jTextField = new JTextField(10);
        JTextField jTextField2 = new JTextField(10);
        if (jCValueLabel != null) {
            jTextField.setText(String.valueOf(jCValueLabel.getValue()));
            jTextField2.setText(jCValueLabel.getLabel());
        }
        JPanel jPanel2 = new JPanel(new GridLayout(2, 0, 5, 5));
        jPanel2.add(jTextField);
        jPanel2.add(jTextField2);
        JPanel jPanel3 = Chart3dPropertyEditor.createPreferredSizePanel();
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add(jPanel2);
        int n2 = JOptionPane.showOptionDialog(component, jPanel3, Chart3dPropertyEditor.getLocalizedString(string), 2, -1, null, null, null);
        if (n2 == 0 && (d2 = Chart3dPropertyEditor.parseDoubleInput(jTextField)) != null) {
            if (jCValueLabel != null) {
                jCValueLabel.setValue(d2);
                jCValueLabel.setLabel(jTextField2.getText());
                return null;
            }
            return new JCValueLabel(d2, jTextField2.getText());
        }
        return null;
    }

    private static class ValueLabelsModel
    extends AbstractListModel {
        private List valueLabels = new ArrayList();
        private List valueLabelsAsStrings = new ArrayList();

        public void add(JCValueLabel jCValueLabel) {
            this.insert(this.getSize(), jCValueLabel);
        }

        public Object getElementAt(int n2) {
            return this.valueLabelsAsStrings.get(n2);
        }

        public int getSize() {
            return this.valueLabelsAsStrings.size();
        }

        public JCValueLabel getValueLabelAt(int n2) {
            return (JCValueLabel)this.valueLabels.get(n2);
        }

        public JCValueLabel[] getValueLabels() {
            return this.valueLabels.toArray(new JCValueLabel[0]);
        }

        public void insert(int n2, JCValueLabel jCValueLabel) {
            this.valueLabels.add(n2, jCValueLabel);
            this.valueLabelsAsStrings.add(n2, this.toString(jCValueLabel));
            this.fireIntervalAdded(this, n2, n2);
        }

        public void remove(int n2) {
            this.valueLabels.remove(n2);
            this.valueLabelsAsStrings.remove(n2);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public void replace(int n2, JCValueLabel jCValueLabel) {
            this.remove(n2);
            this.insert(n2, jCValueLabel);
        }

        public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
                this.valueLabels.clear();
                this.valueLabelsAsStrings.clear();
            }
            if (jCValueLabelArray == null) {
                return;
            }
            int n2 = 0;
            while (n2 < jCValueLabelArray.length) {
                this.valueLabels.add(jCValueLabelArray[n2]);
                this.valueLabelsAsStrings.add(this.toString(jCValueLabelArray[n2]));
                ++n2;
            }
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        private String toString(JCValueLabel jCValueLabel) {
            return String.valueOf(jCValueLabel.getValue()) + "," + jCValueLabel.getLabel();
        }

        public void update(int n2) {
            this.fireContentsChanged(this, n2, n2);
        }
    }
}

