/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.customizer.AxesEditor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisLimitsEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "Limits";
    private boolean refreshing = false;
    private Container content;
    private JTextField[] intFields;
    private JCheckBox[] isDefaultCheckBoxes;

    public AxisLimitsEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            int n2 = 0;
            while (n2 < 2) {
                this.intFields[n2].removeActionListener(this);
                this.intFields[n2].removeFocusListener(this);
                this.intFields[n2] = null;
                this.isDefaultCheckBoxes[n2].removeActionListener(this);
                this.isDefaultCheckBoxes[n2] = null;
                ++n2;
            }
            this.intFields = null;
            this.isDefaultCheckBoxes = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String[] stringArray = new String[]{"Min", "Max"};
            JLabel[] jLabelArray = new JLabel[2];
            this.intFields = new JTextField[2];
            this.isDefaultCheckBoxes = new JCheckBox[2];
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 5, 5));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 5, 5));
            String string = Chart3dPropertyEditor.getLocalizedString("Default");
            int n2 = 0;
            while (n2 < 2) {
                jLabelArray[n2] = new JLabel(Chart3dPropertyEditor.getLocalizedString(stringArray[n2]));
                jPanel.add(jLabelArray[n2]);
                this.intFields[n2] = Chart3dPropertyEditor.createTextField(7, this, this);
                jPanel2.add(this.intFields[n2]);
                this.isDefaultCheckBoxes[n2] = Chart3dPropertyEditor.createCheckBox(string, this);
                jPanel3.add(this.isDefaultCheckBoxes[n2]);
                ++n2;
            }
            JPanel jPanel4 = Chart3dPropertyEditor.createBorderPanel();
            jPanel4.setBorder(null);
            jPanel4.add((Component)jPanel, "West");
            jPanel4.add(jPanel2);
            jPanel4.add((Component)jPanel3, "East");
            JPanel jPanel5 = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel5.add(jPanel4);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel5);
        }
        return this.content;
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            if (object instanceof JTextField) {
                Double d2 = Chart3dPropertyEditor.parseDoubleInput((JTextField)object);
                if (d2 == null) {
                    this.refreshEditor();
                    return;
                }
                double d3 = d2;
                if (object == this.intFields[0]) {
                    jCAxis.setMin(d3);
                } else {
                    jCAxis.setMax(d3);
                }
                this.refreshEditor();
            } else if (object instanceof JCheckBox) {
                boolean bl = ((JCheckBox)object).isSelected();
                if (object == this.isDefaultCheckBoxes[0]) {
                    jCAxis.setMinIsDefault(bl);
                    this.intFields[0].setEnabled(bl ^ true);
                } else if (object == this.isDefaultCheckBoxes[1]) {
                    jCAxis.setMaxIsDefault(bl);
                    this.intFields[1].setEnabled(bl ^ true);
                }
            }
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            double[] dArray = new double[]{jCAxis.getMin(), jCAxis.getMax()};
            boolean[] blArray = new boolean[]{jCAxis.getMinIsDefault(), jCAxis.getMaxIsDefault()};
            int n2 = 0;
            while (n2 < 2) {
                this.isDefaultCheckBoxes[n2].setSelected(blArray[n2]);
                this.intFields[n2].setEnabled(blArray[n2] ^ true);
                this.intFields[n2].setText(String.valueOf(dArray[n2]));
                ++n2;
            }
            this.refreshing = false;
        }
    }
}

