/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.customizer.AxesEditor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.ComboBoxEntry;
import com.klg.jclass.chart3d.customizer.MutableComboBoxEntry;
import com.klg.jclass.chart3d.customizer.util.JCColorChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisGridStyleEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static String nameKey = "Grid Style";
    private boolean refreshing = false;
    private Container content;
    private JCColorChooser colorChooser;
    private JTextField widthField;
    private JComboBox styleComboBox;
    private JComboBox joinComboBox;
    private JComboBox capComboBox;
    private Object[] styleModel;
    private Object[] joinModel;
    private Object[] capModel;

    public AxisGridStyleEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.colorChooser.removeActionListener(this);
            this.colorChooser = null;
            this.widthField.removeActionListener(this);
            this.widthField.removeFocusListener(this);
            this.widthField = null;
            this.styleComboBox.removeActionListener(this);
            this.styleComboBox = null;
            this.joinComboBox.removeActionListener(this);
            this.joinComboBox = null;
            this.capComboBox.removeActionListener(this);
            this.capComboBox = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Color");
            this.colorChooser = this.getColorChooser();
            this.colorChooser.addActionListener(this);
            this.colorChooser.setAlignmentX(0.0f);
            this.colorChooser.setBorder(BorderFactory.createTitledBorder(string));
            string = Chart3dPropertyEditor.getLocalizedString("Width");
            JLabel jLabel = new JLabel(string);
            this.widthField = Chart3dPropertyEditor.createTextField(8, this, this);
            string = Chart3dPropertyEditor.getLocalizedString("Style");
            JLabel jLabel2 = new JLabel(string);
            this.styleModel = new ComboBoxEntry[]{new ComboBoxEntry(0, Chart3dPropertyEditor.getLocalizedString("None")), new ComboBoxEntry(1, Chart3dPropertyEditor.getLocalizedString("Solid")), new ComboBoxEntry(2, Chart3dPropertyEditor.getLocalizedString("Long Dash")), new ComboBoxEntry(3, Chart3dPropertyEditor.getLocalizedString("Short Dash")), new ComboBoxEntry(4, Chart3dPropertyEditor.getLocalizedString("LSL Dash")), new ComboBoxEntry(5, Chart3dPropertyEditor.getLocalizedString("Dash Dot"))};
            Arrays.sort(this.styleModel);
            this.styleComboBox = Chart3dPropertyEditor.createComboBox(this.styleModel, this);
            string = Chart3dPropertyEditor.getLocalizedString("Join");
            JLabel jLabel3 = new JLabel(string);
            this.joinModel = new ComboBoxEntry[]{new ComboBoxEntry(2, Chart3dPropertyEditor.getLocalizedString("Bevel")), new ComboBoxEntry(0, Chart3dPropertyEditor.getLocalizedString("Miter")), new ComboBoxEntry(1, Chart3dPropertyEditor.getLocalizedString("Round"))};
            Arrays.sort(this.joinModel);
            this.joinComboBox = Chart3dPropertyEditor.createComboBox(this.joinModel, this);
            string = Chart3dPropertyEditor.getLocalizedString("Layout Style");
            JLabel jLabel4 = new JLabel(string);
            this.capModel = new ComboBoxEntry[]{new ComboBoxEntry(0, Chart3dPropertyEditor.getLocalizedString("Butt")), new ComboBoxEntry(1, Chart3dPropertyEditor.getLocalizedString("Round")), new ComboBoxEntry(2, Chart3dPropertyEditor.getLocalizedString("Square"))};
            Arrays.sort(this.capModel);
            this.capComboBox = Chart3dPropertyEditor.createComboBox(this.capModel, this);
            JPanel jPanel = new JPanel(new GridLayout(4, 0, 5, 5));
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(jLabel3);
            jPanel.add(jLabel4);
            JPanel jPanel2 = new JPanel(new GridLayout(4, 0, 5, 5));
            jPanel2.add(this.widthField);
            jPanel2.add(this.styleComboBox);
            jPanel2.add(this.joinComboBox);
            jPanel2.add(this.capComboBox);
            JPanel jPanel3 = Chart3dPropertyEditor.createBorderPanel();
            jPanel3.setAlignmentX(0.0f);
            jPanel3.setBorder(null);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            this.content = Chart3dPropertyEditor.createBorderPanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(this.colorChooser);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(jPanel3);
        }
        return this.content;
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCLineStyle jCLineStyle = axesEditor.getSelectedAxis().getGridLines().getLineStyle();
            if (object == this.colorChooser) {
                jCLineStyle.setColor(this.colorChooser.getColor());
            } else if (object == this.widthField) {
                Integer n2 = Chart3dPropertyEditor.parseIntegerInput(this.widthField);
                if (n2 == null || n2 < 0) {
                    this.refreshEditor();
                    return;
                }
                jCLineStyle.setWidth(n2);
            } else {
                JComboBox jComboBox = (JComboBox)object;
                int n3 = ((ComboBoxEntry)jComboBox.getSelectedItem()).getConstant();
                if (object == this.styleComboBox) {
                    jCLineStyle.setPattern(n3);
                } else if (object == this.joinComboBox) {
                    jCLineStyle.setJoin(n3);
                } else {
                    jCLineStyle.setCap(n3);
                }
            }
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCLineStyle jCLineStyle = axesEditor.getSelectedAxis().getGridLines().getLineStyle();
            this.colorChooser.setColor(jCLineStyle.getColor());
            this.widthField.setText(String.valueOf(jCLineStyle.getWidth()));
            MutableComboBoxEntry mutableComboBoxEntry = new MutableComboBoxEntry();
            mutableComboBoxEntry.setConstant(jCLineStyle.getPattern());
            this.styleComboBox.setSelectedIndex(Arrays.binarySearch(this.styleModel, mutableComboBoxEntry));
            mutableComboBoxEntry.setConstant(jCLineStyle.getJoin());
            this.joinComboBox.setSelectedIndex(Arrays.binarySearch(this.joinModel, mutableComboBoxEntry));
            mutableComboBoxEntry.setConstant(jCLineStyle.getJoin());
            this.joinComboBox.setSelectedIndex(Arrays.binarySearch(this.capModel, mutableComboBoxEntry));
            this.refreshing = false;
        }
    }
}

