/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCGridLines;
import com.klg.jclass.chart3d.customizer.AxesEditor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AxisGridLinesEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private static final String nameKey = "Grid Lines";
    private boolean refreshing = false;
    private Container content;
    private JCheckBox xyCheckBox;
    private JCheckBox xzCheckBox;
    private JCheckBox yzCheckBox;

    public AxisGridLinesEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            Object object = actionEvent.getSource();
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCGridLines jCGridLines = axesEditor.getSelectedAxis().getGridLines();
            int n2 = jCGridLines.getPlaneMask();
            int n3 = 1;
            if (object == this.xzCheckBox) {
                n3 = 2;
            } else if (object == this.yzCheckBox) {
                n3 = 4;
            }
            jCGridLines.setPlaneMask(n2 ^ n3);
        }
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.xyCheckBox.removeActionListener(this);
            this.xyCheckBox = null;
            this.xzCheckBox.removeActionListener(this);
            this.xzCheckBox = null;
            this.yzCheckBox.removeActionListener(this);
            this.yzCheckBox = null;
            this.content = null;
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("XY Plane");
            this.xyCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("XZ Plane");
            this.xzCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("YZ Plane");
            this.yzCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            JPanel jPanel = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel.setLayout(new GridLayout(0, 1, 5, 5));
            jPanel.add(this.xyCheckBox);
            jPanel.add(this.xzCheckBox);
            jPanel.add(this.yzCheckBox);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel);
        }
        return this.content;
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            JCGridLines jCGridLines = jCAxis.getGridLines();
            int n2 = jCGridLines.getPlaneMask();
            this.xyCheckBox.setVisible(true);
            this.xzCheckBox.setVisible(true);
            this.yzCheckBox.setVisible(true);
            if (jCAxis.getAxisId() == 1) {
                this.yzCheckBox.setVisible(false);
            } else if (jCAxis.getAxisId() == 2) {
                this.xzCheckBox.setVisible(false);
            } else {
                this.xyCheckBox.setVisible(false);
            }
            this.xyCheckBox.setSelected((n2 & 1) == 1);
            this.xzCheckBox.setSelected((n2 & 2) == 2);
            this.yzCheckBox.setSelected((n2 & 4) == 4);
            this.refreshing = false;
        }
    }
}

