/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.customizer.AxesEditor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.ComboBoxEntry;
import com.klg.jclass.chart3d.customizer.MutableComboBoxEntry;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisGeneralEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "General";
    private boolean refreshing = false;
    private Container content;
    private JCheckBox isVisibleCheckBox;
    private JTextField originField;
    private JComboBox annotationMethodComboBox;
    private Object[] annotationMethodModel;

    public AxisGeneralEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.isVisibleCheckBox.removeActionListener(this);
            this.isVisibleCheckBox = null;
            this.originField.removeActionListener(this);
            this.originField.removeFocusListener(this);
            this.originField = null;
            this.annotationMethodComboBox.removeActionListener(this);
            this.annotationMethodComboBox = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = Chart3dPropertyEditor.getLocalizedString("Visible");
            this.isVisibleCheckBox = Chart3dPropertyEditor.createCheckBox(string, this);
            string = Chart3dPropertyEditor.getLocalizedString("Anno Method");
            JLabel jLabel = new JLabel(string);
            this.annotationMethodModel = new ComboBoxEntry[]{new ComboBoxEntry(1, Chart3dPropertyEditor.getLocalizedString("Values")), new ComboBoxEntry(2, Chart3dPropertyEditor.getLocalizedString("Data Labels")), new ComboBoxEntry(3, Chart3dPropertyEditor.getLocalizedString("Value Labels"))};
            Arrays.sort(this.annotationMethodModel);
            this.annotationMethodComboBox = Chart3dPropertyEditor.createComboBox(this.annotationMethodModel, this);
            string = Chart3dPropertyEditor.getLocalizedString("Origin");
            JLabel jLabel2 = new JLabel(string);
            this.originField = Chart3dPropertyEditor.createTextField(10, this, this);
            JPanel jPanel = new JPanel(new GridLayout(3, 0, 5, 5));
            jPanel.add(this.isVisibleCheckBox);
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            JPanel jPanel2 = new JPanel(new GridLayout(3, 0, 5, 5));
            jPanel2.add(new JPanel());
            jPanel2.add(this.annotationMethodComboBox);
            jPanel2.add(this.originField);
            JPanel jPanel3 = Chart3dPropertyEditor.createBorderPanel();
            jPanel3.setBorder(null);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            JPanel jPanel4 = Chart3dPropertyEditor.createPreferredSizePanel();
            jPanel4.add(jPanel3);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel4);
        }
        return this.content;
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            if (object == this.isVisibleCheckBox) {
                jCAxis.setShowing(this.isVisibleCheckBox.isSelected());
            } else if (object == this.annotationMethodComboBox) {
                Object object2 = this.annotationMethodComboBox.getSelectedItem();
                int n2 = ((ComboBoxEntry)object2).getConstant();
                jCAxis.setAnnotationMethod(n2);
            } else if (object == this.originField) {
                Double d2 = Chart3dPropertyEditor.parseDoubleInput(this.originField);
                if (d2 == null) {
                    this.refreshEditor();
                } else {
                    jCAxis.setOrigin(d2);
                }
            }
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            this.isVisibleCheckBox.setSelected(jCAxis.isShowing());
            MutableComboBoxEntry mutableComboBoxEntry = new MutableComboBoxEntry();
            mutableComboBoxEntry.setConstant(jCAxis.getAnnotationMethod());
            this.annotationMethodComboBox.setSelectedIndex(Arrays.binarySearch(this.annotationMethodModel, mutableComboBoxEntry));
            if (jCAxis.getAxisId() == 3) {
                this.originField.setEnabled(true);
            } else {
                this.originField.setEnabled(false);
                this.originField.setText(String.valueOf(jCAxis.getOrigin()));
            }
            this.refreshing = false;
        }
    }
}

