/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.customizer.AxesEditor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.util.swing.JCFontChooserPane;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCFontListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisAnnoFontEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener,
JCFontListener {
    private static String nameKey = "Anno Font";
    private boolean refreshing = false;
    private Container content;
    private JCFontChooserPane fontChooser;
    private JTextField cubeSizeField;

    public AxisAnnoFontEditor() {
        super(nameKey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.fontChooser.removeJCFontListener(this);
            this.fontChooser = null;
            this.cubeSizeField.removeActionListener(this);
            this.cubeSizeField.removeFocusListener(this);
            this.cubeSizeField = null;
            this.content = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void fontChanged(JCFontEvent jCFontEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            jCAxis.setAnnoFont(jCFontEvent.getFont());
        }
    }

    public void fontChanging(JCFontEvent jCFontEvent) {
    }

    public Component getEditor() {
        if (this.content == null) {
            this.fontChooser = this.getFontChooser();
            this.fontChooser.addJCFontListener(this);
            this.fontChooser.setAlignmentX(0.0f);
            String string = Chart3dPropertyEditor.getLocalizedString("Font Cube Size");
            JLabel jLabel = new JLabel(string);
            this.cubeSizeField = Chart3dPropertyEditor.createTextField(10, this, this);
            JPanel jPanel = Chart3dPropertyEditor.createBorderPanel();
            jPanel.setBorder(null);
            jPanel.add((Component)jLabel, "West");
            jPanel.add(this.cubeSizeField);
            jPanel.setAlignmentX(0.0f);
            this.content = Chart3dPropertyEditor.createPreferredSizePanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(jPanel);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(this.fontChooser);
        }
        return this.content;
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            if (object == this.cubeSizeField) {
                Integer n2 = Chart3dPropertyEditor.parseIntegerInput(this.cubeSizeField);
                if (n2 == null || n2 < 0 || n2 > 1000) {
                    this.refreshEditor();
                    return;
                }
                jCAxis.setAnnoFontCubeSize(n2);
            }
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            this.fontChooser.setSelectedFont(jCAxis.getAnnoFont());
            this.cubeSizeField.setText(String.valueOf(jCAxis.getAnnoFontCubeSize()));
            this.refreshing = false;
        }
    }
}

