/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.beans;

import com.klg.jclass.chart3d.beans.JCChart3dBeanBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DataSourceEditor
implements PropertyEditor {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean isFile = false;
    protected String target = null;
    protected String xText = null;
    protected String yText = null;
    protected String zText = null;
    protected String fText = null;
    private boolean edited = false;
    private JTextField fileField = new JTextField(30);
    private JTextField xValuesField = new JTextField(30);
    private JTextField yValuesField = new JTextField(30);
    private JTextArea zValuesField = new JTextArea();
    private JCheckBox areaBox;
    private JCheckBox fileBox;

    static /* synthetic */ boolean access$2(DataSourceEditor dataSourceEditor) {
        return dataSourceEditor.isFile;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        if (this.areaBox.isSelected()) {
            this.xText = this.xValuesField.getText();
            this.yText = this.yValuesField.getText();
            this.zText = this.zValuesField.getText();
            this.target = String.valueOf(this.xText) + " \\n";
            this.target = String.valueOf(this.target) + this.yText + " \\n";
            StringTokenizer stringTokenizer = new StringTokenizer(this.zText, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.target = String.valueOf(this.target) + stringTokenizer.nextToken() + "\\n";
            }
        } else {
            this.target = this.fText;
        }
        return this.target;
    }

    public Component getCustomEditor() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fileBox = new JCheckBox(JCChart3dBeanBundle.string("Load data from a file"), this.isFile);
        this.areaBox = new JCheckBox(JCChart3dBeanBundle.string("Edit data, using comma separated values."), this.isFile ^ true);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(5, 1));
        JLabel jLabel = new JLabel(JCChart3dBeanBundle.string("Edit x Values:"));
        JLabel jLabel2 = new JLabel(JCChart3dBeanBundle.string("Edit y Values:"));
        JButton jButton = new JButton("Apply");
        jPanel4.add(jPanel5);
        jPanel5.add(jLabel);
        jPanel5.add(this.xValuesField);
        this.xValuesField.setText(this.xText);
        jPanel5.add(jLabel2);
        jPanel5.add(this.yValuesField);
        this.yValuesField.setText(this.yText);
        this.zValuesField.setText(this.zText);
        JLabel jLabel3 = new JLabel(JCChart3dBeanBundle.string("Edit z Values:"));
        jPanel5.add(jLabel3);
        this.fileBox.setSelected(false);
        this.areaBox.setSelected(true);
        buttonGroup.add(this.fileBox);
        buttonGroup.add(this.areaBox);
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout(1, 4, 4));
        jPanel3.setLayout(new FlowLayout(1, 4, 4));
        jPanel2.add(this.areaBox);
        jPanel2.add(this.fileBox);
        jPanel3.add(new JLabel(String.valueOf(JCChart3dBeanBundle.string("File Location")) + ":"));
        jPanel3.add(this.fileField);
        jPanel3.add(jButton);
        this.zValuesField.setEnabled(this.isFile ^ true);
        this.fileField.setEnabled(this.isFile);
        this.fileField.setText(this.fText);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataSourceEditor.this.fileBox.isSelected()) {
                    DataSourceEditor.this.fText = DataSourceEditor.this.fileField.getText();
                    DataSourceEditor.this.isFile = true;
                } else {
                    DataSourceEditor.this.xText = DataSourceEditor.this.xValuesField.getText();
                    DataSourceEditor.this.yText = DataSourceEditor.this.yValuesField.getText();
                    DataSourceEditor.this.zText = DataSourceEditor.this.zValuesField.getText();
                    DataSourceEditor.this.isFile = false;
                }
                if (DataSourceEditor.this.support != null) {
                    DataSourceEditor.this.support.firePropertyChange("", null, DataSourceEditor.this.getValue());
                }
            }
        });
        this.fileBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && itemEvent.getSource() == DataSourceEditor.this.fileBox) {
                    DataSourceEditor.this.fileField.setEnabled(true);
                    DataSourceEditor.this.xValuesField.setEnabled(false);
                    DataSourceEditor.this.yValuesField.setEnabled(false);
                    DataSourceEditor.this.zValuesField.setEnabled(false);
                    DataSourceEditor.this.isFile = true;
                    DataSourceEditor.this.fText = DataSourceEditor.this.fileField.getText();
                    if (DataSourceEditor.this.support != null) {
                        DataSourceEditor.this.support.firePropertyChange("", null, DataSourceEditor.this.getValue());
                    }
                }
            }
        });
        this.areaBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && itemEvent.getSource() == DataSourceEditor.this.areaBox) {
                    DataSourceEditor.this.fileField.setEnabled(false);
                    DataSourceEditor.this.xValuesField.setEnabled(true);
                    DataSourceEditor.this.yValuesField.setEnabled(true);
                    DataSourceEditor.this.zValuesField.setEnabled(true);
                    DataSourceEditor.this.isFile = false;
                    if (DataSourceEditor.this.support != null) {
                        DataSourceEditor.this.support.firePropertyChange("", null, DataSourceEditor.this.getValue());
                    }
                }
            }
        });
        jPanel4.add(this.zValuesField);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public final String getJavaInitializationString() {
        return new String("\"" + this.getValue() + "\"");
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        if (this.fileBox == null || !this.fileBox.isSelected()) {
            this.target = String.valueOf(this.xText) + " \\\\n";
            this.target = String.valueOf(this.target) + this.yText + " \\\\n";
            StringTokenizer stringTokenizer = new StringTokenizer(this.zText, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.target = String.valueOf(this.target) + stringTokenizer.nextToken() + "\\\\n";
            }
        } else {
            this.target = this.fText;
        }
        return this.target;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChart3dBeanBundle.string("Click to edit...");
        if (string == null) {
            string = new String("");
        }
        graphics.setClip(rectangle);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n2);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) {
        if (!this.edited) {
            if (string != null && !string.equals("") && string.indexOf(", ") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\\n");
                if (stringTokenizer.countTokens() < 2) {
                    this.edited = true;
                    return;
                }
                String string2 = stringTokenizer.nextToken();
                if (string2.indexOf("null") < 0) {
                    this.xText = string2;
                }
                if ((string2 = stringTokenizer.nextToken()).indexOf("null") < 0) {
                    this.yText = string2;
                }
                this.zText = "";
                while (stringTokenizer.hasMoreTokens()) {
                    this.zText = String.valueOf(this.zText) + stringTokenizer.nextToken();
                    this.zText = String.valueOf(this.zText) + "\n";
                }
                this.target = String.valueOf(this.xText) + " \\n";
                this.target = String.valueOf(this.target) + this.yText + " \\n";
                StringTokenizer stringTokenizer2 = new StringTokenizer(this.zText, "\n");
                while (stringTokenizer2.hasMoreTokens()) {
                    this.target = String.valueOf(this.target) + stringTokenizer2.nextToken() + "\\n";
                }
                this.edited = true;
                return;
            }
            if (this.fText == null) {
                this.fText = new String("");
            }
            this.target = this.fText;
            this.edited = true;
        }
        this.xValuesField.setText(this.xText);
        this.yValuesField.setText(this.yText);
        this.zValuesField.setText(this.zText);
        this.fileField.setText(this.fText);
        if (this.support != null) {
            this.support.firePropertyChange("", null, this.getValue());
        }
    }

    public void setValue(Object object) {
        if (!this.edited) {
            if (object != null && !object.equals("") && ((String)object).indexOf(", ") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, "\\n");
                if (stringTokenizer.countTokens() < 2) {
                    this.edited = true;
                    return;
                }
                String string = stringTokenizer.nextToken();
                if (string.indexOf("null") < 0) {
                    this.xText = string;
                }
                if ((string = stringTokenizer.nextToken()).indexOf("null") < 0) {
                    this.yText = string;
                }
                this.zText = "";
                while (stringTokenizer.hasMoreTokens()) {
                    this.zText = String.valueOf(this.zText) + stringTokenizer.nextToken();
                    this.zText = String.valueOf(this.zText) + "\n";
                }
                this.target = String.valueOf(this.xText) + " \\n";
                this.target = String.valueOf(this.target) + this.yText + " \\n";
                StringTokenizer stringTokenizer2 = new StringTokenizer(this.zText, "\n");
                while (stringTokenizer2.hasMoreTokens()) {
                    this.target = String.valueOf(this.target) + stringTokenizer2.nextToken() + "\\n";
                }
                this.edited = true;
                return;
            }
            if (this.fText == null) {
                this.fText = new String("");
            }
            this.target = this.fText;
            this.edited = true;
        }
        this.xValuesField.setText(this.xText);
        this.yValuesField.setText(this.yText);
        this.zValuesField.setText(this.zText);
        this.fileField.setText(this.fText);
        if (this.support != null) {
            this.support.firePropertyChange("", null, this.getValue());
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

