/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCBox;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCView3d;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;

public class Transform
implements Serializable {
    public static final double EDGE_PAD = 8.0;
    public static final int FACE_ON = 0;
    public static final int EDGE_XMAX = 1;
    public static final int EDGE_XMIN = 2;
    public static final int EDGE_YMAX = 4;
    public static final int EDGE_YMIN = 8;
    public static final int EDGE_ZMAX = 16;
    public static final int EDGE_ZMIN = 32;
    public static final int CORNER_XMAX_YMAX = 5;
    public static final int CORNER_XMIN_YMAX = 6;
    public static final int CORNER_XMAX_YMIN = 9;
    public static final int CORNER_XMIN_YMIN = 10;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_90 = 2;
    public static final int ROTATE_180 = 3;
    public static final int ROTATE_270 = 4;
    protected Matrix4d absolute = new Matrix4d();
    protected Matrix4d rotation = new Matrix4d();
    protected Matrix4d perspective = new Matrix4d();
    protected Matrix4d screen = new Matrix4d();
    protected Matrix4d view = new Matrix4d();
    protected Matrix4d textView = new Matrix4d();
    protected Matrix4d iAbsolute = new Matrix4d();
    protected Matrix4d iRotation = new Matrix4d();
    protected Matrix4d iScreen = new Matrix4d();
    protected Point4d eyePosition = null;
    protected JCBox currentViewport = null;
    protected int processingOrder = 0;
    protected JCChart3dArea area = null;
    static final long serialVersionUID = -5542417106751358122L;

    public Transform() {
        this.absolute.setIdentity();
        this.rotation.setIdentity();
        this.perspective.setIdentity();
        this.screen.setIdentity();
        this.view.setIdentity();
        this.textView.setIdentity();
        this.iAbsolute.setIdentity();
        this.iRotation.setIdentity();
        this.iScreen.setIdentity();
    }

    public Transform(JCChart3dArea jCChart3dArea) {
        this();
        this.area = jCChart3dArea;
    }

    public void adjustForUserViewport(JCBox jCBox, double d2, double d3, double d4) {
        jCBox.x += jCBox.width * d3;
        jCBox.y += jCBox.height * d4;
        jCBox.width /= d2;
        jCBox.height /= d2;
    }

    protected void calcProcessingOrder() {
        this.processingOrder = 0;
        JCAxis jCAxis = this.area.getAxis(1);
        JCAxis jCAxis2 = this.area.getAxis(2);
        JCAxis jCAxis3 = this.area.getAxis(3);
        double d2 = jCAxis.getDataportMin() * this.absolute.m00 + this.absolute.m03;
        double d3 = jCAxis.getDataportMax() * this.absolute.m00 + this.absolute.m03;
        double d4 = jCAxis2.getDataportMin() * this.absolute.m11 + this.absolute.m13;
        double d5 = jCAxis2.getDataportMax() * this.absolute.m11 + this.absolute.m13;
        if (this.eyePosition.x >= d3) {
            this.processingOrder |= 1;
        }
        if (this.eyePosition.x <= d2) {
            this.processingOrder |= 2;
        }
        if (this.eyePosition.y >= d5) {
            this.processingOrder |= 4;
        }
        if (this.eyePosition.y <= d4) {
            this.processingOrder |= 8;
        }
        ScreenPoint screenPoint = new ScreenPoint();
        JCChart3dUtil.getScreenPoint(this.area.getChart3d(), jCAxis.getDataportMax(), jCAxis2.getDataportMin(), jCAxis3.getDataportMin(), jCAxis3.getMin(), screenPoint);
        ScreenPoint screenPoint2 = new ScreenPoint();
        JCChart3dUtil.getScreenPoint(this.area.getChart3d(), jCAxis.getDataportMin(), jCAxis2.getDataportMin(), jCAxis3.getDataportMin(), jCAxis3.getMin(), screenPoint2);
        ScreenPoint screenPoint3 = new ScreenPoint();
        JCChart3dUtil.getScreenPoint(this.area.getChart3d(), jCAxis.getDataportMin(), jCAxis2.getDataportMax(), jCAxis3.getDataportMin(), jCAxis3.getMin(), screenPoint3);
        this.processingOrder = JCChart3dUtil.gridBackfacing(screenPoint, screenPoint2, screenPoint3) ? (this.processingOrder |= 0x20) : (this.processingOrder |= 0x10);
    }

    protected void computeAbsoluteMatrix(JCBox jCBox) {
        boolean bl = this.area.getChart3d().isProjection();
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        double d2 = jCPlotCube.getXNormalizedScale();
        double d3 = jCPlotCube.getYNormalizedScale();
        double d4 = jCPlotCube.getZNormalizedScale();
        double d5 = 2.0 * d2 / jCBox.width;
        double d6 = 2.0 * d3 / jCBox.height;
        double d7 = jCBox.depth == 0.0 ? 1.0 : 2.0 * d4 / jCBox.depth;
        double d8 = -d2 - jCBox.x * d5;
        double d9 = -d3 - jCBox.y * d6;
        double d10 = -d4 - jCBox.z * d7;
        this.absolute.setIdentity();
        this.absolute.m00 = d5;
        this.absolute.m11 = d6;
        this.absolute.m22 = bl ? 0.0 : d7;
        this.absolute.m03 = d8;
        this.absolute.m13 = d9;
        this.absolute.m23 = bl ? 0.0 : d10;
        this.iAbsolute.setIdentity();
        this.iAbsolute.m00 = 1.0 / d5;
        this.iAbsolute.m11 = 1.0 / d6;
        this.iAbsolute.m22 = bl ? 0.0 : 1.0 / d7;
        this.iAbsolute.m03 = -d8 / d5;
        this.iAbsolute.m13 = -d9 / d6;
        this.iAbsolute.m23 = bl ? 0.0 : -d10 / d7;
    }

    public Point4d computeEyePosition() {
        Point4d point4d = new Point4d(0.0, 0.0, 2.0 * this.area.getView3d().getPerspective(), 1.0);
        Transform.transformPoint(this.iRotation, point4d);
        return point4d;
    }

    protected void computePerspectiveMatrix() {
        this.perspective.setIdentity();
        if (!this.area.getChart3d().isProjection()) {
            this.perspective.m32 = -1.0 / (2.0 * this.area.getView3d().getPerspective());
        }
    }

    public void computeRotationMatrix() {
        boolean bl = this.area.getChart3d().isProjection();
        JCView3d jCView3d = this.area.getView3d();
        Matrix4d matrix4d = new Matrix4d();
        this.rotation.setIdentity();
        if (!bl) {
            Transform.rotateMatrix(this.rotation, -90.0, 1, true);
            Transform.rotateMatrix(this.rotation, jCView3d.getXRotation(), 1, false);
            Transform.rotateMatrix(this.rotation, jCView3d.getYRotation(), 2, false);
            Transform.rotateMatrix(this.rotation, jCView3d.getZRotation(), 3, false);
        }
        this.iRotation.setIdentity();
        if (!bl) {
            Transform.rotateMatrix(this.iRotation, -jCView3d.getZRotation(), 3, false);
            Transform.rotateMatrix(this.iRotation, -jCView3d.getYRotation(), 2, false);
            Transform.rotateMatrix(this.iRotation, -jCView3d.getXRotation(), 1, false);
            Transform.rotateMatrix(this.iRotation, 90.0, 1, true);
        }
    }

    protected void computeScreenMatrix() {
        double d2;
        double d3;
        double d4;
        JCBox jCBox = new JCBox(this.currentViewport.x, this.currentViewport.y, this.currentViewport.width, this.currentViewport.height);
        JCViewport jCViewport = this.area.getViewport();
        this.adjustForUserViewport(jCBox, jCViewport.getScale(), jCViewport.getHorizontalShift(), jCViewport.getVerticalShift());
        this.screen.setIdentity();
        this.iScreen.setIdentity();
        if (this.area == null) {
            return;
        }
        Rectangle rectangle = this.area.getDrawingArea();
        double d5 = rectangle.getWidth();
        if (d5 / jCBox.width * jCBox.height < (d4 = rectangle.getHeight())) {
            d3 = d5;
            d2 = jCBox.width;
        } else {
            d3 = d4;
            d2 = jCBox.height;
        }
        double d6 = d3 <= 8.0 ? d3 / d2 : (d3 - 8.0) / d2;
        double d7 = -d6;
        double d8 = rectangle.getX() - jCBox.x * d6 + (d5 - jCBox.width * d6) / 2.0;
        double d9 = rectangle.getY() - jCBox.y * d7 + (d4 - jCBox.height * d7) / 2.0;
        this.screen.m00 = d6;
        this.screen.m11 = d7;
        this.screen.m03 = d8;
        this.screen.m13 = d9;
        this.iScreen.m00 = 1.0 / d6;
        this.iScreen.m11 = 1.0 / d7;
        this.iScreen.m03 = -d8 / d6;
        this.iScreen.m13 = -d9 / d7;
    }

    public void computeTransformations(Graphics graphics) {
        this.computeRotationMatrix();
        this.eyePosition = this.computeEyePosition();
        this.computePerspectiveMatrix();
        JCBox jCBox = new JCBox();
        this.currentViewport = new JCBox();
        this.area.getAnno().calcAnno(graphics, this.currentViewport, jCBox);
        this.computeScreenMatrix();
        this.computeAbsoluteMatrix(jCBox);
        this.computeViewMatrix();
    }

    protected void computeViewMatrix() {
        this.textView.mul(this.screen, this.perspective);
        this.textView.mul(this.rotation);
        this.view.mul(this.textView, this.absolute);
    }

    public Matrix4d getAbsolute() {
        return this.absolute;
    }

    public JCChart3dArea getChart3dArea() {
        return this.area;
    }

    public JCBox getCurrentViewport() {
        return this.currentViewport;
    }

    public Point4d getEyePosition() {
        if (this.eyePosition == null) {
            return new Point4d();
        }
        return this.eyePosition;
    }

    public Matrix4d getInverseAbsolute() {
        return this.iAbsolute;
    }

    public Matrix4d getInverseRotation() {
        return this.iRotation;
    }

    public Matrix4d getInverseScreen() {
        return this.iScreen;
    }

    public Matrix4d getPerspective() {
        return this.perspective;
    }

    protected int getProcessingOrder() {
        return this.processingOrder;
    }

    public Matrix4d getRotation() {
        return this.rotation;
    }

    public Matrix4d getScreen() {
        return this.screen;
    }

    public Matrix4d getTextView() {
        return this.textView;
    }

    public Matrix4d getView() {
        return this.view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateMatrix(Matrix4d matrix4d, double d2, int n2, boolean bl) {
        JCDebug.println("transform", "transform.rotateMatrix: Angle:" + d2 + " Axis:" + n2);
        if (d2 == 0.0) {
            return;
        }
        double d3 = JCNumberUtil.degToRad(d2);
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        if (bl) {
            switch (n2) {
                case 1: {
                    double d6 = matrix4d.m01;
                    matrix4d.m01 = d5 * d6 + d4 * matrix4d.m02;
                    matrix4d.m02 = d5 * matrix4d.m02 - d4 * d6;
                    d6 = matrix4d.m11;
                    matrix4d.m11 = d5 * d6 + d4 * matrix4d.m12;
                    matrix4d.m12 = d5 * matrix4d.m12 - d4 * d6;
                    d6 = matrix4d.m21;
                    matrix4d.m21 = d5 * d6 + d4 * matrix4d.m22;
                    matrix4d.m22 = d5 * matrix4d.m22 - d4 * d6;
                    d6 = matrix4d.m31;
                    matrix4d.m31 = d5 * d6 + d4 * matrix4d.m32;
                    matrix4d.m32 = d5 * matrix4d.m32 - d4 * d6;
                    return;
                }
                case 2: {
                    double d7 = matrix4d.m00;
                    matrix4d.m00 = d5 * d7 - d4 * matrix4d.m02;
                    matrix4d.m02 = d5 * matrix4d.m02 + d4 * d7;
                    d7 = matrix4d.m10;
                    matrix4d.m10 = d5 * d7 - d4 * matrix4d.m12;
                    matrix4d.m12 = d5 * matrix4d.m12 + d4 * d7;
                    d7 = matrix4d.m20;
                    matrix4d.m20 = d5 * d7 - d4 * matrix4d.m22;
                    matrix4d.m22 = d5 * matrix4d.m22 + d4 * d7;
                    d7 = matrix4d.m30;
                    matrix4d.m30 = d5 * d7 - d4 * matrix4d.m32;
                    matrix4d.m32 = d5 * matrix4d.m32 + d4 * d7;
                    return;
                }
                case 3: {
                    double d8 = matrix4d.m00;
                    matrix4d.m00 = d5 * d8 + d4 * matrix4d.m01;
                    matrix4d.m01 = d5 * matrix4d.m01 - d4 * d8;
                    d8 = matrix4d.m10;
                    matrix4d.m10 = d5 * d8 + d4 * matrix4d.m11;
                    matrix4d.m11 = d5 * matrix4d.m11 - d4 * d8;
                    d8 = matrix4d.m20;
                    matrix4d.m20 = d5 * d8 + d4 * matrix4d.m21;
                    matrix4d.m21 = d5 * matrix4d.m21 - d4 * d8;
                    d8 = matrix4d.m30;
                    matrix4d.m30 = d5 * d8 + d4 * matrix4d.m31;
                    matrix4d.m31 = d5 * matrix4d.m31 - d4 * d8;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        Matrix4d matrix4d2 = new Matrix4d();
        switch (n2) {
            case 1: {
                matrix4d2.rotX(d3);
                break;
            }
            case 2: {
                matrix4d2.rotY(d3);
                break;
            }
            case 3: {
                matrix4d2.rotZ(d3);
                break;
            }
        }
        matrix4d.mul(matrix4d2);
    }

    public static void rotateMatrix(Matrix4d matrix4d, int n2, int n3) {
        JCDebug.println("transform", "transform.rotateMatrix: Rotate type:" + n2 + " Axis:" + n3);
        if (n2 == 1) {
            return;
        }
        switch (n3) {
            case 1: {
                if (n2 == 2) {
                    double d2 = -matrix4d.m01;
                    matrix4d.m01 = matrix4d.m02;
                    matrix4d.m02 = d2;
                    d2 = -matrix4d.m11;
                    matrix4d.m11 = matrix4d.m12;
                    matrix4d.m12 = d2;
                    d2 = -matrix4d.m21;
                    matrix4d.m21 = matrix4d.m22;
                    matrix4d.m22 = d2;
                    d2 = -matrix4d.m31;
                    matrix4d.m31 = matrix4d.m32;
                    matrix4d.m32 = d2;
                    break;
                }
                if (n2 == 4) {
                    double d3 = matrix4d.m01;
                    matrix4d.m01 = -matrix4d.m02;
                    matrix4d.m02 = d3;
                    d3 = matrix4d.m11;
                    matrix4d.m11 = -matrix4d.m12;
                    matrix4d.m12 = d3;
                    d3 = matrix4d.m21;
                    matrix4d.m21 = -matrix4d.m22;
                    matrix4d.m22 = d3;
                    d3 = matrix4d.m31;
                    matrix4d.m31 = -matrix4d.m32;
                    matrix4d.m32 = d3;
                    break;
                }
                if (n2 != 3) break;
                matrix4d.m01 = -matrix4d.m01;
                matrix4d.m02 = -matrix4d.m02;
                matrix4d.m11 = -matrix4d.m11;
                matrix4d.m12 = -matrix4d.m12;
                matrix4d.m21 = -matrix4d.m21;
                matrix4d.m22 = -matrix4d.m22;
                matrix4d.m31 = -matrix4d.m31;
                matrix4d.m32 = -matrix4d.m32;
                break;
            }
            case 2: {
                if (n2 == 2) {
                    double d4 = matrix4d.m00;
                    matrix4d.m00 = -matrix4d.m02;
                    matrix4d.m02 = d4;
                    d4 = matrix4d.m10;
                    matrix4d.m10 = -matrix4d.m12;
                    matrix4d.m12 = d4;
                    d4 = matrix4d.m20;
                    matrix4d.m20 = -matrix4d.m22;
                    matrix4d.m22 = d4;
                    d4 = matrix4d.m30;
                    matrix4d.m30 = -matrix4d.m32;
                    matrix4d.m32 = d4;
                    break;
                }
                if (n2 == 3) {
                    matrix4d.m00 = -matrix4d.m00;
                    matrix4d.m02 = -matrix4d.m02;
                    matrix4d.m10 = -matrix4d.m10;
                    matrix4d.m12 = -matrix4d.m12;
                    matrix4d.m20 = -matrix4d.m20;
                    matrix4d.m22 = -matrix4d.m22;
                    matrix4d.m30 = -matrix4d.m30;
                    matrix4d.m32 = -matrix4d.m32;
                    break;
                }
                if (n2 != 4) break;
                double d5 = -matrix4d.m00;
                matrix4d.m00 = matrix4d.m02;
                matrix4d.m02 = d5;
                d5 = -matrix4d.m10;
                matrix4d.m10 = matrix4d.m12;
                matrix4d.m12 = d5;
                d5 = -matrix4d.m20;
                matrix4d.m20 = matrix4d.m22;
                matrix4d.m22 = d5;
                d5 = -matrix4d.m30;
                matrix4d.m30 = matrix4d.m32;
                matrix4d.m32 = d5;
                break;
            }
            case 3: {
                if (n2 == 2) {
                    double d6 = -matrix4d.m00;
                    matrix4d.m00 = matrix4d.m01;
                    matrix4d.m01 = d6;
                    d6 = -matrix4d.m10;
                    matrix4d.m10 = matrix4d.m11;
                    matrix4d.m11 = d6;
                    d6 = -matrix4d.m20;
                    matrix4d.m20 = matrix4d.m21;
                    matrix4d.m21 = d6;
                    d6 = -matrix4d.m30;
                    matrix4d.m30 = matrix4d.m31;
                    matrix4d.m31 = d6;
                    break;
                }
                if (n2 == 3) {
                    matrix4d.m00 = -matrix4d.m00;
                    matrix4d.m01 = -matrix4d.m01;
                    matrix4d.m10 = -matrix4d.m10;
                    matrix4d.m11 = -matrix4d.m11;
                    matrix4d.m20 = -matrix4d.m20;
                    matrix4d.m21 = -matrix4d.m21;
                    matrix4d.m30 = -matrix4d.m30;
                    matrix4d.m31 = -matrix4d.m31;
                    break;
                }
                if (n2 != 4) break;
                double d7 = matrix4d.m00;
                matrix4d.m00 = -matrix4d.m01;
                matrix4d.m01 = d7;
                d7 = matrix4d.m10;
                matrix4d.m10 = -matrix4d.m11;
                matrix4d.m11 = d7;
                d7 = matrix4d.m20;
                matrix4d.m20 = -matrix4d.m21;
                matrix4d.m21 = d7;
                d7 = matrix4d.m30;
                matrix4d.m30 = -matrix4d.m31;
                matrix4d.m31 = d7;
                break;
            }
        }
    }

    public static void scaleMatrix(Matrix4d matrix4d, double d2, double d3, double d4) {
        JCDebug.println("transform", "transform.scaleMatrix: X:" + d2 + " Y:" + d3 + " Z:" + d4);
        if (d2 == 1.0 && d3 == 1.0 || d2 == 1.0 && d4 == 1.0 || d3 == 1.0 && d4 == 1.0) {
            if (d3 == -1.0) {
                matrix4d.m01 = -matrix4d.m01;
                matrix4d.m11 = -matrix4d.m11;
                matrix4d.m21 = -matrix4d.m21;
                matrix4d.m31 = -matrix4d.m31;
            } else if (d3 != 1.0) {
                matrix4d.m01 *= d3;
                matrix4d.m11 *= d3;
                matrix4d.m21 *= d3;
                matrix4d.m31 *= d3;
            } else if (d2 != 1.0) {
                matrix4d.m00 *= d2;
                matrix4d.m10 *= d2;
                matrix4d.m20 *= d2;
                matrix4d.m30 *= d2;
            } else if (d4 != 1.0) {
                matrix4d.m02 *= d4;
                matrix4d.m12 *= d4;
                matrix4d.m22 *= d4;
                matrix4d.m32 *= d4;
            }
        } else {
            Matrix4d matrix4d2 = new Matrix4d();
            matrix4d2.setIdentity();
            matrix4d2.m00 = d2;
            matrix4d2.m11 = d3;
            matrix4d2.m22 = d4;
            matrix4d.mul(matrix4d2);
        }
    }

    public void setChart3dArea(JCChart3dArea jCChart3dArea) {
        this.area = jCChart3dArea;
    }

    public static void transformPoint(Matrix4d matrix4d, Point4d point4d) {
        matrix4d.transform(point4d);
        point4d.project(point4d);
    }

    public static void translateMatrix(Matrix4d matrix4d, double d2, double d3, double d4) {
        JCDebug.println("transform", "transform.translateMatrix: X:" + d2 + " Y:" + d3 + " Z:" + d4);
        if (d2 != 0.0) {
            matrix4d.m03 += matrix4d.m00 * d2;
            matrix4d.m13 += matrix4d.m10 * d2;
            matrix4d.m23 += matrix4d.m20 * d2;
            matrix4d.m33 += matrix4d.m30 * d2;
        }
        if (d3 != 0.0) {
            matrix4d.m03 += matrix4d.m01 * d3;
            matrix4d.m13 += matrix4d.m11 * d3;
            matrix4d.m23 += matrix4d.m21 * d3;
            matrix4d.m33 += matrix4d.m31 * d3;
        }
        if (d4 != 0.0) {
            matrix4d.m03 += matrix4d.m02 * d4;
            matrix4d.m13 += matrix4d.m12 * d4;
            matrix4d.m23 += matrix4d.m22 * d4;
            matrix4d.m33 += matrix4d.m32 * d4;
        }
    }
}

