/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.DrawFacet;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.FacetAbstract;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.GridRegion;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.util.JCDebug;
import java.awt.Graphics;
import java.awt.Rectangle;

public class SurfaceFacet
extends FacetAbstract {
    public static final int FP_0_CODE = 129;
    public static final int FP_1_CODE = 18;
    public static final int FP_2_CODE = 36;
    public static final int FP_3_CODE = 72;
    public static final int FP_H_CODE = 15;
    public static final int FP_A_CODE = 17;
    public static final int FP_B_CODE = 34;
    public static final int FP_C_CODE = 68;
    public static final int FP_D_CODE = 136;
    public static final int FP_S_CODE = 240;
    protected DrawFacet drawFacet = null;

    SurfaceFacet() {
    }

    SurfaceFacet(DrawGrid drawGrid, DrawFacet drawFacet) {
        super(drawGrid);
        this.drawFacet = drawFacet;
    }

    protected void drawBottomOfSkirt(int n2, int n3, int n4, int n5) {
        ScreenPoint[] screenPointArray = new ScreenPoint[4];
        ScreenPoint[][] screenPointArray2 = this.data.getScreenPoints();
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        if (this.drawFacet == null) {
            return;
        }
        int n6 = n2;
        while (n6 <= n3) {
            int n7 = n4;
            while (n7 <= n5) {
                if (!JCChart3dUtil.holeInFacet(this.data, n6, n7)) {
                    screenPointArray[0] = this.makeZMinPoint(n6, n7);
                    screenPointArray[1] = this.makeZMinPoint(n6, n7 + 1);
                    screenPointArray[2] = this.makeZMinPoint(n6 + 1, n7 + 1);
                    screenPointArray[3] = this.makeZMinPoint(n6 + 1, n7);
                    this.fillPointArrays(screenPointArray, screenPointArray.length);
                    JCElevation jCElevation = chart3dDataView.getElevation();
                    Graphics graphics = this.drawFacet.getGC();
                    if (jCElevation.isShaded()) {
                        graphics.setColor(jCElevation.getShadedBottomColor());
                        graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                    }
                    if (jCElevation.isMeshed()) {
                        if (!jCElevation.isShaded() && !jCElevation.isTransparent()) {
                            graphics.setColor(jCChart3dArea.getPlotCube().getDrawBackground());
                            graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                        }
                        JCSurface jCSurface = jCChart3dArea.getSurface();
                        boolean[] blArray = jCSurface.getXMesh();
                        boolean[] blArray2 = jCSurface.getYMesh();
                        boolean bl = jCSurface.isXMeshShowing() && blArray[n7];
                        boolean bl2 = jCSurface.isXMeshShowing() && blArray[n7 + 1];
                        boolean bl3 = jCSurface.isYMeshShowing() && blArray2[n6];
                        boolean bl4 = jCSurface.isYMeshShowing() && blArray2[n6 + 1];
                        graphics.setColor(jCElevation.getMeshBottomColor());
                        if (bl && bl2 && bl3 && bl4) {
                            graphics.drawPolygon(this.xPoints, this.yPoints, 4);
                        } else {
                            if (bl) {
                                graphics.drawLine(screenPointArray[3].getXPixel(), screenPointArray[3].getYPixel(), screenPointArray[0].getXPixel(), screenPointArray[0].getYPixel());
                            }
                            if (bl2) {
                                graphics.drawLine(screenPointArray[1].getXPixel(), screenPointArray[1].getYPixel(), screenPointArray[2].getXPixel(), screenPointArray[2].getYPixel());
                            }
                            if (bl3) {
                                graphics.drawLine(screenPointArray[0].getXPixel(), screenPointArray[0].getYPixel(), screenPointArray[1].getXPixel(), screenPointArray[1].getYPixel());
                            }
                            if (bl4) {
                                graphics.drawLine(screenPointArray[2].getXPixel(), screenPointArray[2].getYPixel(), screenPointArray[3].getXPixel(), screenPointArray[3].getYPixel());
                            }
                        }
                    }
                }
                ++n7;
            }
            ++n6;
        }
    }

    protected void drawCornerRegionFacet(ScreenPoint[] screenPointArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.drawFacet == null) {
            return;
        }
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        boolean[] blArray = jCSurface.getXMesh();
        boolean[] blArray2 = jCSurface.getYMesh();
        if (n6 != 0) {
            return;
        }
        if (chart3dDataView.getContour().isZoned()) {
            this.drawFacetFromScreenPoints(screenPointArray, n6, n7, n8);
            return;
        }
        if (this.testSelfOcclude(screenPointArray[n2].getXPixel(), screenPointArray[n2].getYPixel(), screenPointArray[n3].getXPixel(), screenPointArray[n3].getYPixel(), screenPointArray[n4].getXPixel(), screenPointArray[n4].getYPixel(), screenPointArray[n5].getXPixel(), screenPointArray[n5].getYPixel()) || this.testSelfOcclude(screenPointArray[n3].getXPixel(), screenPointArray[n3].getYPixel(), screenPointArray[n4].getXPixel(), screenPointArray[n4].getYPixel(), screenPointArray[n5].getXPixel(), screenPointArray[n5].getYPixel(), screenPointArray[n2].getXPixel(), screenPointArray[n2].getYPixel())) {
            ScreenPoint[] screenPointArray2 = new ScreenPoint[]{this.quadCenter(n7, n8), screenPointArray[n2], screenPointArray[n3]};
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n2) != 0 ? blArray[n8 + this.isOdd(n3 / 2)] : blArray2[n7 + this.isOdd(n2 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
            screenPointArray2[1] = screenPointArray[n3];
            screenPointArray2[2] = screenPointArray[n4];
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n3) != 0 ? blArray[n8 + this.isOdd(n4 / 2)] : blArray2[n7 + this.isOdd(n3 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
            screenPointArray2[1] = screenPointArray[n4];
            screenPointArray2[2] = screenPointArray[n5];
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n4) != 0 ? blArray[n8 + this.isOdd(n5 / 2)] : blArray2[n7 + this.isOdd(n4 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
            screenPointArray2[1] = screenPointArray[n5];
            screenPointArray2[2] = screenPointArray[n2];
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n5) != 0 ? blArray[n8 + this.isOdd(n2 / 2)] : blArray2[n7 + this.isOdd(n5 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
        } else {
            this.drawFacetFromScreenPoints(screenPointArray, n6, n7, n8);
        }
    }

    protected void drawEdgeRegionFacet(ScreenPoint[] screenPointArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.drawFacet == null) {
            return;
        }
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        boolean[] blArray = jCSurface.getXMesh();
        boolean[] blArray2 = jCSurface.getYMesh();
        if (n6 != 0) {
            return;
        }
        if (chart3dDataView.getContour().isZoned()) {
            this.drawFacetFromScreenPoints(screenPointArray, n6, n7, n8);
            return;
        }
        if (this.testSelfOcclude(screenPointArray[n3].getXPixel(), screenPointArray[n3].getYPixel(), screenPointArray[n4].getXPixel(), screenPointArray[n4].getYPixel(), screenPointArray[n5].getXPixel(), screenPointArray[n5].getYPixel(), screenPointArray[n2].getXPixel(), screenPointArray[n2].getYPixel())) {
            ScreenPoint[] screenPointArray2 = new ScreenPoint[]{this.quadCenter(n7, n8), screenPointArray[n3], screenPointArray[n4]};
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n3) != 0 ? blArray[n8 + this.isOdd(n4 / 2)] : blArray2[n7 + this.isOdd(n3 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
            screenPointArray2[1] = screenPointArray[n2];
            screenPointArray2[2] = screenPointArray[n3];
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n2) != 0 ? blArray[n8 + this.isOdd(n3 / 2)] : blArray2[n7 + this.isOdd(n2 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
            screenPointArray2[1] = screenPointArray[n4];
            screenPointArray2[2] = screenPointArray[n5];
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n4) != 0 ? blArray[n8 + this.isOdd(n5 / 2)] : blArray2[n7 + this.isOdd(n4 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
            screenPointArray2[1] = screenPointArray[n5];
            screenPointArray2[2] = screenPointArray[n2];
            this.drawFacet.setDrawMeshLine(chart3dDataView.getElevation().isMeshed() && (this.isOdd(n5) != 0 ? blArray[n8 + this.isOdd(n2 / 2)] : blArray2[n7 + this.isOdd(n5 / 2)]));
            this.drawFacetFromScreenPoints(screenPointArray2, n6, n7, n8);
        } else {
            this.drawFacetFromScreenPoints(screenPointArray, n6, n7, n8);
        }
    }

    protected void drawFacetFromScreenPoints(ScreenPoint[] screenPointArray, int n2, int n3, int n4) {
        if (this.drawFacet == null) {
            return;
        }
        this.fillPointArrays(screenPointArray, screenPointArray.length);
        this.drawFacet.draw(this.xPoints, this.yPoints, screenPointArray.length, n2, n3, n4);
    }

    protected void drawSolid(GridRegion gridRegion) {
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        if (!jCChart3dArea.getSurface().isSolid() || chart3dDataView.getChartType() != 0) {
            return;
        }
        int n2 = gridRegion.getXBegin();
        int n3 = gridRegion.getXEnd();
        int n4 = gridRegion.getYBegin();
        int n5 = gridRegion.getYEnd();
        switch (jCChart3dArea.getTransform().getProcessingOrder() & 0xF) {
            case 1: {
                this.drawYSkirt(n3 + 1, n3, n4, n5 + 1);
                break;
            }
            case 2: {
                this.drawYSkirt(n2, n2 + 1, n4, n5 + 1);
                break;
            }
            case 4: {
                this.drawXSkirt(n5 + 1, n5, n2, n3 + 1);
                break;
            }
            case 8: {
                this.drawXSkirt(n4, n4 + 1, n2, n3 + 1);
                break;
            }
            case 5: {
                this.drawXSkirt(n5 + 1, n5, n2, n3 + 1);
                this.drawYSkirt(n3 + 1, n3, n4, n5 + 1);
                break;
            }
            case 9: {
                this.drawXSkirt(n4, n4 + 1, n2, n3 + 1);
                this.drawYSkirt(n3 + 1, n3, n4, n5 + 1);
                break;
            }
            case 6: {
                this.drawXSkirt(n5 + 1, n5, n2, n3 + 1);
                this.drawYSkirt(n2, n2 + 1, n4, n5 + 1);
                break;
            }
            case 10: {
                this.drawXSkirt(n4, n4 + 1, n2, n3 + 1);
                this.drawYSkirt(n2, n2 + 1, n4, n5 + 1);
                break;
            }
        }
        if ((jCChart3dArea.getTransform().getProcessingOrder() & 0x20) != 0) {
            this.drawBottomOfSkirt(n2, n3, n4, n5);
        }
    }

    protected void drawXSkirt(int n2, int n3, int n4, int n5) {
        int n6;
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCElevation jCElevation = chart3dDataView.getElevation();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        if (this.drawFacet == null) {
            return;
        }
        Graphics graphics = this.drawFacet.getGC();
        if (jCElevation.isShaded() || jCElevation.isMeshed()) {
            ScreenPoint[] screenPointArray2 = new ScreenPoint[n5 - n4 + 3];
            boolean bl = true;
            n6 = n4 - 1;
            int n7 = n4 - 1;
            int n8 = 0;
            int n9 = n4;
            while (n9 <= n5) {
                if (bl) {
                    if (n9 != n5 && !screenPointArray[n9][n2].isHoleValue() && !screenPointArray[n9][n3].isHoleValue()) {
                        n6 = n9;
                        screenPointArray2[n8++] = this.makeZMinPoint(n9, n2);
                        screenPointArray2[n8++] = screenPointArray[n9][n2];
                        bl = false;
                    }
                } else if (n9 == n5 || screenPointArray[n9][n2].isHoleValue() || screenPointArray[n9][n3].isHoleValue()) {
                    n7 = screenPointArray[n9][n2].isHoleValue() || screenPointArray[n9][n3].isHoleValue() ? n9 - 1 : n9;
                    if (n6 != n7) {
                        screenPointArray2[n8++] = screenPointArray[n7][n2];
                        screenPointArray2[n8++] = this.makeZMinPoint(n7, n2);
                        this.fillPointArrays(screenPointArray2, n8);
                        if (jCElevation.isShaded()) {
                            graphics.setColor(jCElevation.getShadedBottomColor());
                            graphics.fillPolygon(this.xPoints, this.yPoints, n8);
                        } else if (jCElevation.isMeshed() && !jCElevation.isTransparent()) {
                            this.drawFacet.polyErase(this.xPoints, this.yPoints, n8, 0);
                        }
                        graphics.setColor(jCElevation.getMeshBottomColor());
                        graphics.drawPolygon(this.xPoints, this.yPoints, n8);
                    }
                    n8 = 0;
                    bl = true;
                } else {
                    screenPointArray2[n8++] = screenPointArray[n9][n2];
                }
                ++n9;
            }
        }
        if (jCElevation.isMeshed()) {
            JCSurface jCSurface = jCChart3dArea.getSurface();
            n6 = n4;
            while (n6 <= n5) {
                boolean[] blArray = jCSurface.getYMesh();
                if (jCSurface.isYMeshShowing() && blArray[n6] && !screenPointArray[n6][n2].isHoleValue() && !screenPointArray[n6][n3].isHoleValue() && (n6 > n4 && !screenPointArray[n6 - 1][n2].isHoleValue() || n6 < n5 && !screenPointArray[n6 + 1][n2].isHoleValue())) {
                    ScreenPoint screenPoint = this.makeZMinPoint(n6, n2);
                    ScreenPoint screenPoint2 = screenPointArray[n6][n2];
                    graphics.setColor(jCElevation.getMeshBottomColor());
                    graphics.drawLine(screenPoint.getXPixel(), screenPoint.getYPixel(), screenPoint2.getXPixel(), screenPoint2.getYPixel());
                }
                ++n6;
            }
        }
    }

    protected void drawYSkirt(int n2, int n3, int n4, int n5) {
        int n6;
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCElevation jCElevation = chart3dDataView.getElevation();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        if (this.drawFacet == null) {
            return;
        }
        Graphics graphics = this.drawFacet.getGC();
        if (jCElevation.isShaded() || jCElevation.isMeshed()) {
            ScreenPoint[] screenPointArray2 = new ScreenPoint[n5 - n4 + 3];
            boolean bl = true;
            n6 = n4 - 1;
            int n7 = n4 - 1;
            int n8 = 0;
            int n9 = n4;
            while (n9 <= n5) {
                if (bl) {
                    if (n9 != n5 && !screenPointArray[n2][n9].isHoleValue() && !screenPointArray[n3][n9].isHoleValue()) {
                        n6 = n9;
                        screenPointArray2[n8++] = this.makeZMinPoint(n2, n9);
                        screenPointArray2[n8++] = screenPointArray[n2][n9];
                        bl = false;
                    }
                } else if (n9 == n5 || screenPointArray[n2][n9].isHoleValue() || screenPointArray[n3][n9].isHoleValue()) {
                    n7 = screenPointArray[n2][n9].isHoleValue() || screenPointArray[n3][n9].isHoleValue() ? n9 - 1 : n9;
                    if (n6 != n7) {
                        screenPointArray2[n8++] = screenPointArray[n2][n7];
                        screenPointArray2[n8++] = this.makeZMinPoint(n2, n7);
                        this.fillPointArrays(screenPointArray2, n8);
                        if (jCElevation.isShaded()) {
                            graphics.setColor(jCElevation.getShadedBottomColor());
                            graphics.fillPolygon(this.xPoints, this.yPoints, n8);
                        } else if (jCElevation.isMeshed() && !jCElevation.isTransparent()) {
                            this.drawFacet.polyErase(this.xPoints, this.yPoints, n8, 0);
                        }
                        graphics.setColor(jCElevation.getMeshBottomColor());
                        graphics.drawPolygon(this.xPoints, this.yPoints, n8);
                    }
                    n8 = 0;
                    bl = true;
                } else {
                    screenPointArray2[n8++] = screenPointArray[n2][n9];
                }
                ++n9;
            }
        }
        if (jCElevation.isMeshed()) {
            JCSurface jCSurface = jCChart3dArea.getSurface();
            n6 = n4;
            while (n6 <= n5) {
                boolean[] blArray = jCSurface.getXMesh();
                if (jCSurface.isXMeshShowing() && blArray[n6] && !screenPointArray[n2][n6].isHoleValue() && !screenPointArray[n3][n6].isHoleValue() && (n6 > n4 && !screenPointArray[n2][n6 - 1].isHoleValue() || n6 < n5 && !screenPointArray[n2][n6 + 1].isHoleValue())) {
                    ScreenPoint screenPoint = this.makeZMinPoint(n2, n6);
                    ScreenPoint screenPoint2 = screenPointArray[n2][n6];
                    graphics.setColor(jCElevation.getMeshBottomColor());
                    graphics.drawLine(screenPoint.getXPixel(), screenPoint.getYPixel(), screenPoint2.getXPixel(), screenPoint2.getYPixel());
                }
                ++n6;
            }
        }
    }

    protected void dropSkirt(int n2, int n3, int n4, int n5) {
        ScreenPoint[] screenPointArray = new ScreenPoint[4];
        ScreenPoint[][] screenPointArray2 = this.data.getScreenPoints();
        GridLimits gridLimits = this.data.getGridLimits();
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCElevation jCElevation = chart3dDataView.getElevation();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        if (this.drawFacet == null) {
            return;
        }
        screenPointArray[1] = screenPointArray2[n2][n3];
        screenPointArray[2] = screenPointArray2[n4][n5];
        screenPointArray[0] = this.makeZMinPoint(n2, n3);
        screenPointArray[3] = this.makeZMinPoint(n4, n5);
        this.fillPointArrays(screenPointArray, screenPointArray.length);
        Graphics graphics = this.drawFacet.getGC();
        if (jCElevation.isShaded()) {
            graphics.setColor(jCElevation.getShadedBottomColor());
            graphics.fillPolygon(this.xPoints, this.yPoints, 4);
        } else if (!chart3dDataView.getElevation().isTransparent()) {
            this.drawFacet.polyErase(this.xPoints, this.yPoints, 4, 0);
        }
        graphics.setColor(jCElevation.getMeshBottomColor());
        graphics.drawLine(screenPointArray[0].getXPixel(), screenPointArray[0].getYPixel(), screenPointArray[3].getXPixel(), screenPointArray[3].getYPixel());
        graphics.drawLine(screenPointArray[1].getXPixel(), screenPointArray[1].getYPixel(), screenPointArray[2].getXPixel(), screenPointArray[2].getYPixel());
        boolean bl = false;
        boolean bl2 = false;
        if (jCElevation.isMeshed()) {
            boolean[] blArray;
            if (n2 == n4 && jCSurface.isXMeshShowing()) {
                blArray = jCSurface.getXMesh();
                if (blArray[n3]) {
                    graphics.drawLine(screenPointArray[0].getXPixel(), screenPointArray[0].getYPixel(), screenPointArray[1].getXPixel(), screenPointArray[1].getYPixel());
                    bl2 = true;
                }
                if (blArray[n5]) {
                    graphics.drawLine(screenPointArray[3].getXPixel(), screenPointArray[3].getYPixel(), screenPointArray[2].getXPixel(), screenPointArray[2].getYPixel());
                    bl = true;
                }
            }
            if (n3 == n5 && jCSurface.isYMeshShowing()) {
                blArray = jCSurface.getYMesh();
                if (blArray[n2]) {
                    graphics.drawLine(screenPointArray[0].getXPixel(), screenPointArray[0].getYPixel(), screenPointArray[1].getXPixel(), screenPointArray[1].getYPixel());
                    bl2 = true;
                }
                if (blArray[n4]) {
                    graphics.drawLine(screenPointArray[3].getXPixel(), screenPointArray[3].getYPixel(), screenPointArray[2].getXPixel(), screenPointArray[2].getYPixel());
                    bl = true;
                }
            }
        }
        if (bl2 && bl) {
            return;
        }
        if (n2 == n4) {
            int n6;
            int n7 = n2 - 1;
            int n8 = n2 + 1;
            if (!(bl2 || (n6 = n3 - 1) >= gridLimits.getYOffset() && !screenPointArray2[n2][n6].isHoleValue() && (n7 >= gridLimits.getXOffset() && screenPointArray2[n7][n3].isHoleValue() || n8 <= gridLimits.getXLast() && screenPointArray2[n8][n3].isHoleValue()))) {
                graphics.drawLine(screenPointArray[0].getXPixel(), screenPointArray[0].getYPixel(), screenPointArray[1].getXPixel(), screenPointArray[1].getYPixel());
            }
            if (!(bl || (n6 = n5 + 1) <= gridLimits.getYLast() && !screenPointArray2[n2][n6].isHoleValue() && (n7 >= gridLimits.getXOffset() && screenPointArray2[n7][n5].isHoleValue() || n8 <= gridLimits.getXLast() && screenPointArray2[n8][n5].isHoleValue()))) {
                graphics.drawLine(screenPointArray[3].getXPixel(), screenPointArray[3].getYPixel(), screenPointArray[2].getXPixel(), screenPointArray[2].getYPixel());
            }
        } else {
            int n9;
            int n10 = n3 - 1;
            int n11 = n3 + 1;
            if (!(bl2 || (n9 = n2 - 1) >= gridLimits.getXOffset() && !screenPointArray2[n9][n3].isHoleValue() && (n10 >= gridLimits.getYOffset() && screenPointArray2[n2][n10].isHoleValue() || n11 <= gridLimits.getYLast() && screenPointArray2[n2][n11].isHoleValue()))) {
                graphics.drawLine(screenPointArray[0].getXPixel(), screenPointArray[0].getYPixel(), screenPointArray[1].getXPixel(), screenPointArray[1].getYPixel());
            }
            if (!(bl || (n9 = n4 + 1) <= gridLimits.getXLast() && !screenPointArray2[n9][n3].isHoleValue() && (n10 >= gridLimits.getYOffset() && screenPointArray2[n4][n10].isHoleValue() || n11 <= gridLimits.getYLast() && screenPointArray2[n4][n11].isHoleValue()))) {
                graphics.drawLine(screenPointArray[3].getXPixel(), screenPointArray[3].getYPixel(), screenPointArray[2].getXPixel(), screenPointArray[2].getYPixel());
            }
        }
    }

    protected int isOdd(int n2) {
        return n2 & 1;
    }

    protected ScreenPoint makeZMinPoint(int n2, int n3) {
        JCChart3dArea jCChart3dArea = this.data.getDataView().getChart3d().getChart3dArea();
        JCAxis jCAxis = jCChart3dArea.getAxis(3);
        return this.getScreenPoint(this.data.getX(n2), this.data.getY(n3), jCAxis.getMin());
    }

    protected int neighbourTest(int n2, int n3, int n4) {
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        GridLimits gridLimits = this.data.getGridLimits();
        if (n3 <= gridLimits.getXOffset()) {
            n2 |= 0x10;
        } else if (screenPointArray[n3 - 1][n4].isHoleValue() || screenPointArray[n3 - 1][n4 + 1].isHoleValue()) {
            n2 |= 0x10;
        }
        if (n4 <= gridLimits.getYOffset()) {
            n2 |= 0x80;
        } else if (screenPointArray[n3][n4 - 1].isHoleValue() || screenPointArray[n3 + 1][n4 - 1].isHoleValue()) {
            n2 |= 0x80;
        }
        if (n3 >= gridLimits.getXLast() - 1) {
            n2 |= 0x40;
        } else if (screenPointArray[n3 + 2][n4].isHoleValue() || screenPointArray[n3 + 2][n4 + 1].isHoleValue()) {
            n2 |= 0x40;
        }
        if (n4 >= gridLimits.getYLast() - 1) {
            n2 |= 0x20;
        } else if (screenPointArray[n3][n4 + 2].isHoleValue() || screenPointArray[n3 + 1][n4 + 2].isHoleValue()) {
            n2 |= 0x20;
        }
        return n2;
    }

    public void processFacet(int n2, int n3, int n4) {
        int n5;
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        GridLimits gridLimits = this.data.getGridLimits();
        Chart3dDataView chart3dDataView = this.data.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        if (n2 < gridLimits.getXOffset() || n2 > gridLimits.getXLast() || n3 < gridLimits.getYOffset() || n3 > gridLimits.getYLast()) {
            return;
        }
        if (screenPointArray[n2][n3].isDrawn()) {
            return;
        }
        ScreenPoint[] screenPointArray2 = new ScreenPoint[]{screenPointArray[n2][n3], screenPointArray[n2][n3 + 1], screenPointArray[n2 + 1][n3 + 1], screenPointArray[n2 + 1][n3]};
        int n6 = 0;
        if (screenPointArray2[0].isHoleValue()) {
            n6 |= 0x81;
        }
        if (screenPointArray2[1].isHoleValue()) {
            n6 |= 0x12;
        }
        if (screenPointArray2[2].isHoleValue()) {
            n6 |= 0x24;
        }
        if (screenPointArray2[3].isHoleValue()) {
            n6 |= 0x48;
        }
        int n7 = n6 & 0xF;
        if (!jCChart3dArea.getViewport().isNormalized()) {
            n5 = JCChart3dUtil.min4(screenPointArray2[0].getXPixel(), screenPointArray2[1].getXPixel(), screenPointArray2[2].getXPixel(), screenPointArray2[3].getXPixel());
            int n8 = JCChart3dUtil.min4(screenPointArray2[0].getYPixel(), screenPointArray2[1].getYPixel(), screenPointArray2[2].getYPixel(), screenPointArray2[3].getYPixel());
            int n9 = JCChart3dUtil.max4(screenPointArray2[0].getXPixel(), screenPointArray2[1].getXPixel(), screenPointArray2[2].getXPixel(), screenPointArray2[3].getXPixel());
            int n10 = JCChart3dUtil.max4(screenPointArray2[0].getYPixel(), screenPointArray2[1].getYPixel(), screenPointArray2[2].getYPixel(), screenPointArray2[3].getYPixel());
            Rectangle rectangle = new Rectangle(n5, n8, n9 - n5, n10 - n8);
            if (jCSurface.isSolid() && n7 != 0) {
                ScreenPoint[] screenPointArray3 = new ScreenPoint[]{this.makeZMinPoint(n2, n3), this.makeZMinPoint(n2 + 1, n3), this.makeZMinPoint(n2 + 1, n3 + 1), this.makeZMinPoint(n2, n3 + 1)};
                n5 = JCChart3dUtil.min4(screenPointArray3[0].getXPixel(), screenPointArray3[1].getXPixel(), screenPointArray3[2].getXPixel(), screenPointArray3[3].getXPixel());
                n8 = JCChart3dUtil.min4(screenPointArray3[0].getYPixel(), screenPointArray3[1].getYPixel(), screenPointArray3[2].getYPixel(), screenPointArray3[3].getYPixel());
                n9 = JCChart3dUtil.max4(screenPointArray3[0].getXPixel(), screenPointArray3[1].getXPixel(), screenPointArray3[2].getXPixel(), screenPointArray3[3].getXPixel());
                n10 = JCChart3dUtil.max4(screenPointArray3[0].getYPixel(), screenPointArray3[1].getYPixel(), screenPointArray3[2].getYPixel(), screenPointArray3[3].getYPixel());
                Rectangle rectangle2 = new Rectangle(n5, n8, n9 - n5, n10 - n8);
                Rectangle rectangle3 = JCChart3dUtil.computeBoundingRectangle(rectangle, rectangle2);
                rectangle.setBounds(rectangle3);
            }
            if (!rectangle.intersects(jCChart3dArea.getDrawingArea())) {
                return;
            }
        }
        n5 = 0;
        switch (n4) {
            case 1: {
                if (n7 != 0) break;
                this.drawFacetFromScreenPoints(screenPointArray2, n7, n2, n3);
                break;
            }
            case 2: {
                n5 = 136;
                this.drawEdgeRegionFacet(screenPointArray2, 0, 1, 2, 3, n7, n2, n3);
                break;
            }
            case 3: {
                n5 = 34;
                this.drawEdgeRegionFacet(screenPointArray2, 2, 3, 0, 1, n7, n2, n3);
                break;
            }
            case 4: {
                n5 = 17;
                this.drawEdgeRegionFacet(screenPointArray2, 1, 2, 3, 0, n7, n2, n3);
                break;
            }
            case 5: {
                n5 = 68;
                this.drawEdgeRegionFacet(screenPointArray2, 3, 0, 1, 2, n7, n2, n3);
                break;
            }
            case 6: {
                n5 = 153;
                this.drawCornerRegionFacet(screenPointArray2, 1, 2, 3, 0, n7, n2, n3);
                break;
            }
            case 7: {
                n5 = 51;
                this.drawCornerRegionFacet(screenPointArray2, 2, 3, 0, 1, n7, n2, n3);
                break;
            }
            case 8: {
                n5 = 204;
                this.drawCornerRegionFacet(screenPointArray2, 0, 1, 2, 3, n7, n2, n3);
                break;
            }
            case 9: {
                n5 = 102;
                this.drawCornerRegionFacet(screenPointArray2, 3, 0, 1, 2, n7, n2, n3);
                break;
            }
            default: {
                JCDebug.println("surfaceFacet", "processFacet: Invalid Region!");
            }
        }
        if (jCChart3dArea.getSurface().isSolid()) {
            n6 = this.neighbourTest(n6, n2, n3);
            if (((n6 |= n5 & 0xF0) & 0xF) != 0) {
                if ((n6 & 0x11) == 0) {
                    this.dropSkirt(n2, n3, n2, n3 + 1);
                }
                if ((n6 & 0x22) == 0) {
                    this.dropSkirt(n2, n3 + 1, n2 + 1, n3 + 1);
                }
                if ((n6 & 0x44) == 0) {
                    this.dropSkirt(n2 + 1, n3, n2 + 1, n3 + 1);
                }
                if ((n6 & 0x88) == 0) {
                    this.dropSkirt(n2, n3, n2 + 1, n3);
                }
            }
        }
        screenPointArray2[0].setDrawn(true);
    }

    protected ScreenPoint quadCenter(int n2, int n3) {
        return this.getScreenPoint((this.data.getX(n2) + this.data.getX(n2 + 1)) / 2.0, (this.data.getY(n3) + this.data.getY(n3 + 1)) / 2.0, (this.data.getZValue(n2, n3) + this.data.getZValue(n2, n3 + 1) + this.data.getZValue(n2 + 1, n3 + 1) + this.data.getZValue(n2 + 1, n3)) / 4.0);
    }

    protected boolean testSelfOcclude(long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        long l10;
        long l11;
        long l12;
        long l13;
        long l14 = l4 - l2;
        long l15 = l6 - l8;
        if (l14 < 0L) {
            l13 = l4;
            l12 = l2;
        } else {
            l12 = l4;
            l13 = l2;
        }
        if (l15 > 0L ? l12 < l8 || l6 < l13 : l12 < l6 || l8 < l13) {
            return false;
        }
        long l16 = l5 - l3;
        long l17 = l7 - l9;
        if (l16 < 0L) {
            l11 = l5;
            l10 = l3;
        } else {
            l10 = l5;
            l11 = l3;
        }
        if (l17 > 0L ? l10 < l9 || l7 < l11 : l10 < l7 || l9 < l11) {
            return false;
        }
        long l18 = l2 - l6;
        long l19 = l3 - l7;
        long l20 = l17 * l18 - l15 * l19;
        long l21 = l16 * l15 - l14 * l17;
        if (l21 > 0L ? l20 < 0L || l20 > l21 : l20 > 0L || l20 < l21) {
            return false;
        }
        long l22 = l14 * l19 - l16 * l18;
        return !(l21 > 0L ? l22 < 0L || l22 > l21 : l22 > 0L || l22 < l21);
    }
}

