/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.Facet;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.GridRegion;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.ScreenPoint;
import java.awt.Graphics;

public class ProcessGrid {
    public static final int MAX_POINTS = 500;
    protected DrawGrid drawGrid = null;
    protected Facet facet = null;

    ProcessGrid() {
    }

    ProcessGrid(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
    }

    protected void drawFastMesh(Graphics graphics) {
        boolean bl;
        int n2;
        int n3;
        ScreenPoint[] screenPointArray = new ScreenPoint[500];
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        ScreenPoint[][] screenPointArray2 = chart3dGridData.getScreenPoints();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        boolean[] blArray = jCSurface.getXMesh();
        boolean[] blArray2 = jCSurface.getYMesh();
        graphics.setColor(chart3dDataView.getElevation().getMeshBottomColor());
        int n4 = 0;
        if (jCSurface.isYMeshShowing()) {
            n3 = gridLimits.getXOffset();
            while (n3 <= gridLimits.getXLast()) {
                if (blArray2[n3]) {
                    n2 = gridLimits.getYOffset();
                    while (n2 <= gridLimits.getYLast()) {
                        boolean bl2 = bl = screenPointArray2[n3][n2].isHoleValue() || (n3 == gridLimits.getXOffset() || screenPointArray2[n3 - 1][n2].isHoleValue()) && (n3 == gridLimits.getXLast() || screenPointArray2[n3 + 1][n2].isHoleValue());
                        if (bl) {
                            this.flushLines(screenPointArray, n4, graphics);
                            n4 = 0;
                        } else {
                            if (n4 == 500) {
                                this.flushLines(screenPointArray, n4, graphics);
                                n4 = 0;
                            }
                            screenPointArray[n4] = screenPointArray2[n3][n2];
                            ++n4;
                        }
                        ++n2;
                    }
                }
                this.flushLines(screenPointArray, n4, graphics);
                n4 = 0;
                ++n3;
            }
        }
        if (jCSurface.isXMeshShowing()) {
            n3 = gridLimits.getYOffset();
            while (n3 <= gridLimits.getYLast()) {
                if (blArray[n3]) {
                    n2 = gridLimits.getXOffset();
                    while (n2 <= gridLimits.getXLast()) {
                        boolean bl3 = bl = screenPointArray2[n2][n3].isHoleValue() || (n3 == gridLimits.getYOffset() || screenPointArray2[n2][n3 - 1].isHoleValue()) && (n3 == gridLimits.getYLast() || screenPointArray2[n2][n3 + 1].isHoleValue());
                        if (bl) {
                            this.flushLines(screenPointArray, n4, graphics);
                            n4 = 0;
                        } else {
                            if (n4 == 500) {
                                this.flushLines(screenPointArray, n4, graphics);
                                n4 = 0;
                            }
                            screenPointArray[n4] = screenPointArray2[n2][n3];
                            ++n4;
                        }
                        ++n2;
                    }
                }
                this.flushLines(screenPointArray, n4, graphics);
                n4 = 0;
                ++n3;
            }
        }
    }

    protected void flushLines(ScreenPoint[] screenPointArray, int n2, Graphics graphics) {
        int n3 = 0;
        while (n3 < n2 - 1) {
            graphics.drawLine(screenPointArray[n3].getXPixel(), screenPointArray[n3].getYPixel(), screenPointArray[n3 + 1].getXPixel(), screenPointArray[n3 + 1].getYPixel());
            ++n3;
        }
    }

    protected DrawGrid getDrawGrid() {
        return this.drawGrid;
    }

    protected Facet getFacet() {
        return this.facet;
    }

    protected void processGrid(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        JCChart3dArea jCChart3dArea = chart3dGridData.getDataView().getChart3d().getChart3dArea();
        int n9 = jCChart3dArea.getTransform().getProcessingOrder() & 0xF;
        switch (n9) {
            case 4: 
            case 8: {
                this.processXY(n2, n3, n4, n5, n6, n7, n8);
                break;
            }
            default: {
                this.processYX(n2, n3, n4, n5, n6, n7, n8);
            }
        }
    }

    protected void processGridRegion(GridRegion gridRegion) {
        if (this.facet == null) {
            return;
        }
        int n2 = gridRegion.getXBegin();
        int n3 = gridRegion.getXLeft();
        int n4 = gridRegion.getXEye();
        int n5 = gridRegion.getXRight();
        int n6 = gridRegion.getXEnd();
        int n7 = gridRegion.getYBegin();
        int n8 = gridRegion.getYLeft();
        int n9 = gridRegion.getYEye();
        int n10 = gridRegion.getYRight();
        int n11 = gridRegion.getYEnd();
        this.processGrid(n6, n5, -1, n11, n10, -1, 6);
        this.processGrid(n6, n5, -1, n7, n8, 1, 7);
        this.processGrid(n2, n3, 1, n11, n10, -1, 8);
        this.processGrid(n2, n3, 1, n7, n8, 1, 9);
        if (n5 == n3 + 2) {
            this.processY(n4, n11, n10, -1, 2);
            this.processY(n4, n7, n8, 1, 3);
        }
        if (n10 == n8 + 2) {
            this.processX(n9, n6, n5, -1, 4);
            this.processX(n9, n2, n3, 1, 5);
            if (n5 == n3 + 2) {
                this.facet.processFacet(n4, n9, 1);
            }
        }
    }

    protected void processX(int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 0) {
            int n7 = n3;
            while (n7 <= n4) {
                this.facet.processFacet(n7, n2, n6);
                ++n7;
            }
        } else {
            int n8 = n3;
            while (n8 >= n4) {
                this.facet.processFacet(n8, n2, n6);
                --n8;
            }
        }
    }

    protected void processXY(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n4 > 0) {
            if (n7 > 0) {
                int n9 = n2;
                while (n9 <= n3) {
                    int n10 = n5;
                    while (n10 <= n6) {
                        this.facet.processFacet(n9, n10, n8);
                        ++n10;
                    }
                    ++n9;
                }
            } else {
                int n11 = n2;
                while (n11 <= n3) {
                    int n12 = n5;
                    while (n12 >= n6) {
                        this.facet.processFacet(n11, n12, n8);
                        --n12;
                    }
                    ++n11;
                }
            }
        } else if (n7 > 0) {
            int n13 = n2;
            while (n13 >= n3) {
                int n14 = n5;
                while (n14 <= n6) {
                    this.facet.processFacet(n13, n14, n8);
                    ++n14;
                }
                --n13;
            }
        } else {
            int n15 = n2;
            while (n15 >= n3) {
                int n16 = n5;
                while (n16 >= n6) {
                    this.facet.processFacet(n15, n16, n8);
                    --n16;
                }
                --n15;
            }
        }
    }

    protected void processY(int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 0) {
            int n7 = n3;
            while (n7 <= n4) {
                this.facet.processFacet(n2, n7, n6);
                ++n7;
            }
        } else {
            int n8 = n3;
            while (n8 >= n4) {
                this.facet.processFacet(n2, n8, n6);
                --n8;
            }
        }
    }

    protected void processYX(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n7 > 0) {
            if (n4 > 0) {
                int n9 = n5;
                while (n9 <= n6) {
                    int n10 = n2;
                    while (n10 <= n3) {
                        this.facet.processFacet(n10, n9, n8);
                        ++n10;
                    }
                    ++n9;
                }
            } else {
                int n11 = n5;
                while (n11 <= n6) {
                    int n12 = n2;
                    while (n12 >= n3) {
                        this.facet.processFacet(n12, n11, n8);
                        --n12;
                    }
                    ++n11;
                }
            }
        } else if (n4 > 0) {
            int n13 = n5;
            while (n13 >= n6) {
                int n14 = n2;
                while (n14 <= n3) {
                    this.facet.processFacet(n14, n13, n8);
                    ++n14;
                }
                --n13;
            }
        } else {
            int n15 = n5;
            while (n15 >= n6) {
                int n16 = n2;
                while (n16 >= n3) {
                    this.facet.processFacet(n16, n15, n8);
                    --n16;
                }
                --n15;
            }
        }
    }

    protected void setDrawGrid(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
    }

    protected void setFacet(Facet facet) {
        this.facet = facet;
    }
}

