/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCStyle;
import com.klg.jclass.chart3d.shape.JCSymbolShape;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;

public class JCSymbolStyle
extends JCStyle {
    protected String shape = "com.klg.jclass.chart3d.shape.Dot";
    protected int colorIndex = 0;
    protected int shapeIndex = 0;
    protected Color color = null;
    protected int size = 6;
    public static final int DEFAULT_SIZE = 6;
    public static Hashtable symbolInstances = new Hashtable();
    public static final String NONE = null;
    public static final String DOT = "com.klg.jclass.chart3d.shape.Dot";
    public static final String BOX = "com.klg.jclass.chart3d.shape.Box";
    public static final String TRIANGLE = "com.klg.jclass.chart3d.shape.Triangle";
    public static final String DIAMOND = "com.klg.jclass.chart3d.shape.Diamond";
    public static final String STAR = "com.klg.jclass.chart3d.shape.Star";
    public static final String VERT_LINE = "com.klg.jclass.chart3d.shape.VerticalLine";
    public static final String HORIZ_LINE = "com.klg.jclass.chart3d.shape.HorizontalLine";
    public static final String CROSS = "com.klg.jclass.chart3d.shape.Cross";
    public static final String CIRCLE = "com.klg.jclass.chart3d.shape.Circle";
    public static final String SQUARE = "com.klg.jclass.chart3d.shape.Square";
    public static final String RECTANGLE = "com.klg.jclass.chart3d.shape.Rectangle";
    public static final String SPHERE = "com.klg.jclass.chart3d.shape3d.Sphere";
    public static final String CUBE = "com.klg.jclass.chart3d.shape3d.Cube";
    public static final String CONE = "com.klg.jclass.chart3d.shape3d.Cone";
    public static final String POINT = "com.klg.jclass.chart3d.shape3d.Point";
    public static final String CYLINDER = "com.klg.jclass.chart3d.shape3d.Cylinder";
    public static final String TETRAHEDRON = "com.klg.jclass.chart3d.shape3d.Tetrahedron";
    private static String[] standard2dShapes = new String[]{"com.klg.jclass.chart3d.shape.Dot", "com.klg.jclass.chart3d.shape.Box", "com.klg.jclass.chart3d.shape.Triangle", "com.klg.jclass.chart3d.shape.Diamond", "com.klg.jclass.chart3d.shape.Star", "com.klg.jclass.chart3d.shape.VerticalLine", "com.klg.jclass.chart3d.shape.HorizontalLine", "com.klg.jclass.chart3d.shape.Cross", "com.klg.jclass.chart3d.shape.Circle", "com.klg.jclass.chart3d.shape.Square", "com.klg.jclass.chart3d.shape.Rectangle"};
    private static String[] standard3dShapes = new String[]{"com.klg.jclass.chart3d.shape3d.Sphere", "com.klg.jclass.chart3d.shape3d.Cube", "com.klg.jclass.chart3d.shape3d.Cone", "com.klg.jclass.chart3d.shape3d.Cylinder", "com.klg.jclass.chart3d.shape3d.Tetrahedron"};
    protected static String[] defaultShapes = standard2dShapes;

    public JCSymbolStyle(String string, Color color, int n2) {
        this.setShape(string);
        this.color = color;
        this.size = n2;
    }

    public void draw(Graphics graphics, int n2, int n3) {
        this.draw(graphics, n2, n3, this.size, null);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4) {
        this.draw(graphics, n2, n3, n4, null);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4, Color color) {
        Color color2 = color != null ? color : this.color;
        graphics.setColor(color2);
        JCSymbolShape jCSymbolShape = JCSymbolStyle.getSymbolShapeInstance(this.shape);
        if (jCSymbolShape != null) {
            jCSymbolShape.resize(n4);
            jCSymbolShape.draw(graphics, n2, n3);
        }
    }

    public void draw(Graphics graphics, int n2, int n3, Color color) {
        this.draw(graphics, n2, n3, this.size, color);
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    protected static String getDefaultShape(JCChart3d jCChart3d) {
        String string;
        if (jCChart3d == null) {
            string = defaultShapes[0];
        } else {
            int n2 = jCChart3d.getSymbolShapeIndex();
            if (++n2 >= defaultShapes.length) {
                n2 = 0;
            }
            string = defaultShapes[n2];
            jCChart3d.setSymbolShapeIndex(n2);
        }
        return string;
    }

    public static String[] getDefaultShapes() {
        return defaultShapes;
    }

    public String getShape() {
        return this.shape;
    }

    public int getSize() {
        return this.size;
    }

    public static JCSymbolShape getSymbolShapeInstance(String string) {
        if (string == null) {
            return null;
        }
        Object object = symbolInstances.get(string);
        if (object == null) {
            try {
                object = Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (object instanceof JCSymbolShape) {
                symbolInstances.put(string, object);
            }
        }
        if (object instanceof JCSymbolShape) {
            return (JCSymbolShape)object;
        }
        return null;
    }

    public static JCSymbolStyle makeDefault(JCChart3d jCChart3d) {
        JCSymbolStyle jCSymbolStyle = new JCSymbolStyle(JCSymbolStyle.getDefaultShape(jCChart3d), JCStyle.getDefaultColor(jCChart3d, 3), 6);
        int n2 = 0;
        int n3 = 0;
        if (jCChart3d != null) {
            n3 = jCChart3d.getSymbolColorIndex();
            n3 = n3 == 0 ? JCStyle.defaultColors.length - 1 : --n3;
            n2 = jCChart3d.getSymbolShapeIndex();
            n2 = n2 == 0 ? defaultShapes.length - 1 : --n2;
        }
        jCSymbolStyle.colorIndex = n3;
        jCSymbolStyle.shapeIndex = n2;
        return jCSymbolStyle;
    }

    public void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true, 17);
    }

    public static void setDefault2dShapes(String[] stringArray) {
        defaultShapes = stringArray == null || stringArray.length < 1 ? standard2dShapes : stringArray;
    }

    public static void setDefault3dShapes(String[] stringArray) {
        defaultShapes = stringArray == null || stringArray.length < 1 ? standard3dShapes : stringArray;
    }

    public void setShape(String string) {
        if (this.shape.equals(string)) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("Invalid value. ");
        }
        this.shape = string;
        this.setChanged(true, 17);
    }

    public void setSize(int n2) {
        if (this.size == n2) {
            return;
        }
        this.size = n2;
        this.setChanged(true, 18);
    }

    public static int shapeToIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < defaultShapes.length) {
            if (defaultShapes[n2].equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

