/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class JCLineStyle
extends JCStyle {
    protected int join = 0;
    protected int cap = 0;
    protected int pattern = 1;
    protected int width = 1;
    protected int colorIndex = 0;
    protected Color color = null;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int LONG_DASH = 2;
    public static final int SHORT_DASH = 3;
    public static final int LSL_DASH = 4;
    public static final int DASH_DOT = 5;
    public static final int CUSTOM = 6;
    public static final float[] LONG_DASH_ARRAY = new float[]{10.0f, 10.0f};
    public static final float[] SHORT_DASH_ARRAY = new float[]{5.0f, 10.0f};
    public static final float[] LSL_DASH_ARRAY = new float[]{10.0f, 10.0f, 5.0f, 10.0f};
    public static final float[] DASH_DOT_ARRAY = new float[]{10.0f, 10.0f, 1.0f, 10.0f};
    public static final float[] LEGEND_LONG_DASH_ARRAY = new float[]{5.0f, 5.0f};
    public static final float[] LEGEND_SHORT_DASH_ARRAY = new float[]{2.5f, 5.0f};
    public static final float[] LEGEND_LSL_DASH_ARRAY = new float[]{5.0f, 5.0f, 2.5f, 5.0f};
    public static final float[] LEGEND_DASH_DOT_ARRAY = new float[]{5.0f, 5.0f, 1.0f, 5.0f};
    private float[] dashArray = null;
    private float[] legendDashArray = null;
    int[] xp = null;
    int[] yp = null;

    public JCLineStyle(int n2, Color color, int n3) {
        this.width = n2;
        this.color = color;
        this.pattern = n3;
        this.join = 0;
        this.cap = 0;
        this.updateDashArray();
    }

    public JCLineStyle(int n2, Color color, int n3, int n4, int n5) {
        this.width = n2;
        this.color = color;
        this.pattern = n3;
        this.cap = n4;
        this.join = n5;
        this.updateDashArray();
    }

    public JCLineStyle(int n2, Color color, int n3, int n4, int n5, float[] fArray, float[] fArray2) {
        this.width = n2;
        this.color = color;
        this.pattern = n3;
        this.cap = n4;
        this.join = n5;
        this.dashArray = fArray;
        this.legendDashArray = fArray2 != null ? fArray2 : fArray;
        this.updateDashArray();
    }

    public void draw(Graphics graphics, int n2, int n3, int n4, int n5) {
        this.draw(graphics, n2, n3, n4, n5, null);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4, int n5, Color color) {
        if (!this.updateGraphics(graphics)) {
            return;
        }
        if (color != null && !graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        this.drawLine(graphics, n2, n3, n4, n5);
        this.resetGraphics(graphics);
    }

    public void drawLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.drawLine(n2, n3, n4, n5);
    }

    public void drawRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.updateGraphics(graphics)) {
            graphics.drawRect(n2, n3, n4, n5);
            this.resetGraphics(graphics);
        }
    }

    public void drawSquaredLine(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, int n8) {
        if (this.width == 1) {
            graphics.drawLine(n2, n3, n4, n5);
        } else if (n2 == n4) {
            int n9 = Math.min(n3, n5);
            int n10 = Math.abs(n5 - n3);
            if (!bl) {
                graphics.fillRect(n2 - this.width / 2, n9, this.width, n10 + 1);
            } else {
                int n11 = this.width;
                int n12 = n2 - this.width / 2;
                if (n12 < n7) {
                    n11 -= n7 - n12;
                    n12 = n7;
                } else if (n12 + n11 > n8) {
                    n11 -= n12 + n11 - n8;
                }
                graphics.fillRect(n12, n9, n11, n10 + 1);
            }
        } else if (n3 == n5) {
            int n13 = Math.min(n2, n4);
            int n14 = Math.abs(n4 - n2);
            if (!bl) {
                int n15 = this.width;
                int n16 = n3 - this.width / 2;
                if (n16 < n7) {
                    n15 -= n7 - n16;
                    n16 = n7;
                } else if (n16 + n15 > n8) {
                    n15 -= n16 + n15 - n8;
                }
                graphics.fillRect(n13, n16, n14, n15);
            } else {
                graphics.fillRect(n13, n3 - this.width / 2, n14, this.width);
            }
        } else {
            if (this.xp == null || this.yp == null) {
                this.xp = new int[4];
                this.yp = new int[4];
            }
            if (!bl) {
                int n17 = this.width / 2;
                int n18 = (this.width + 1) / 2;
                this.xp[0] = n2;
                this.yp[0] = n3 + n17;
                this.xp[1] = n4;
                this.yp[1] = n5 + n17;
                this.xp[2] = n4;
                this.yp[2] = n5 - n18;
                this.xp[3] = n2;
                this.yp[3] = n3 - n18;
                int n19 = 0;
                while (n19 < 4) {
                    int n20 = 0;
                    if (n19 == 1 || n19 == 2) {
                        n20 = n6;
                    }
                    if (this.yp[n19] < n7 + n20) {
                        this.yp[n19] = n7 + n20;
                    } else if (this.yp[n19] > n8 + n20) {
                        this.yp[n19] = n8 + n20;
                    }
                    ++n19;
                }
            } else {
                int n21 = this.width / 2;
                int n22 = (this.width + 1) / 2;
                this.xp[0] = n2 + n21;
                this.yp[0] = n3;
                this.xp[1] = n4 + n21;
                this.yp[1] = n5 + 1;
                this.xp[2] = n4 - n22;
                this.yp[2] = n5 + 1;
                this.xp[3] = n2 - n22;
                this.yp[3] = n3;
                int n23 = 0;
                while (n23 < 4) {
                    int n24 = 0;
                    if (n23 == 1 || n23 == 2) {
                        n24 = n6;
                    }
                    if (this.xp[n23] < n7 + n24) {
                        this.xp[n23] = n7 + n24;
                    } else if (this.xp[n23] >= n8 + n24) {
                        this.xp[n23] = n8 + n24;
                    }
                    ++n23;
                }
            }
            graphics.fillPolygon(this.xp, this.yp, 4);
        }
    }

    public void fillRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.updateGraphics(graphics)) {
            graphics.fillRect(n2, n3, n4, n5);
            this.resetGraphics(graphics);
        }
    }

    public int getCap() {
        return this.cap;
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    static int getDefaultPattern() {
        return 1;
    }

    public int getJoin() {
        return this.join;
    }

    public int getPattern() {
        return this.pattern;
    }

    public int getWidth() {
        return this.width;
    }

    public static JCLineStyle makeDefault(JCChart3d jCChart3d) {
        JCLineStyle jCLineStyle = new JCLineStyle(1, JCStyle.getDefaultColor(jCChart3d, 2), JCLineStyle.getDefaultPattern());
        int n2 = 0;
        if (jCChart3d != null) {
            n2 = jCChart3d.getLineColorIndex();
            n2 = n2 == 0 ? JCStyle.defaultColors.length - 1 : --n2;
        }
        jCLineStyle.colorIndex = n2;
        return jCLineStyle;
    }

    public void resetGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    public void setCap(int n2) {
        if (this.cap == n2) {
            return;
        }
        this.cap = n2;
        this.setChanged(true, 17);
    }

    public void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true, 17);
    }

    public void setJoin(int n2) {
        if (this.join == n2) {
            return;
        }
        this.join = n2;
        this.setChanged(true, 17);
    }

    public void setPattern(int n2) {
        if (n2 == this.pattern) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.pattern = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value. Must be one of NONE, SOLID, LONG_DASH, SHORT_DASH, LSL_DASH or DASH_DOT");
            }
        }
        this.updateDashArray();
        this.setChanged(true, 17);
    }

    public void setPattern(float[] fArray, float[] fArray2) {
        this.pattern = 6;
        this.dashArray = fArray;
        this.legendDashArray = fArray2 != null ? fArray2 : fArray;
        this.setChanged(true, 17);
    }

    public void setWidth(int n2) {
        if (this.width == n2) {
            return;
        }
        this.width = n2;
        this.setChanged(true, 18);
    }

    private void updateDashArray() {
        switch (this.pattern) {
            case 0: {
                this.dashArray = null;
                this.legendDashArray = null;
                break;
            }
            case 1: {
                this.dashArray = null;
                this.legendDashArray = null;
                break;
            }
            case 2: {
                this.dashArray = LONG_DASH_ARRAY;
                this.legendDashArray = LONG_DASH_ARRAY;
                break;
            }
            case 3: {
                this.dashArray = SHORT_DASH_ARRAY;
                this.legendDashArray = SHORT_DASH_ARRAY;
                break;
            }
            case 4: {
                this.dashArray = LSL_DASH_ARRAY;
                this.legendDashArray = LSL_DASH_ARRAY;
                break;
            }
            case 5: {
                this.dashArray = DASH_DOT_ARRAY;
                this.legendDashArray = DASH_DOT_ARRAY;
                break;
            }
            default: {
                this.dashArray = null;
                this.legendDashArray = null;
            }
            case 6: 
        }
    }

    public boolean updateGraphics(Graphics graphics) {
        return this.updateGraphics(graphics, -1);
    }

    public boolean updateGraphics(Graphics graphics, int n2) {
        if (this.pattern == 0 || this.width <= 0) {
            return false;
        }
        if (!graphics.getColor().equals(this.color)) {
            graphics.setColor(this.color);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern == 1) {
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join));
        } else if (n2 > 0) {
            float f2;
            float f3;
            float f4 = 0.0f;
            int n3 = 0;
            while (n3 < this.dashArray.length) {
                f4 += this.dashArray[n3];
                ++n3;
            }
            f4 += this.dashArray[0];
            float[] fArray = new float[this.dashArray.length + 1];
            int n4 = 0;
            int n5 = 0;
            while (n5 < fArray.length) {
                f3 = n5 == fArray.length - 1 ? this.dashArray[0] : this.dashArray[n5];
                f2 = (float)Math.floor((float)n2 / f4 * f3);
                if ((double)f2 < 1.0) {
                    ++n4;
                }
                ++n5;
            }
            f3 = f4 - (float)n4;
            f2 = (float)n2 - (float)n4;
            int n6 = 0;
            while (n6 < fArray.length) {
                float f5 = n6 == fArray.length - 1 ? this.dashArray[0] : this.dashArray[n6];
                float f6 = (float)Math.floor((float)n2 / f4 * f5);
                f6 = (double)f6 < 1.0 ? 1.0f : f2 / f3 * f5;
                fArray[n6] = f6;
                ++n6;
            }
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join, 10.0f, fArray, 0.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join, 10.0f, this.dashArray, 0.0f));
        }
        return true;
    }
}

