/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCStyle;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class JCFillStyle
extends JCStyle {
    protected Color color = null;
    protected Color backgroundColor = null;
    protected int pattern = 1;
    protected int colorIndex = 0;
    protected Image image = null;
    protected Rectangle anchorRect = null;
    protected int orientation = 0;
    protected TexturePaint customPaint = null;
    protected Paint fillPaint = null;
    protected Paint hiFillPaint = null;
    protected Paint shFillPaint = null;
    protected BufferedImage buffImage = null;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int CENTER = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int TOP_LEFT = 7;
    public static final int BOTTOM_RIGHT = 8;
    public static final int TOP_RIGHT = 9;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int PER_25 = 2;
    public static final int PER_50 = 3;
    public static final int PER_75 = 4;
    public static final int HORIZ_STRIPE = 5;
    public static final int VERT_STRIPE = 6;
    public static final int STRIPE_45 = 7;
    public static final int STRIPE_135 = 8;
    public static final int DIAG_HATCHED = 9;
    public static final int CROSS_HATCHED = 10;
    public static final int CUSTOM_FILL = 11;
    public static final int CUSTOM_STACK = 12;
    public static final int CUSTOM_PAINT = 13;
    public static final String[] PER_25_PIXELS = new String[]{"C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                "};
    public static final String[] PER_50_PIXELS = new String[]{"C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C"};
    public static final String[] PER_75_PIXELS = new String[]{"CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC"};
    public static final String[] HORIZ_STRIPE_PIXELS = new String[]{"                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                "};
    public static final String[] VERT_STRIPE_PIXELS = new String[]{"CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  "};
    public static final String[] STRIPE_45_PIXELS = new String[]{"   CC      CC      CC      CC   ", "  CC      CC      CC      CC    ", " CC      CC      CC      CC     ", "CC      CC      CC      CC      ", "C      CC      CC      CC      C", "      CC      CC      CC      CC", "     CC      CC      CC      CC ", "    CC      CC      CC      CC  ", "   CC      CC      CC      CC   ", "  CC      CC      CC      CC    ", " CC      CC      CC      CC     ", "CC      CC      CC      CC      ", "C      CC      CC      CC      C", "      CC      CC      CC      CC", "     CC      CC      CC      CC ", "    CC      CC      CC      CC  "};
    public static final String[] STRIPE_135_PIXELS = new String[]{"C      CC      CC      CC      C", "CC      CC      CC      CC      ", " CC      CC      CC      CC     ", "  CC      CC      CC      CC    ", "   CC      CC      CC      CC   ", "    CC      CC      CC      CC  ", "     CC      CC      CC      CC ", "      CC      CC      CC      CC", "C      CC      CC      CC      C", "CC      CC      CC      CC      ", " CC      CC      CC      CC     ", "  CC      CC      CC      CC    ", "   CC      CC      CC      CC   ", "    CC      CC      CC      CC  ", "     CC      CC      CC      CC ", "      CC      CC      CC      CC"};
    public static final String[] DIAG_HATCHED_PIXELS = new String[]{"CC      CC      CC      CC      ", "CCC    CCCC    CCCC    CCCC    C", "  CC  CC  CC  CC  CC  CC  CC  CC", "   CCCC    CCCC    CCCC    CCCC ", "    CC      CC      CC      CC  ", "   CCCC    CCCC    CCCC    CCCC ", "  CC  CC  CC  CC  CC  CC  CC  CC", "CCC    CCCC    CCCC    CCCC    C", "CC      CC      CC      CC      ", "CCC    CCCC    CCCC    CCCC    C", "  CC  CC  CC  CC  CC  CC  CC  CC", "   CCCC    CCCC    CCCC    CCCC ", "    CC      CC      CC      CC  ", "   CCCC    CCCC    CCCC    CCCC ", "  CC  CC  CC  CC  CC  CC  CC  CC", "CCC    CCCC    CCCC    CCCC    C"};
    public static final String[] CROSS_HATCHED_PIXELS = new String[]{"CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      "};

    public JCFillStyle(Color color, int n2) {
        this.color = color;
        this.pattern = n2;
        this.buffImage = this.makeBufferedImage();
        this.fillPaint = null;
        this.hiFillPaint = null;
        this.shFillPaint = null;
    }

    Color calcOutlineColor() {
        Color color = JCNumberUtil.darker(this.color);
        if (color == this.color) {
            color = JCNumberUtil.brighter(this.color);
        }
        return color;
    }

    public void drawOutlineLine(Graphics graphics, Polygon polygon, int n2, int n3, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (!graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        int n4 = n2;
        while (n4 < n3) {
            graphics.drawLine(polygon.xpoints[n4], polygon.ypoints[n4], polygon.xpoints[n4 + 1], polygon.ypoints[n4 + 1]);
            ++n4;
        }
    }

    public void drawOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (!graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        graphics.drawPolygon(polygon);
    }

    public void drawOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (!graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        graphics.drawRect(n2, n3, n4, n5);
    }

    public void fillArc(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.updateGraphics(graphics)) {
            graphics.fillArc(n2, n3, n4, n5, n6, n7);
            this.resetGraphics(graphics);
        }
    }

    public void fillArcShadow(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.updateGraphicsToShadow(graphics)) {
            graphics.fillArc(n2, n3, n4, n5, n6, n7);
            this.resetGraphics(graphics);
        }
    }

    public void fillImageRect(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        if (this.image == null) {
            return;
        }
        int n6 = this.image.getHeight(null);
        int n7 = this.image.getWidth(null);
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(n2, n3, n4, n5);
        if (!bl2) {
            int n8 = n2 + (n4 - n7) / 2;
            if (bl) {
                int n9 = n3 + n5 - n6;
                while (n9 > n3) {
                    graphics2.drawImage(this.image, n8, n9, null);
                    n9 -= n6;
                }
                graphics2.drawImage(this.image, n8, n9, null);
            } else {
                int n10 = n3 + 1;
                while (n10 < n3 + n5) {
                    graphics2.drawImage(this.image, n8, n10, null);
                    n10 += n6;
                }
            }
        } else {
            int n11 = n3 + (n5 - n6) / 2;
            if (bl) {
                int n12 = n2 + 1;
                while (n12 < n2 + n4) {
                    graphics2.drawImage(this.image, n12, n11, null);
                    n12 += n7;
                }
            } else {
                int n13 = n2 + n4 - n7;
                while (n13 > n2) {
                    graphics2.drawImage(this.image, n13, n11, null);
                    n13 -= n7;
                }
                graphics2.drawImage(this.image, n13, n11, null);
            }
        }
        graphics2.dispose();
    }

    public void fillOutlinePartialPolygon(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygon(graphics, polygon);
        graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1]);
        if (color == null) {
            color = this.calcOutlineColor();
        }
        if (!graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        int n2 = 0;
        while (n2 < polygon.npoints - 1) {
            graphics.drawLine(polygon.xpoints[n2], polygon.ypoints[n2], polygon.xpoints[n2 + 1], polygon.ypoints[n2 + 1]);
            ++n2;
        }
    }

    public void fillOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygon(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonHighlight(graphics, polygon, null);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygonHighlight(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonShadow(graphics, polygon, null);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygonShadow(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    public void fillOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        this.fillOutlineRect(graphics, n2, n3, n4, n5, null);
    }

    public void fillOutlineRect(Graphics graphics, int n2, int n3, int n4, int n5, Color color) {
        this.fillRect(graphics, n2, n3, n4, n5);
        this.drawOutlineRect(graphics, n2, n3, n4, n5, color);
    }

    public void fillPolygon(Graphics graphics, Polygon polygon) {
        if (this.updateGraphics(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygonHighlight(Graphics graphics, Polygon polygon) {
        if (this.updateGraphicsToHighlight(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygonShadow(Graphics graphics, Polygon polygon) {
        if (this.updateGraphicsToShadow(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.updateGraphics(graphics)) {
            graphics.fillRect(n2, n3, n4, n5);
            this.resetGraphics(graphics);
        }
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public TexturePaint getCustomPaint() {
        return this.customPaint;
    }

    static int getDefaultPattern() {
        return 1;
    }

    public Image getImage() {
        return this.image;
    }

    public int getPattern() {
        return this.pattern;
    }

    protected boolean isCustomStackable() {
        return this.pattern == 12 && this.image != null;
    }

    public BufferedImage makeBufferedImage() {
        return this.makeBufferedImage(this.color);
    }

    public BufferedImage makeBufferedImage(Color color) {
        if (this.pattern == 0 || this.pattern == 1) {
            return null;
        }
        JCIconCreator jCIconCreator = new JCIconCreator(32, 16);
        jCIconCreator.setColor('C', color);
        Color color2 = this.backgroundColor;
        if (color2 == null) {
            color2 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        }
        jCIconCreator.setColor(' ', color2);
        String[] stringArray = null;
        switch (this.pattern) {
            case 2: {
                stringArray = PER_25_PIXELS;
                break;
            }
            case 3: {
                stringArray = PER_50_PIXELS;
                break;
            }
            case 4: {
                stringArray = PER_75_PIXELS;
                break;
            }
            case 5: {
                stringArray = HORIZ_STRIPE_PIXELS;
                break;
            }
            case 6: {
                stringArray = VERT_STRIPE_PIXELS;
                break;
            }
            case 7: {
                stringArray = STRIPE_45_PIXELS;
                break;
            }
            case 8: {
                stringArray = STRIPE_135_PIXELS;
                break;
            }
            case 9: {
                stringArray = DIAG_HATCHED_PIXELS;
                break;
            }
            case 10: {
                stringArray = CROSS_HATCHED_PIXELS;
                break;
            }
        }
        if (stringArray == null) {
            return null;
        }
        jCIconCreator.setPixels(stringArray);
        Image image = jCIconCreator.getIcon().getImage();
        return this.makeBufferedImage(image);
    }

    public BufferedImage makeBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 < 0 || n2 < 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static JCFillStyle makeDefault(JCChart3d jCChart3d) {
        JCFillStyle jCFillStyle = new JCFillStyle(JCStyle.getDefaultColor(jCChart3d, 1), JCFillStyle.getDefaultPattern());
        int n2 = 0;
        if (jCChart3d != null) {
            n2 = jCChart3d.getFillColorIndex();
            n2 = n2 == 0 ? JCStyle.defaultColors.length - 1 : --n2;
        }
        jCFillStyle.colorIndex = n2;
        return jCFillStyle;
    }

    public Paint makeFillPaint() {
        return this.makeFillPaint(this.buffImage, this.color, null, 0);
    }

    public Paint makeFillPaint(BufferedImage bufferedImage, Color color, Rectangle rectangle, int n2) {
        if (this.pattern == 0) {
            return null;
        }
        if (this.pattern == 1) {
            return color;
        }
        if (bufferedImage == null) {
            return color;
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Rectangle rectangle2 = null;
        if (rectangle != null && n2 != 0) {
            int n5 = (rectangle.width - n3) / 2;
            int n6 = (rectangle.height - n4) / 2;
            switch (n2) {
                case 2: {
                    rectangle2 = new Rectangle(n5 + rectangle.x, rectangle.y + rectangle.height - n4, n3, n4);
                    break;
                }
                case 1: {
                    rectangle2 = new Rectangle(n5 + rectangle.x, rectangle.y, n3, n4);
                    break;
                }
                case 3: {
                    rectangle2 = new Rectangle(rectangle.x, n6 + rectangle.y, n3, n4);
                    break;
                }
                case 4: {
                    rectangle2 = new Rectangle(rectangle.x + rectangle.width - n3, n6 + rectangle.y, n3, n4);
                    break;
                }
                case 5: {
                    rectangle2 = new Rectangle(n5 + rectangle.x, n6 + rectangle.y, n3, n4);
                    break;
                }
                case 6: {
                    rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - n4, n3, n4);
                    break;
                }
                case 7: {
                    rectangle2 = new Rectangle(rectangle.x, rectangle.y, n3, n4);
                    break;
                }
                case 8: {
                    rectangle2 = new Rectangle(rectangle.x + rectangle.width - n3, rectangle.y + rectangle.height - n4, n3, n4);
                    break;
                }
                case 9: {
                    rectangle2 = new Rectangle(rectangle.x + rectangle.width - n3, rectangle.y, n3, n4);
                    break;
                }
                default: {
                    rectangle2 = null;
                    break;
                }
            }
        } else {
            rectangle2 = new Rectangle(0, 0, n3, n4);
        }
        return new TexturePaint(bufferedImage, rectangle2);
    }

    public void resetFillOrientation() {
        this.anchorRect = null;
        this.orientation = 0;
    }

    public void resetGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
        if (this.pattern != 11 && this.pattern != 12 && this.pattern != 13) {
            this.buffImage = this.makeBufferedImage();
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 17);
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.pattern != 11 && this.pattern != 12 && this.pattern != 13) {
            this.buffImage = this.makeBufferedImage();
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 17);
    }

    public void setCustomPaint(TexturePaint texturePaint) {
        if (this.customPaint == texturePaint) {
            return;
        }
        this.buffImage = null;
        this.customPaint = texturePaint;
        this.setChanged(true, 33);
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.image != null) {
            int n2 = this.image.getHeight(null);
            int n3 = this.image.getWidth(null);
            if (n2 <= 0 || n3 <= 0) {
                this.image = null;
            }
        }
        if (this.pattern == 11 || this.pattern == 12) {
            this.buffImage = this.makeBufferedImage(this.image);
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 33);
    }

    public void setImage(String string) {
        Image image = new ImageIcon(string).getImage();
        this.setImage(image);
    }

    public void setPattern(int n2) {
        if (this.pattern == n2) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.pattern = n2;
                this.buffImage = this.makeBufferedImage();
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 11: {
                this.pattern = n2;
                this.buffImage = this.makeBufferedImage(this.image);
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 12: {
                this.pattern = n2;
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 13: {
                this.pattern = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value. Must be one of NONE, SOLID, PER_25, PER_50, PER_75, HORIZ_STRIPE, VERT_STRIPE, STRIPE_45, STRIPE_135, DIAG_HATCHED, CROSS_HATCHED, CUSTOM_FILL, or CUSTOM_STACK.");
            }
        }
        this.setChanged(true, 33);
    }

    public void updateFillOrientation(Rectangle rectangle, int n2) {
        this.anchorRect = rectangle;
        this.orientation = n2;
    }

    public boolean updateGraphics(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                this.fillPaint = this.customPaint != null ? this.makeFillPaint(this.customPaint.getImage(), this.color, this.anchorRect, this.orientation) : this.color;
            } else if (this.pattern != 1 || this.fillPaint == null) {
                this.fillPaint = this.makeFillPaint(this.buffImage, this.color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.fillPaint);
        }
        return true;
    }

    public boolean updateGraphicsToHighlight(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Color color = JCNumberUtil.brighter(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                this.hiFillPaint = this.customPaint != null ? this.makeFillPaint(this.customPaint.getImage(), color, this.anchorRect, this.orientation) : color;
            } else if (this.pattern != 1 || this.hiFillPaint == null) {
                this.hiFillPaint = this.pattern == 11 ? this.makeFillPaint(this.buffImage, color, this.anchorRect, this.orientation) : this.makeFillPaint(this.makeBufferedImage(color), color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.hiFillPaint);
        }
        return true;
    }

    public boolean updateGraphicsToShadow(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Color color = JCNumberUtil.darker(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                this.shFillPaint = this.customPaint != null ? this.makeFillPaint(this.customPaint.getImage(), color, this.anchorRect, this.orientation) : color;
            } else if (this.pattern != 1 || this.shFillPaint == null) {
                this.shFillPaint = this.pattern == 11 ? this.makeFillPaint(this.buffImage, color, this.anchorRect, this.orientation) : this.makeFillPaint(this.makeBufferedImage(color), color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.shFillPaint);
        }
        return true;
    }
}

