/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dNumberFormat;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.ParentFormatter;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCNumberUtil;

public class JCContourLevels
extends ParentFormatter {
    protected boolean isDefault = true;
    protected double[] levels = null;
    protected int numLevels = 10;
    protected double min = Double.MAX_VALUE;
    protected double max = Double.MAX_VALUE;

    public JCContourLevels() {
    }

    public JCContourLevels(int n2) {
        this.numLevels = n2;
    }

    public JCContourLevels(double[] dArray) {
        this.levels = dArray;
        this.numLevels = dArray == null ? 0 : dArray.length;
        this.isDefault = false;
    }

    public void addLevel(double d2) {
        this.isDefault = false;
        int n2 = Math.min(this.levels == null ? 0 : this.levels.length, this.numLevels);
        double[] dArray = new double[n2 + 1];
        int n3 = 0;
        while (n3 < n2 && this.levels[n3] < d2) {
            dArray[n3] = this.levels[n3];
            ++n3;
        }
        int n4 = n3;
        if (this.levels != null && this.levels[n3] != d2) {
            dArray[n4++] = d2;
        }
        while (n3 < n2) {
            dArray[n4++] = this.levels[n3];
            ++n3;
        }
        this.levels = dArray;
        this.numLevels = n4;
        this.callParentSetChanged(true, 290);
    }

    protected void calcLevels() {
        if (!this.isDefault) {
            this.numLevels = this.levels == null ? 0 : this.levels.length;
            return;
        }
        this.levels = null;
        if (this.numLevels == 0) {
            return;
        }
        if (this.min == this.max) {
            this.numLevels = 0;
            return;
        }
        this.levels = new double[this.numLevels];
        double d2 = (this.max - this.min) / (double)(this.numLevels + 1);
        int n2 = 0;
        n2 = 1.0 + d2 == 1.0 ? (this.min == 0.0 ? JCChart3dUtil.nDigits(this.max) : JCChart3dUtil.nDigits(this.min)) : JCChart3dUtil.nDigits(d2);
        this.setNFrac(Math.max(0, n2 + 1));
        int n3 = 0;
        while (n3 < this.numLevels) {
            this.levels[n3] = this.min + (double)(n3 + 1) * d2;
            String string = JCNumberUtil.format(this.levels[n3], this.getNFrac());
            JCChart3dNumberFormat jCChart3dNumberFormat = this.getNumberFormatter();
            String string2 = jCChart3dNumberFormat.localize(string);
            this.levels[n3] = Double.valueOf(string2);
            ++n3;
        }
    }

    protected void calcLimits(Chart3dDataView chart3dDataView, Chart3dGridData chart3dGridData, Chart3dGridData chart3dGridData2) {
        if (chart3dDataView == null || chart3dGridData == null || chart3dGridData2 == null) {
            JCDebug.println("contourLevels", "calcLimits: Unexpected null pointer");
            return;
        }
        if (chart3dGridData2.isDataOK()) {
            chart3dGridData2.computeZLimits(chart3dGridData, this.min, this.max);
            this.min = chart3dGridData2.getDataMin();
            this.max = chart3dGridData2.getDataMax();
        } else {
            this.min = chart3dGridData.getDataMin();
            this.max = chart3dGridData.getDataMax();
            if (chart3dDataView.getChartType() == 1) {
                JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
                double d2 = jCChart3dArea.getAxis(3).getOrigin();
                this.min = Math.min(this.min, d2);
                this.max = Math.max(this.max, d2);
            }
        }
        JCDebug.println("contourLevels", "Contour Min:" + this.min);
        JCDebug.println("contourLevels", "Contour Max:" + this.max);
    }

    public int getLevelFromValue(double d2) {
        int n2 = 0;
        while (n2 < this.numLevels) {
            if (d2 <= this.levels[n2]) break;
            ++n2;
        }
        return n2;
    }

    public double[] getLevels() {
        if (this.levels == null) {
            if (this.min == Double.MAX_VALUE) {
                Chart3dDataView chart3dDataView = (Chart3dDataView)this.parents.get(0);
                chart3dDataView.calcDefaults();
            }
            if (this.isDefault && this.levels == null) {
                this.numLevels = 0;
            }
        }
        return this.levels;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void removeLevel(double d2) {
        int n2 = Math.min(this.levels == null ? 0 : this.levels.length, this.numLevels);
        if (n2 == 0) {
            return;
        }
        double d3 = Double.MAX_VALUE;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            double d4 = Math.abs(this.levels[n4] - d2);
            if (d4 < d3) {
                d3 = d4;
                n3 = n4;
            }
            ++n4;
        }
        if (n3 >= 0) {
            this.removeLevel(n3);
        }
    }

    public void removeLevel(int n2) {
        int n3 = Math.min(this.levels == null ? 0 : this.levels.length, this.numLevels);
        if (n3 == 0 || n2 < 0 || n2 > n3 - 1) {
            return;
        }
        this.isDefault = false;
        if (n3 <= 1) {
            this.levels = null;
            this.numLevels = 0;
            return;
        }
        double[] dArray = new double[n3 - 1];
        int n4 = 0;
        while (n4 < n3 - 1) {
            dArray[n4] = n4 < n2 ? this.levels[n4] : this.levels[n4 + 1];
            ++n4;
        }
        this.levels = dArray;
        this.numLevels = n3 - 1;
        this.callParentSetChanged(true, 290);
    }

    public void setDefault(boolean bl) {
        if (this.isDefault == bl) {
            return;
        }
        this.isDefault = bl;
        this.callParentSetChanged(true, 290);
    }

    public void setLevels(double[] dArray) {
        if (this.levels == dArray) {
            return;
        }
        this.levels = dArray;
        this.numLevels = dArray == null ? 0 : dArray.length;
        this.isDefault = false;
        int n2 = 0;
        if (dArray != null) {
            int n3 = 0;
            while (n3 < dArray.length) {
                n2 = Math.max(JCChart3dUtil.nDigits(dArray[n3]), n2);
                ++n3;
            }
        }
        this.setNFrac(Math.max(0, n2 + 1));
        this.callParentSetChanged(true, 290);
    }

    public void setNumLevels(int n2) {
        if (this.numLevels == n2) {
            return;
        }
        if (this.isDefault) {
            this.numLevels = Math.max(0, n2);
            this.callParentSetChanged(true, 290);
        }
    }
}

