/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.CellSide;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.ColorBin;
import com.klg.jclass.chart3d.ContourCell;
import com.klg.jclass.chart3d.ContourLine;
import com.klg.jclass.chart3d.ContourSegment;
import com.klg.jclass.chart3d.DefaultColors;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.Intersection;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourMapping;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCProjection;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.chart3d.PolygonChain;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.data.JCDefault3dPointDataSource;
import com.klg.jclass.util.JCDebug;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class JCContour
extends ParentTrackChange
implements JCContourMapping {
    public static final int ZONE_CONTOURS = 1;
    public static final int ZONE_CELLS_AVERAGE = 2;
    public static final int ZONE_CELLS_CORNER = 3;
    protected static final int CYCLE_CLOCKWISE = 0;
    protected static final int CYCLE_COUNTER_CLOCKWISE = 1;
    protected static final int LEFT_EDGE = 1;
    protected static final int RIGHT_EDGE = 2;
    protected static final int BOTTOM_EDGE = 4;
    protected static final int TOP_EDGE = 8;
    protected static final int BOTTOM_LEFT_CORNER = 5;
    protected static final int TOP_LEFT_CORNER = 9;
    protected static final int TOP_RIGHT_CORNER = 10;
    protected static final int BOTTOM_RIGHT_CORNER = 6;
    protected boolean contoured = false;
    protected boolean zoned = false;
    protected int zoneMethod = 1;
    protected JCContourLevels contourLevels = null;
    protected ArrayList contourStyles = null;
    protected JCContourMapping contourMapping = this;
    protected Chart3dDataView dataView = null;
    protected DefaultColors defaultColors = new DefaultColors();
    protected Chart3dGridData data = null;
    protected Chart3dGridData zoneData = null;
    protected int xOffset = -1;
    protected int yOffset = -1;
    protected int numX = -1;
    protected int numY = -1;
    protected double dataHoleValue = Double.MAX_VALUE;
    protected double zoneHoleValue = Double.MAX_VALUE;
    protected ArrayList contourLines = null;
    protected ContourCell[] contourCells = null;
    protected ColorBin[] bins = null;
    protected PolygonChain[] fixedChain = null;
    protected PolygonChain freeList = null;
    protected int pCount = 0;
    protected CellSide[] sides = null;
    protected int nHorizontalSides = 0;
    protected int nVerticalSides = 0;
    protected int firstIndex = 0;
    protected ContourSegment curSegment = null;
    protected int[] xPoints = null;
    protected int[] yPoints = null;

    public JCContour() {
        this.defaultContourStyles();
    }

    public JCContour(Chart3dDataView chart3dDataView) {
        this();
        this.dataView = chart3dDataView;
        this.addParent(chart3dDataView);
    }

    protected void addContourCell(int n2, int n3, int n4, int n5) {
        ContourCell contourCell = this.contourCells[this.cellIndex(n2, n3)];
        contourCell.setNewIntersection(new Intersection(n4, n5, this.curSegment));
    }

    protected void addPoint(int n2, int n3, double d2, double d3) {
        int n4 = this.contourLines.size();
        ContourLine contourLine = (ContourLine)this.contourLines.get(n4 - 1);
        this.curSegment = new ContourSegment();
        contourLine.addContourSegment(this.curSegment);
        double[] dArray = this.contourLevels.getLevels();
        Point3d point3d = new Point3d();
        point3d.x = d2;
        point3d.y = d3;
        if (this.zoneData == this.data) {
            point3d.z = dArray[contourLine.getLevel()];
        } else {
            double d4 = this.data.getX(n2 += this.xOffset);
            double d5 = this.data.getY(n3 += this.yOffset);
            double d6 = this.data.getZValue(n2, n3);
            double d7 = d4;
            double d8 = this.data.getY(n3 + 1);
            double d9 = this.data.getZValue(n2, n3 + 1);
            double d10 = this.data.getX(n2 + 1);
            double d11 = d8;
            double d12 = this.data.getZValue(n2 + 1, n3 + 1);
            double d13 = d10;
            double d14 = d5;
            double d15 = this.data.getZValue(n2 + 1, n3);
            if (d2 == d4) {
                point3d.z = d6 == this.dataHoleValue || d9 == this.dataHoleValue ? this.dataHoleValue : this.interp(d5, d8, d6, d9, d3);
            } else if (d2 == d10) {
                point3d.z = d12 == this.dataHoleValue || d15 == this.dataHoleValue ? this.dataHoleValue : this.interp(d11, d14, d12, d15, d3);
            } else if (d3 == d5) {
                point3d.z = d6 == this.dataHoleValue || d15 == this.dataHoleValue ? this.dataHoleValue : this.interp(d4, d13, d6, d15, d2);
            } else if (d3 == d8) {
                point3d.z = d9 == this.dataHoleValue || d12 == this.dataHoleValue ? this.dataHoleValue : this.interp(d7, d10, d9, d12, d2);
            } else if (d6 == this.dataHoleValue || d9 == this.dataHoleValue || d12 == this.dataHoleValue || d15 == this.dataHoleValue) {
                point3d.z = this.dataHoleValue;
            } else {
                double d16 = this.interp(d5, d8, d6, d9, d3);
                double d17 = this.interp(d11, d14, d12, d15, d3);
                double d18 = this.interp(d4, d13, d16, d17, d2);
                d16 = this.interp(d4, d13, d6, d15, d2);
                d17 = this.interp(d7, d10, d9, d12, d2);
                double d19 = this.interp(d5, d8, d16, d17, d3);
                point3d.z = (d18 + d19) / 2.0;
            }
        }
        this.curSegment.setPoint(point3d);
    }

    protected void allocColorBins(Graphics graphics) {
        int n2 = this.contourLevels.getNumLevels() + 1;
        this.bins = new ColorBin[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.bins[n3] = new ColorBin(this, graphics, n3);
            ++n3;
        }
    }

    protected void allocatePoints(int n2) {
        if (this.xPoints == null || this.xPoints.length < n2) {
            this.xPoints = new int[n2];
            this.yPoints = new int[n2];
        }
    }

    protected PolygonChain appendChain(PolygonChain polygonChain, PolygonChain polygonChain2) {
        if (polygonChain == null) {
            return polygonChain2;
        }
        if (polygonChain2 == null) {
            return polygonChain;
        }
        PolygonChain polygonChain3 = polygonChain;
        while (polygonChain.getNext() != null) {
            polygonChain = polygonChain.getNext();
        }
        polygonChain.setNext(polygonChain2);
        return polygonChain3;
    }

    protected boolean avail(int n2, int n3, int n4, int n5, double d2, double d3) {
        int n6 = this.getSide(n2, n3, n4);
        if (n6 == this.firstIndex) {
            return true;
        }
        double[] dArray = this.contourLevels.getLevels();
        double d4 = dArray[n5];
        return !this.sides[n6].isUsed(n5) && (d2 - d4) * (d3 - d4) <= 0.0;
    }

    protected int bottomSide(int n2, int n3) {
        return this.nVerticalSides + n2 * this.numY + n3;
    }

    public void calcContours() {
        int n2;
        int n3;
        this.destroyContours();
        if (this.dataView == null) {
            JCDebug.println("contour", "calcContours: dataView is null");
            return;
        }
        this.setInternalValues();
        if (!this.data.isDataOK()) {
            return;
        }
        if (this.dataView.getChartType() != 0) {
            return;
        }
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCProjection jCProjection = jCChart3dArea.getPlotCube().getFloor();
        JCProjection jCProjection2 = jCChart3dArea.getPlotCube().getCeiling();
        boolean bl = this.contoured || jCProjection.isContoured() || jCProjection2.isContoured();
        boolean bl2 = this.zoned || jCProjection.isZoned() || jCProjection2.isZoned();
        boolean bl3 = bl || bl2 && this.zoneMethod == 1;
        int n4 = this.contourLevels.getNumLevels();
        double[] dArray = this.contourLevels.getLevels();
        if (bl3) {
            this.nVerticalSides = (this.numY - 1) * this.numX;
            this.nHorizontalSides = (this.numX - 1) * this.numY;
            this.sides = new CellSide[this.nVerticalSides + this.nHorizontalSides];
            n3 = 0;
            while (n3 < this.nVerticalSides + this.nHorizontalSides) {
                this.sides[n3] = new CellSide(n4);
                ++n3;
            }
        }
        this.contourCells = new ContourCell[(this.numX - 1) * (this.numY - 1)];
        n3 = 0;
        while (n3 < this.contourCells.length) {
            this.contourCells[n3] = new ContourCell();
            ++n3;
        }
        int n5 = 0;
        int n6 = this.numX - 1;
        int n7 = 0;
        int n8 = this.numY - 1;
        int n9 = n7;
        while (n9 <= n8) {
            double d2;
            double d3 = d2 = this.zoneData.getZValue(this.xOffset + n5, this.yOffset + n9);
            n2 = n5;
            while (n2 <= n6) {
                if (n2 != n6) {
                    d3 = this.zoneData.getZValue(this.xOffset + n2 + 1, this.yOffset + n9);
                }
                if (d2 != this.zoneHoleValue) {
                    int n10;
                    int n11;
                    int n12;
                    double d4;
                    double d5;
                    if (n2 != n6 && bl3 && d3 != this.zoneHoleValue) {
                        if (d2 <= d3) {
                            d5 = d2;
                            d4 = d3;
                            n12 = 1;
                        } else {
                            d5 = d3;
                            d4 = d2;
                            n12 = 0;
                        }
                        n11 = this.bottomSide(n2, n9);
                        n10 = 0;
                        while (n10 < n4 && dArray[n10] < d5) {
                            ++n10;
                        }
                        while (n10 < n4 && dArray[n10] < d4) {
                            if (!this.sides[n11].isUsed(n10)) {
                                this.firstIndex = n11;
                                this.contour(n12, n2, n9, n10, 3);
                                if (!this.sides[n11].isUsed(n10)) {
                                    this.contour(1 - n12, n2, n9 - 1, n10, 1);
                                }
                            }
                            ++n10;
                        }
                    }
                    if (n9 != n8 && bl3) {
                        double d6 = d2;
                        double d7 = this.zoneData.getZValue(this.xOffset + n2, this.yOffset + n9 + 1);
                        if (d7 != this.zoneHoleValue) {
                            if (d6 <= d7) {
                                d5 = d6;
                                d4 = d7;
                                n12 = 0;
                            } else {
                                d5 = d7;
                                d4 = d6;
                                n12 = 1;
                            }
                            n11 = this.leftSide(n2, n9);
                            n10 = 0;
                            while (n10 < n4 && dArray[n10] < d5) {
                                ++n10;
                            }
                            while (n10 < n4 && dArray[n10] < d4) {
                                if (!this.sides[n11].isUsed(n10)) {
                                    this.firstIndex = n11;
                                    this.contour(n12, n2, n9, n10, 2);
                                    if (!this.sides[n11].isUsed(n10)) {
                                        this.contour(1 - n12, n2 - 1, n9, n10, 0);
                                    }
                                }
                                ++n10;
                            }
                        }
                    }
                } else {
                    this.setContourCellHole(n2, n9);
                }
                d2 = d3;
                ++n2;
            }
            ++n9;
        }
        if (bl3) {
            n2 = 0;
            while (n2 < this.contourCells.length) {
                this.contourCells[n2].sortIntersectionLists();
                ++n2;
            }
        }
        this.nVerticalSides = 0;
        this.nHorizontalSides = 0;
        this.sides = null;
    }

    protected int cellIndex(int n2, int n3) {
        return n2 * (this.numY - 1) + n3;
    }

    /*
     * Unable to fully structure code
     */
    protected void contour(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        var7_6 = new Integer[4];
        var12_7 = new Point3d[4];
        var6_8 = 0;
        while (var6_8 < var12_7.length) {
            var12_7[var6_8] = new Point3d();
            ++var6_8;
        }
        var13_9 = false;
        var14_10 = true;
        block7: while (!var13_9) {
            if (var2_2 < 0 || var3_3 < 0 || var2_2 >= this.numX - 1 || var3_3 >= this.numY - 1) break;
            var15_13 = this.xOffset + var2_2;
            var16_14 = this.yOffset + var3_3;
            var12_7[3].z = this.zoneData.getZValue(var15_13, var16_14);
            var12_7[0].z = this.zoneData.getZValue(var15_13 + 1, var16_14);
            var12_7[1].z = this.zoneData.getZValue(var15_13 + 1, var16_14 + 1);
            var12_7[2].z = this.zoneData.getZValue(var15_13, var16_14 + 1);
            if (var12_7[0].z == this.zoneHoleValue || var12_7[1].z == this.zoneHoleValue || var12_7[2].z == this.zoneHoleValue || var12_7[3].z == this.zoneHoleValue) break;
            var12_7[2].x = var12_7[3].x = this.zoneData.getX(var15_13);
            var12_7[0].y = var12_7[3].y = this.zoneData.getY(var16_14);
            var12_7[0].x = var12_7[1].x = this.zoneData.getX(var15_13 + 1);
            var12_7[2].y = var12_7[1].y = this.zoneData.getY(var16_14 + 1);
            var6_8 = 0;
            while (var6_8 < var7_6.length) {
                var7_6[var6_8] = new Integer(var6_8);
                ++var6_8;
            }
            this.cycleArray(var12_7, 3 - var5_5);
            this.cycleArray(var7_6, 3 - var5_5);
            if (var1_1 == 0) {
                this.reverseArray(var12_7, 4);
                this.reverseArray(var7_6, 3);
            }
            if (var14_10) {
                this.startContour(var2_2, var3_3, var4_4, (Point3d)var12_7[3], (Point3d)var12_7[0]);
                var14_10 = false;
            }
            var6_8 = 0;
            while (var6_8 < 3) {
                block14: {
                    block15: {
                        var17_15 = var7_6[var6_8].intValue();
                        if (!this.avail(var2_2, var3_3, var17_15, var4_4, var12_7[var6_8].z, var12_7[var6_8 + 1].z)) break block14;
                        this.addContourCell(var2_2, var3_3, var4_4, var5_5);
                        if (var12_7[var6_8].z == var12_7[var6_8 + 1].z) {
                            var8_11 = (var12_7[var6_8 + 1].x + var12_7[var6_8].x) / 2.0;
                            var10_12 = (var12_7[var6_8 + 1].y + var12_7[var6_8].y) / 2.0;
                        } else {
                            var18_17 = this.contourLevels.getLevels();
                            var19_18 = var18_17[var4_4];
                            var8_11 = var12_7[var6_8 + 1].x * (var19_18 - var12_7[var6_8].z) - var12_7[var6_8].x * (var19_18 - var12_7[var6_8 + 1].z);
                            var10_12 = var12_7[var6_8 + 1].y * (var19_18 - var12_7[var6_8].z) - var12_7[var6_8].y * (var19_18 - var12_7[var6_8 + 1].z);
                            var8_11 /= var12_7[var6_8 + 1].z - var12_7[var6_8].z;
                            var10_12 /= var12_7[var6_8 + 1].z - var12_7[var6_8].z;
                        }
                        this.addPoint(var2_2, var3_3, var8_11, var10_12);
                        this.modifyContourCell(var2_2, var3_3, var17_15);
                        var18_16 = this.getSide(var2_2, var3_3, var17_15);
                        this.sides[var18_16].setUsed(var4_4);
                        if (var18_16 == this.firstIndex) break block15;
                        switch (var17_15) {
                            case 0: {
                                ++var2_2;
                                var5_5 = 2;
                                ** GOTO lbl81
                            }
                            case 1: {
                                ++var3_3;
                                var5_5 = 3;
                                ** GOTO lbl81
                            }
                            case 2: {
                                --var2_2;
                                var5_5 = 0;
                                ** GOTO lbl81
                            }
                            case 3: {
                                --var3_3;
                                var5_5 = 1;
                                ** GOTO lbl81
                            }
                            default: {
                                if (var6_8 != 3) continue block7;
                            }
                        }
                    }
                    var13_9 = true;
                    break;
                }
                ++var6_8;
            }
lbl81:
            // 6 sources

            if (var6_8 != 3) continue;
            var13_9 = true;
        }
        this.curSegment = null;
    }

    public int contourIndex(int n2) {
        int n3 = this.contourLevels.getNumLevels();
        int n4 = 0;
        if (n3 > 0) {
            double d2 = n2 * (this.contourStyles.size() - 1);
            n4 = (int)Math.round(d2 /= (double)n3);
        }
        return n4;
    }

    protected PolygonChain copyChain(PolygonChain polygonChain) {
        PolygonChain polygonChain2 = null;
        if (polygonChain != null) {
            PolygonChain polygonChain3 = polygonChain2 = this.makePChain(polygonChain.getXPixel(), polygonChain.getYPixel(), polygonChain.getZValue(), polygonChain.getCValue());
            PolygonChain polygonChain4 = polygonChain.getNext();
            while (polygonChain4 != null) {
                polygonChain3.setNext(this.makePChain(polygonChain4.getXPixel(), polygonChain4.getYPixel(), polygonChain4.getZValue(), polygonChain4.getCValue()));
                polygonChain3 = polygonChain3.getNext();
                polygonChain4 = polygonChain4.getNext();
            }
        }
        return polygonChain2;
    }

    protected void cycleArray(Object[] objectArray, int n2) {
        if (objectArray.length < 4) {
            JCDebug.println("contour", "cycleArray: Bad length of array");
            return;
        }
        int n3 = 0;
        while (n3 < n2 % 4) {
            Object object = objectArray[3];
            objectArray[3] = objectArray[2];
            objectArray[2] = objectArray[1];
            objectArray[1] = objectArray[0];
            objectArray[0] = object;
            ++n3;
        }
    }

    protected void defaultContourStyles() {
        this.contourStyles = new ArrayList();
        int n2 = 0;
        while (n2 < this.defaultColors.getNumColors()) {
            this.contourStyles.add(new JCContourStyle(this.defaultColors.getColor(n2)));
            ++n2;
        }
    }

    protected void destroyChain(PolygonChain polygonChain) {
        if (polygonChain == null) {
            JCDebug.println("contour", "destroyChain: null chain passed in!");
        }
        PolygonChain polygonChain2 = polygonChain;
        PolygonChain polygonChain3 = null;
        while (polygonChain != null) {
            polygonChain3 = polygonChain;
            polygonChain = polygonChain3.getNext();
            --this.pCount;
        }
        polygonChain3.setNext(this.freeList);
        this.freeList = polygonChain2;
    }

    public void destroyContours() {
        this.contourLines = null;
        this.contourCells = null;
    }

    protected void draw2dZones(Graphics graphics) {
        if (!this.zoned || this.contourCells == null || this.dataView == null) {
            return;
        }
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCViewport jCViewport = jCChart3dArea.getViewport();
        boolean[] blArray = new boolean[this.numX - 1];
        int n2 = 0;
        while (n2 < this.numX - 1) {
            blArray[n2] = screenPointArray[this.xOffset + n2 + 1][this.yOffset].getXPixel() == screenPointArray[this.xOffset + n2][this.yOffset].getXPixel();
            ++n2;
        }
        boolean[] blArray2 = new boolean[this.numY - 1];
        int n3 = 0;
        while (n3 < this.numY - 1) {
            blArray2[n3] = screenPointArray[this.xOffset][this.yOffset + n3 + 1].getYPixel() == screenPointArray[this.xOffset][this.yOffset + n3].getYPixel();
            ++n3;
        }
        this.allocColorBins(graphics);
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numX - 1) {
            if (blArray[n5]) {
                n4 += this.numY - 1;
            } else {
                int n6 = 0;
                while (n6 < this.numY - 1) {
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    Rectangle rectangle;
                    if (!blArray2[n6] && (jCViewport.isNormalized() || (rectangle = new Rectangle(n12 = screenPointArray[n11 = this.xOffset + n5][n10 = this.yOffset + n6].getXPixel(), n9 = screenPointArray[n11][n10 + 1].getYPixel(), n8 = screenPointArray[n11 + 1][n10].getXPixel() - n12, n7 = screenPointArray[n11][n10].getYPixel() - n9)).intersects(jCChart3dArea.getBounds()))) {
                        if (this.zoneMethod == 1) {
                            ContourCell contourCell = this.contourCells[n4];
                            if (contourCell.getNIntersections() == 0) {
                                if (!contourCell.isHole()) {
                                    this.fillRectangle(n5, n6, false);
                                }
                            } else {
                                this.fillCell(graphics, n5, n6);
                            }
                        } else {
                            this.fillRectangle(n5, n6, this.zoneMethod == 2);
                        }
                    }
                    ++n6;
                    ++n4;
                }
            }
            ++n5;
        }
        this.flushColorBins();
        this.bins = null;
    }

    protected void draw3dZones(Graphics graphics) {
        if (!this.zoned || this.contourCells == null || this.dataView == null) {
            return;
        }
        this.allocColorBins(graphics);
        ScreenPoint[] screenPointArray = new ScreenPoint[4];
        ScreenPoint[][] screenPointArray2 = this.data.getScreenPoints();
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCViewport jCViewport = jCChart3dArea.getViewport();
        int n2 = 0;
        while (n2 < this.numX - 1) {
            int n3 = 0;
            while (n3 < this.numY - 1) {
                block7: {
                    block6: {
                        int n4;
                        int n5;
                        int n6;
                        if (jCViewport.isNormalized()) break block6;
                        int n7 = this.xOffset + n2;
                        int n8 = this.yOffset + n3;
                        screenPointArray[0] = screenPointArray2[n7][n8];
                        screenPointArray[1] = screenPointArray2[n7][n8 + 1];
                        screenPointArray[2] = screenPointArray2[n7 + 1][n8 + 1];
                        screenPointArray[3] = screenPointArray2[n7 + 1][n8];
                        int n9 = JCChart3dUtil.min4(screenPointArray[0].getXPixel(), screenPointArray[1].getXPixel(), screenPointArray[2].getXPixel(), screenPointArray[3].getXPixel());
                        Rectangle rectangle = new Rectangle(n9, n6 = JCChart3dUtil.min4(screenPointArray[0].getYPixel(), screenPointArray[1].getYPixel(), screenPointArray[2].getYPixel(), screenPointArray[3].getYPixel()), (n5 = JCChart3dUtil.max4(screenPointArray[0].getXPixel(), screenPointArray[1].getXPixel(), screenPointArray[2].getXPixel(), screenPointArray[3].getXPixel())) - n9, (n4 = JCChart3dUtil.max4(screenPointArray[0].getYPixel(), screenPointArray[1].getYPixel(), screenPointArray[2].getYPixel(), screenPointArray[3].getYPixel())) - n6);
                        if (!rectangle.intersects(jCChart3dArea.getBounds())) break block7;
                    }
                    this.fillCell(graphics, n2, n3);
                }
                ++n3;
            }
            ++n2;
        }
        this.flushColorBins();
        this.bins = null;
    }

    protected void drawCellContours(Graphics graphics, int n2, int n3) {
        int n4 = this.cellIndex(n2, n3);
        ContourCell contourCell = this.contourCells[n4];
        int n5 = 0;
        while (n5 < 5) {
            ArrayList arrayList = contourCell.getIntersectionList(n5);
            if (arrayList != null) {
                int n6 = 0;
                while (n6 < arrayList.size()) {
                    Intersection intersection = (Intersection)arrayList.get(n6);
                    this.setLineStyle(graphics, intersection.getLevel());
                    graphics.drawLine(intersection.getSegment1().getXPixel(), intersection.getSegment1().getYPixel(), intersection.getSegment2().getXPixel(), intersection.getSegment2().getYPixel());
                    ++n6;
                }
            }
            ++n5;
        }
    }

    protected void drawContours(Graphics graphics) {
        if (!this.contoured || this.contourLines == null) {
            return;
        }
        int n2 = 300;
        this.allocatePoints(n2);
        ListIterator listIterator = ((AbstractList)this.contourLines).listIterator();
        while (listIterator.hasNext()) {
            ContourLine contourLine = (ContourLine)listIterator.next();
            if (!this.setLineStyle(graphics, contourLine.getLevel())) continue;
            LinkedList linkedList = contourLine.getSegments();
            ListIterator listIterator2 = linkedList.listIterator();
            while (listIterator2.hasNext()) {
                int n3 = 0;
                while (n3 < n2 && listIterator2.hasNext()) {
                    ContourSegment contourSegment = (ContourSegment)listIterator2.next();
                    this.xPoints[n3] = contourSegment.getXPixel();
                    this.yPoints[n3] = contourSegment.getYPixel();
                    ++n3;
                }
                graphics.drawPolyline(this.xPoints, this.yPoints, n3);
            }
        }
        this.yPoints = null;
        this.xPoints = null;
    }

    protected boolean fillCell(Graphics graphics, int n2, int n3) {
        Serializable serializable;
        Serializable serializable2;
        int n4 = this.cellIndex(n2, n3);
        ContourCell contourCell = this.contourCells[n4];
        if (contourCell.isHole()) {
            return false;
        }
        int n5 = this.xOffset + n2;
        int n6 = this.yOffset + n3;
        int n7 = n5 + 1;
        int n8 = n6 + 1;
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        PolygonChain[] polygonChainArray = new PolygonChain[]{this.makePChain(screenPointArray[n7][n6].getXPixel(), screenPointArray[n7][n6].getYPixel(), this.data.getZValue(n7, n6), this.zoneData.getZValue(n7, n6)), this.makePChain(screenPointArray[n7][n8].getXPixel(), screenPointArray[n7][n8].getYPixel(), this.data.getZValue(n7, n8), this.zoneData.getZValue(n7, n8)), this.makePChain(screenPointArray[n5][n8].getXPixel(), screenPointArray[n5][n8].getYPixel(), this.data.getZValue(n5, n8), this.zoneData.getZValue(n5, n8)), this.makePChain(screenPointArray[n5][n6].getXPixel(), screenPointArray[n5][n6].getYPixel(), this.data.getZValue(n5, n6), this.zoneData.getZValue(n5, n6))};
        if (this.zoneMethod == 1) {
            this.fillCellCorners(graphics, polygonChainArray, n4);
            serializable2 = contourCell.getIntersectionList(4);
            if (serializable2 != null && ((ArrayList)serializable2).size() > 0) {
                serializable = (Intersection)((ArrayList)serializable2).get(0);
                if (this.verticalSide(((Intersection)serializable).getSide1())) {
                    this.fillCellSide(graphics, polygonChainArray, 3, 0, n4);
                } else {
                    this.fillCellSide(graphics, polygonChainArray, 0, 1, n4);
                }
            }
        }
        serializable2 = this.appendChain(polygonChainArray[2], polygonChainArray[3]);
        serializable = this.appendChain(polygonChainArray[0], polygonChainArray[1]);
        serializable2 = this.appendChain((PolygonChain)serializable2, (PolygonChain)serializable);
        this.fillChain(graphics, (PolygonChain)serializable2);
        this.destroyChain((PolygonChain)serializable2);
        if (this.pCount != 0) {
            JCDebug.println("contour", "fillCell: Bad polygon count!");
        }
        return true;
    }

    protected void fillCellCorners(Graphics graphics, PolygonChain[] polygonChainArray, int n2) {
        double[] dArray = this.contourLevels.getLevels();
        ContourCell contourCell = this.contourCells[n2];
        int n3 = 0;
        while (n3 < 4) {
            ArrayList arrayList = contourCell.getIntersectionList(n3);
            if (arrayList != null) {
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    Intersection intersection = (Intersection)arrayList.get(n4);
                    ContourSegment contourSegment = intersection.getSegment1();
                    PolygonChain polygonChain = this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]);
                    contourSegment = intersection.getSegment2();
                    polygonChain.setNext(this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]));
                    PolygonChain polygonChain2 = this.appendChain(this.reverseChain(polygonChainArray[n3]), this.copyChain(polygonChain));
                    this.fillChain(graphics, polygonChain2);
                    this.destroyChain(polygonChain2);
                    polygonChainArray[n3] = polygonChain;
                    ++n4;
                }
            }
            ++n3;
        }
    }

    protected void fillCellSide(Graphics graphics, PolygonChain[] polygonChainArray, int n2, int n3, int n4) {
        double[] dArray = this.contourLevels.getLevels();
        ContourCell contourCell = this.contourCells[n4];
        ArrayList arrayList = contourCell.getIntersectionList(4);
        if (arrayList == null) {
            return;
        }
        int n5 = 0;
        while (n5 < arrayList.size()) {
            Intersection intersection = (Intersection)arrayList.get(n5);
            ContourSegment contourSegment = intersection.getSegment1();
            PolygonChain polygonChain = this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]);
            contourSegment = intersection.getSegment2();
            PolygonChain polygonChain2 = this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]);
            PolygonChain polygonChain3 = this.appendChain(this.copyChain(polygonChain2), this.copyChain(polygonChain));
            PolygonChain polygonChain4 = this.appendChain(polygonChainArray[n2], polygonChainArray[n3]);
            polygonChain3 = this.appendChain(polygonChain3, polygonChain4);
            this.fillChain(graphics, polygonChain3);
            this.destroyChain(polygonChain3);
            polygonChainArray[n2] = polygonChain;
            polygonChainArray[n3] = polygonChain2;
            ++n5;
        }
    }

    protected void fillChain(Graphics graphics, PolygonChain polygonChain) {
        this.allocatePoints(9);
        int n2 = 0;
        double d2 = 0.0;
        PolygonChain polygonChain2 = polygonChain;
        while (polygonChain2 != null) {
            this.xPoints[n2] = polygonChain2.getXPixel();
            this.yPoints[n2] = polygonChain2.getYPixel();
            if (this.zoneMethod == 3) {
                if (n2 == 1) {
                    d2 = polygonChain2.getCValue();
                }
            } else {
                d2 += polygonChain2.getCValue();
            }
            ++n2;
            polygonChain2 = polygonChain2.getNext();
        }
        Transform transform = this.dataView.getChart3d().getChart3dArea().getTransform();
        if (n2 > 2) {
            double d3 = this.zoneMethod == 3 ? d2 : d2 / (double)n2;
            int n3 = this.contourLevels.getLevelFromValue(d3);
            Matrix4d matrix4d = transform.getAbsolute();
            if (matrix4d.m22 != 0.0) {
                this.setFillStyle(graphics, n3);
                graphics.fillPolygon(this.xPoints, this.yPoints, n2);
            } else {
                this.bins[n3].addObjectToBin(new Polygon(this.xPoints, this.yPoints, n2));
            }
        }
    }

    protected void fillRectangle(int n2, int n3, boolean bl) {
        int n4 = n2 + this.xOffset;
        int n5 = n3 + this.yOffset;
        double d2 = 0.0;
        d2 = bl ? (this.zoneData.getZValue(n4, n5) + this.zoneData.getZValue(n4 + 1, n5) + this.zoneData.getZValue(n4, n5 + 1) + this.zoneData.getZValue(n4 + 1, n5 + 1)) / 4.0 : this.zoneData.getZValue(n4, n5);
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        int n6 = screenPointArray[n4][n5].getXPixel();
        int n7 = screenPointArray[n4][n5 + 1].getYPixel();
        int n8 = screenPointArray[n4 + 1][n5].getXPixel() - n6;
        int n9 = screenPointArray[n4][n5].getYPixel() - n7;
        Rectangle rectangle = new Rectangle(n6, n7, n8, n9);
        int n10 = this.contourLevels.getLevelFromValue(d2);
        this.bins[n10].addObjectToBin(rectangle);
    }

    protected void flushColorBins() {
        if (this.bins == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.bins.length) {
            this.bins[n2].flushBin();
            ++n2;
        }
        this.bins = null;
    }

    public ContourCell[] getContourCells() {
        return this.contourCells;
    }

    public JCContourLevels getContourLevels() {
        return this.contourLevels;
    }

    public ArrayList getContourLines() {
        return this.contourLines;
    }

    public JCContourMapping getContourMapping() {
        return this.contourMapping;
    }

    public JCContourStyle getContourStyleFromLevel(int n2) {
        if (this.contourStyles == null || this.contourStyles.size() == 0) {
            return null;
        }
        int n3 = this.contourMapping.contourIndex(n2);
        JCContourStyle jCContourStyle = (JCContourStyle)this.contourStyles.get(n3);
        if (jCContourStyle == null) {
            return null;
        }
        jCContourStyle.initialize(this, n3);
        return jCContourStyle;
    }

    public ArrayList getContourStyles() {
        if (this.contourStyles == null) {
            JCDebug.println("contour", "getContourStyles: Contour styles are null!");
            this.defaultContourStyles();
            this.callParentSetChanged(true, 34);
        }
        return this.contourStyles;
    }

    public Chart3dPointDataModel getDataContours(int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        Point3d[][] point3dArray;
        if (this.contourLines == null) {
            this.recalcContours();
        }
        if (this.contourLines == null) {
            return null;
        }
        if (n2 > n3) {
            return null;
        }
        n4 = Math.max(1, n4);
        int n7 = Math.max(0, n2);
        int n8 = Math.min(this.getContourLevels().getNumLevels() - 1, n3);
        int[] nArray = new int[this.contourLines.size()];
        ListIterator listIterator = ((AbstractList)this.contourLines).listIterator();
        int n9 = 0;
        while (listIterator.hasNext()) {
            point3dArray = (Point3d[][])listIterator.next();
            n6 = point3dArray.getLevel();
            if (n6 < n7 || n6 > n8 || (n6 - n7) % n4 != 0) continue;
            boolean bl2 = false;
            if (bl) {
                n5 = 0;
                while (n5 < n9) {
                    if (nArray[n5] == n6) {
                        bl2 = true;
                    }
                    ++n5;
                }
            }
            if (bl2) continue;
            nArray[n9] = n6;
            ++n9;
        }
        if (n9 == 0) {
            return null;
        }
        point3dArray = new Point3d[n9][];
        listIterator = ((AbstractList)this.contourLines).listIterator();
        n6 = -1;
        while (listIterator.hasNext()) {
            int n10;
            Object object;
            ContourLine contourLine = (ContourLine)listIterator.next();
            n5 = contourLine.getLevel();
            if (n5 < n7 || n5 > n8 || (n5 - n7) % n4 != 0) continue;
            LinkedList linkedList = contourLine.getSegments();
            if (bl) {
                n6 = 0;
                while (n6 < n9) {
                    if (nArray[n6] == n5) break;
                    ++n6;
                }
                if (n6 == n9) {
                    return null;
                }
            } else {
                ++n6;
            }
            int n11 = 0;
            if (point3dArray[n6] == null || !bl) {
                point3dArray[n6] = new Point3d[linkedList.size()];
            } else {
                object = point3dArray[n6];
                point3dArray[n6] = new Point3d[((Point3d[])object).length + linkedList.size()];
                n10 = 0;
                while (n10 < ((Object)object).length) {
                    point3dArray[n6][n10] = object[n10];
                    ++n10;
                }
                n11 = ((Object)object).length;
            }
            object = linkedList.listIterator();
            n10 = n11;
            while (object.hasNext()) {
                ContourSegment contourSegment = (ContourSegment)object.next();
                point3dArray[n6][n10] = new Point3d(contourSegment.getPoint());
                ++n10;
            }
        }
        return new JCDefault3dPointDataSource("dataContours", point3dArray);
    }

    public Chart3dDataView getDataView() {
        return this.dataView;
    }

    protected DefaultColors getDefaultColors() {
        return this.defaultColors;
    }

    protected int getSide(int n2, int n3, int n4) {
        int n5 = this.verticalSide(n4) ? this.rightSide(n2, n3) - n4 / 2 : this.topSide(n2, n3) - n4 / 2;
        return n5;
    }

    public int getZoneMethod() {
        return this.zoneMethod;
    }

    protected boolean horizontalSide(int n2) {
        return n2 % 2 == 1;
    }

    protected double interp(double d2, double d3, double d4, double d5, double d6) {
        if (d2 == d3) {
            return d4;
        }
        return d4 + (d6 - d2) * (d5 - d4) / (d3 - d2);
    }

    public boolean isContoured() {
        return this.contoured;
    }

    public boolean isZoned() {
        return this.zoned;
    }

    protected int leftSide(int n2, int n3) {
        return n3 * this.numX + n2;
    }

    protected PolygonChain makePChain(int n2, int n3, double d2, double d3) {
        PolygonChain polygonChain;
        if (this.fixedChain == null) {
            this.fixedChain = new PolygonChain[20];
            int n4 = 0;
            while (n4 < this.fixedChain.length) {
                this.fixedChain[n4] = polygonChain = new PolygonChain();
                if (n4 > 0) {
                    this.fixedChain[n4 - 1].setNext(polygonChain);
                }
                ++n4;
            }
            this.freeList = this.fixedChain[0];
        }
        polygonChain = this.freeList;
        this.freeList = this.freeList.getNext();
        polygonChain.setValues(n2, n3, d2, d3);
        polygonChain.setNext(null);
        ++this.pCount;
        return polygonChain;
    }

    protected void modifyContourCell(int n2, int n3, int n4) {
        boolean bl;
        int n5;
        ContourCell contourCell = this.contourCells[this.cellIndex(n2, n3)];
        Intersection intersection = contourCell.getNewIntersection();
        if (intersection == null) {
            JCDebug.println("contour", "modifyContourCell: no previous intersection!");
        }
        int n6 = intersection.getSide1();
        ContourSegment contourSegment = intersection.getSegment1();
        Point3d point3d = contourSegment.getPoint();
        Point3d point3d2 = this.curSegment.getPoint();
        if ((n6 - n4) % 2 == 0) {
            n5 = 4;
            bl = this.verticalSide(n4) ? point3d2.x < point3d.x : point3d2.y < point3d.y;
        } else {
            n5 = Math.max(n6, n4);
            if (n5 == 3 && (n4 == 0 || n6 == 0)) {
                n5 = 0;
            }
            boolean bl2 = bl = n5 != n4;
        }
        if (bl) {
            intersection.setSide1(n4);
            intersection.setSegment1(this.curSegment);
            intersection.setSide2(n6);
            intersection.setSegment2(contourSegment);
        } else {
            intersection.setSide2(n4);
            intersection.setSegment2(this.curSegment);
        }
        contourCell.addIntersection(intersection, n5);
        contourCell.setNewIntersection(null);
    }

    protected void precompContours() {
        if (this.contourLines == null || this.dataView == null) {
            return;
        }
        Point4d point4d = new Point4d();
        Transform transform = this.dataView.getChart3d().getChart3dArea().getTransform();
        ListIterator listIterator = ((AbstractList)this.contourLines).listIterator();
        while (listIterator.hasNext()) {
            ContourLine contourLine = (ContourLine)listIterator.next();
            LinkedList linkedList = contourLine.getSegments();
            ListIterator listIterator2 = linkedList.listIterator();
            while (listIterator2.hasNext()) {
                ContourSegment contourSegment = (ContourSegment)listIterator2.next();
                Point3d point3d = contourSegment.getPoint();
                point4d.set(point3d);
                Matrix4d matrix4d = transform.getAbsolute();
                if (matrix4d.m22 == 0.0) {
                    point4d.z = 0.0;
                }
                Transform.transformPoint(transform.getView(), point4d);
                contourSegment.setXPixel((int)Math.round(point4d.x));
                contourSegment.setYPixel((int)Math.round(point4d.y));
            }
        }
    }

    public void recalcContours() {
        boolean bl;
        boolean bl2;
        if (this.dataView == null) {
            JCDebug.println("contour", "recalcContours: dataView is null");
            return;
        }
        if (!this.dataView.isDataDrawn() || !(this.dataView.getElevationData() instanceof Chart3dGridData)) {
            return;
        }
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCProjection jCProjection = jCChart3dArea.getPlotCube().getFloor();
        JCProjection jCProjection2 = jCChart3dArea.getPlotCube().getCeiling();
        boolean bl3 = this.contoured || jCProjection.isContoured() || jCProjection2.isContoured();
        boolean bl4 = bl2 = this.zoned || jCProjection.isZoned() || jCProjection2.isZoned();
        if (!bl3 && !bl2) {
            this.destroyContours();
            return;
        }
        boolean bl5 = bl = bl3 && (this.contourLines == null || this.contourCells == null);
        if (!bl && bl2) {
            if (this.zoneMethod == 1) {
                bl = this.contourLines == null || this.contourCells == null;
            } else {
                boolean bl6 = bl = this.contourCells == null;
            }
        }
        if (bl) {
            this.calcContours();
        }
    }

    public void resetContourStyles() {
        this.defaultContourStyles();
        this.callParentSetChanged(true, 34);
    }

    protected void reverseArray(Object[] objectArray, int n2) {
        if (objectArray.length < n2) {
            JCDebug.println("contour", "reverseArray: Bad length of array");
            return;
        }
        int n3 = n2 / 2;
        --n2;
        int n4 = 0;
        while (n4 < n3) {
            Object object = objectArray[n4];
            objectArray[n4] = objectArray[n2 - n4];
            objectArray[n2 - n4] = object;
            ++n4;
        }
    }

    protected PolygonChain reverseChain(PolygonChain polygonChain) {
        PolygonChain polygonChain2 = null;
        PolygonChain polygonChain3 = polygonChain;
        while (polygonChain3 != null) {
            PolygonChain polygonChain4 = polygonChain3.getNext();
            polygonChain3.setNext(polygonChain2);
            polygonChain2 = polygonChain3;
            polygonChain3 = polygonChain4;
        }
        return polygonChain2;
    }

    protected int rightSide(int n2, int n3) {
        return this.leftSide(n2, n3) + 1;
    }

    protected void setContourCellHole(int n2, int n3) {
        int n4 = 0;
        if (n2 == 0) {
            n4 |= 1;
        } else if (n2 == this.numX - 1) {
            n4 |= 2;
        }
        if (n3 == 0) {
            n4 |= 4;
        } else if (n3 == this.numY - 1) {
            n4 |= 8;
        }
        switch (n4) {
            case 1: {
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                break;
            }
            case 2: {
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
                break;
            }
            case 4: {
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                break;
            }
            case 8: {
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                break;
            }
            case 5: {
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                break;
            }
            case 9: {
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                break;
            }
            case 6: {
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                break;
            }
            case 10: {
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
                break;
            }
            default: {
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
            }
        }
    }

    public void setContourLevels(JCContourLevels jCContourLevels) {
        if (this.contourLevels == jCContourLevels) {
            return;
        }
        this.contourLevels = jCContourLevels;
        if (this.contourLevels == null) {
            this.contourLevels = new JCContourLevels();
        }
        this.contourLevels.clearParents();
        this.contourLevels.addParent(this.dataView);
        this.callParentSetChanged(true, 34);
    }

    public void setContourMapping(JCContourMapping jCContourMapping) {
        if (this.contourMapping == jCContourMapping) {
            return;
        }
        this.contourMapping = jCContourMapping;
        if (this.contourMapping == null) {
            this.contourMapping = this;
        }
        this.callParentSetChanged(true, 34);
    }

    public void setContourStyles(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            this.defaultContourStyles();
        } else {
            this.contourStyles = arrayList;
        }
        this.callParentSetChanged(true, 34);
    }

    public void setContoured(boolean bl) {
        if (this.contoured == bl) {
            return;
        }
        this.contoured = bl;
        this.callParentSetChanged(true, 34);
    }

    protected void setContouredNoUpdate(boolean bl) {
        this.contoured = bl;
    }

    protected void setDataView(Chart3dDataView chart3dDataView) {
        if (this.dataView == chart3dDataView) {
            return;
        }
        this.dataView = chart3dDataView;
        this.clearParents();
        this.addParent(chart3dDataView);
        this.callParentSetChanged(true, 34);
    }

    protected void setFillStyle(Graphics graphics, int n2) {
        JCContourStyle jCContourStyle = this.getContourStyleFromLevel(n2);
        if (jCContourStyle == null) {
            return;
        }
        JCFillStyle jCFillStyle = jCContourStyle.getFillStyle();
        jCFillStyle.updateGraphics(graphics);
    }

    protected void setInternalValues() {
        if (this.dataView == null) {
            JCDebug.println("contour", "setInternalValues: Unexpected null pointer");
            return;
        }
        this.data = (Chart3dGridData)this.dataView.getElevationData();
        this.zoneData = this.dataView.getZoneData();
        if (!this.zoneData.isDataOK()) {
            this.zoneData = this.data;
        }
        this.dataHoleValue = this.data.getHoleValue();
        this.zoneHoleValue = this.zoneData.getHoleValue();
        GridLimits gridLimits = this.data.getGridLimits();
        this.xOffset = gridLimits.getXOffset();
        this.yOffset = gridLimits.getYOffset();
        this.numX = gridLimits.getNumX();
        this.numY = gridLimits.getNumY();
    }

    protected boolean setLineStyle(Graphics graphics, int n2) {
        JCContourStyle jCContourStyle = this.getContourStyleFromLevel(n2);
        if (jCContourStyle == null) {
            return false;
        }
        JCLineStyle jCLineStyle = jCContourStyle.getLineStyle();
        return jCLineStyle.updateGraphics(graphics);
    }

    protected void setZLineColor(Graphics graphics, int n2) {
        JCContourStyle jCContourStyle = this.getContourStyleFromLevel(n2);
        if (jCContourStyle == null) {
            return;
        }
        graphics.setColor(jCContourStyle.getFillStyle().getColor());
    }

    public void setZoneMethod(int n2) {
        if (this.zoneMethod == n2) {
            return;
        }
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException("Invalid value. Should be one of ZONE_CONTOURS or ZONE_CELLS.");
        }
        this.zoneMethod = n2;
        this.callParentSetChanged(true, 34);
    }

    public void setZoned(boolean bl) {
        if (this.zoned == bl) {
            return;
        }
        this.zoned = bl;
        this.callParentSetChanged(true, 34);
    }

    protected void setZonedNoUpdate(boolean bl) {
        this.zoned = bl;
    }

    protected void startContour(int n2, int n3, int n4, Point3d point3d, Point3d point3d2) {
        if (this.contourLines == null) {
            this.contourLines = new ArrayList();
        }
        ContourLine contourLine = new ContourLine(n4);
        this.contourLines.add(contourLine);
        double[] dArray = this.contourLevels.getLevels();
        double d2 = dArray[n4];
        double d3 = point3d2.x * (d2 - point3d.z) - point3d.x * (d2 - point3d2.z);
        double d4 = point3d2.y * (d2 - point3d.z) - point3d.y * (d2 - point3d2.z);
        this.addPoint(n2, n3, d3 /= point3d2.z - point3d.z, d4 /= point3d2.z - point3d.z);
    }

    protected int topSide(int n2, int n3) {
        return this.bottomSide(n2, n3) + 1;
    }

    protected boolean verticalSide(int n2) {
        return n2 % 2 == 0;
    }

    protected boolean zoneMeshCell(Graphics graphics, int n2, int n3) {
        double d2;
        Intersection intersection;
        ArrayList arrayList;
        double d3;
        ScreenPoint screenPoint;
        JCChart3dArea jCChart3dArea = this.data.getDataView().getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        int n4 = this.cellIndex(n2, n3);
        ContourCell contourCell = this.contourCells[n4];
        if (contourCell.isHole()) {
            return false;
        }
        int n5 = this.xOffset + n2;
        int n6 = this.yOffset + n3;
        Point point = new Point();
        Point point2 = new Point();
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        boolean[] blArray = jCSurface.getXMesh();
        boolean[] blArray2 = jCSurface.getYMesh();
        if (jCSurface.isXMeshShowing()) {
            if (blArray[n6]) {
                screenPoint = screenPointArray[n5 + 1][n6];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5 + 1, n6);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(0), point2, d3, true, true);
                    arrayList = contourCell.getIntersectionList(4);
                    Intersection intersection2 = intersection = arrayList == null ? null : (Intersection)arrayList.get(0);
                    if (intersection != null && this.horizontalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, arrayList, point2, d3, true, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(3), point2, d3, false, false);
                }
                screenPoint = screenPointArray[n5][n6];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5, n6);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            if (blArray[n6 + 1]) {
                screenPoint = screenPointArray[n5 + 1][n6 + 1];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5 + 1, n6 + 1);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(1), point2, d3, false, true);
                    arrayList = contourCell.getIntersectionList(4);
                    Intersection intersection3 = intersection = arrayList == null ? null : (Intersection)arrayList.get(0);
                    if (intersection != null && this.horizontalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, arrayList, point2, d3, false, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(2), point2, d3, true, false);
                }
                screenPoint = screenPointArray[n5][n6 + 1];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5, n6 + 1);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
        if (jCSurface.isYMeshShowing()) {
            if (blArray2[n5 + 1]) {
                screenPoint = screenPointArray[n5 + 1][n6];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5 + 1, n6);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(0), point2, d3, false, true);
                    arrayList = contourCell.getIntersectionList(4);
                    Intersection intersection4 = intersection = arrayList == null ? null : (Intersection)arrayList.get(0);
                    if (intersection != null && this.verticalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, arrayList, point2, d3, false, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(1), point2, d3, true, false);
                }
                screenPoint = screenPointArray[n5 + 1][n6 + 1];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5 + 1, n6 + 1);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            if (blArray2[n5]) {
                screenPoint = screenPointArray[n5][n6];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5, n6);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(3), point2, d3, true, true);
                    arrayList = contourCell.getIntersectionList(4);
                    Intersection intersection5 = intersection = arrayList == null ? null : (Intersection)arrayList.get(0);
                    if (intersection != null && this.verticalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, arrayList, point2, d3, true, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(2), point2, d3, false, false);
                }
                screenPoint = screenPointArray[n5][n6 + 1];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5, n6 + 1);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
        return true;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected double zoneMeshIntersection(Graphics graphics, ArrayList arrayList, Point point, double d2, boolean bl, boolean bl2) {
        Point point2 = new Point();
        double[] dArray = this.contourLevels.getLevels();
        if (arrayList != null) {
            int n2 = bl2 ? 0 : arrayList.size() - 1;
            int n3 = bl2 ? arrayList.size() : 0;
            int n4 = bl2 ? 1 : -1;
            int n5 = n2;
            boolean bl3 = true;
            while (true) {
                boolean bl4;
                if (!bl3 || (bl3 = false) || !true) {
                    Intersection intersection = (Intersection)arrayList.get(n5);
                    ContourSegment contourSegment = bl ? intersection.getSegment1() : intersection.getSegment2();
                    point2.x = contourSegment.getXPixel();
                    point2.y = contourSegment.getYPixel();
                    double d3 = dArray[intersection.getLevel()];
                    this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d3 + d2) / 2.0));
                    graphics.drawLine(point2.x, point2.y, point.x, point.y);
                    point.setLocation(point2);
                    d2 = d3;
                    n5 += n4;
                }
                if (bl2) {
                    if (n5 < n3) continue;
                    bl4 = false;
                } else {
                    if (n5 >= n3) continue;
                    bl4 = false;
                }
                if (!bl4) break;
            }
        }
        return d2;
    }
}

