/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCChart3dLegendLabelGenerator;
import com.klg.jclass.chart3d.JCChart3dLegendTemplate;
import com.klg.jclass.chart3d.JCChart3dNumberFormat;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourMapping;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCData3dContourIndex;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCMultiFieldString;
import com.klg.jclass.chart3d.JCScatter;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.LegendEntry;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class JCChart3dLegendManager
implements JCLegendRenderer,
JCLegendPopulator,
Serializable {
    static final long serialVersionUID = 6132225179285554488L;
    protected JCChart3d chart3d;
    protected JCLegend legend;
    protected Color outlineColor = Color.black;
    protected Vector legendItems = null;
    protected int fieldGap = 2;
    protected int[] maxFieldWidths = null;
    protected static final int STYLE_NONE = 0;
    protected static final int STYLE_BOX_RANGE = 1;
    protected static final int STYLE_LINE_RANGE = 2;
    protected static final int STYLE_SYMBOL_RANGE = 3;
    protected static final int STYLE_CONTOUR = 4;
    protected static final int STYLE_CNTN_H = 5;
    protected static final int STYLE_CNTN_V = 6;

    public JCChart3dLegendManager(JCChart3d jCChart3d, JCLegend jCLegend) {
        this.chart3d = jCChart3d;
        this.legend = jCLegend;
    }

    protected void calcTextWidthsFromFields(int n2, List list, JCChart3dLegendTemplate jCChart3dLegendTemplate, FontMetrics fontMetrics) {
        Object object;
        Object object2;
        int n3;
        int n4 = list.size();
        if (n2 > 0) {
            this.maxFieldWidths = new int[n2];
            Arrays.fill(this.maxFieldWidths, 0);
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            List list2 = (List)list.get(n6);
            n3 = 0;
            while (n3 < list2.size()) {
                object2 = (JCLegendItem)list2.get(n3);
                if (!this.isTitleItem((JCLegendItem)object2)) {
                    if (((JCLegendItem)object2).contents instanceof JCMultiFieldString) {
                        JCMultiFieldString jCMultiFieldString = (JCMultiFieldString)((JCLegendItem)object2).contents;
                        object = jCMultiFieldString.getContentList();
                        int n7 = 0;
                        while (n7 < object.size() / 2) {
                            this.maxFieldWidths[n7] = Math.max(this.maxFieldWidths[n7], fontMetrics.stringWidth((String)object.get(n7 * 2 + 1)));
                            ++n7;
                        }
                    } else if (((JCLegendItem)object2).contents instanceof String) {
                        n5 = Math.max(n5, fontMetrics.stringWidth((String)((JCLegendItem)object2).contents));
                    }
                }
                ++n3;
            }
            ++n6;
        }
        int n8 = 0;
        if (n2 > 0) {
            n3 = 0;
            while (n3 < this.maxFieldWidths.length) {
                n8 += this.maxFieldWidths[n3];
                if (n3 < this.maxFieldWidths.length - 1) {
                    n8 += this.fieldGap;
                }
                ++n3;
            }
        }
        n8 = Math.max(n8, n5);
        n3 = 0;
        while (n3 < n4) {
            object2 = (List)list.get(n3);
            int n9 = 0;
            while (n9 < object2.size()) {
                object = (JCLegendItem)object2.get(n9);
                if (!this.isTitleItem((JCLegendItem)object)) {
                    if (((JCLegendItem)object).contents instanceof JCMultiFieldString) {
                        ((JCLegendItem)object).textDim.width = n8;
                    }
                    if (jCChart3dLegendTemplate != null && jCChart3dLegendTemplate.isContinuousLayout() && this.legend.getOrientation() == 0) {
                        ((JCLegendItem)object).symbolDim.width = n8 + jCChart3dLegendTemplate.getItemGap();
                    }
                }
                ++n9;
            }
            ++n3;
        }
    }

    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    public void drawLegendItemSymbol(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        if (jCLegendItem.itemInfo == null || jCLegendItem.symbolDim == null || jCLegendItem.symbolPos == null) {
            return;
        }
        int n2 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
        int n3 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
        if (jCLegendItem.itemInfo instanceof LegendEntry) {
            LegendEntry legendEntry = (LegendEntry)jCLegendItem.itemInfo;
            if (legendEntry.drawStyle != null && legendEntry.drawStyle instanceof JCSymbolStyle) {
                JCSymbolStyle jCSymbolStyle = (JCSymbolStyle)legendEntry.drawStyle;
                JCScatter jCScatter = this.chart3d.getChart3dArea().getScatter();
                if (jCScatter != null && jCScatter.hasDropLines() && legendEntry.parentStyle != null) {
                    JCLineStyle jCLineStyle = null;
                    if (legendEntry.parentStyle instanceof JCContourStyle) {
                        jCLineStyle = ((JCContourStyle)legendEntry.parentStyle).getLineStyle();
                    } else if (legendEntry.parentStyle instanceof JCChart3dStyle) {
                        jCLineStyle = ((JCChart3dStyle)legendEntry.parentStyle).getLineStyle();
                    }
                    if (jCLineStyle != null) {
                        jCLineStyle.draw(graphics, n2 + (jCLegendItem.symbolDim.width - jCLineStyle.getWidth()) / 2, n3 + 1, n2 + (jCLegendItem.symbolDim.width - jCLineStyle.getWidth()) / 2, n3 + jCLegendItem.symbolDim.height - 1);
                    }
                    jCSymbolStyle.draw(graphics, n2 + jCLegendItem.symbolDim.width / 2, n3 + jCLegendItem.symbolDim.height / 3 + 1, 2 * (jCLegendItem.symbolDim.width / 3) + 1);
                } else {
                    jCSymbolStyle.draw(graphics, n2 + jCLegendItem.symbolDim.width / 2, n3 + jCLegendItem.symbolDim.height / 2, 2 * (jCLegendItem.symbolDim.width / 3) + 1);
                }
            }
        }
    }

    public void drawLegendItemText(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        if (jCLegendItem.contents instanceof JCMultiFieldString) {
            ((JCMultiFieldString)jCLegendItem.contents).draw(graphics, font, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, this.maxFieldWidths, this.fieldGap);
        }
    }

    protected Vector filterLevels(Chart3dDataView chart3dDataView, int n2, JCChart3dLegendTemplate jCChart3dLegendTemplate, JCContour jCContour) {
        JCContourStyle jCContourStyle;
        int n3;
        Vector<LegendEntry> vector = new Vector<LegendEntry>();
        JCContourLevels jCContourLevels = jCContour.getContourLevels();
        double[] dArray = jCContourLevels.getLevels();
        if (dArray == null) {
            return vector;
        }
        JCChart3dNumberFormat jCChart3dNumberFormat = jCContourLevels.getNumberFormatter();
        int n4 = jCContourLevels.getNFrac();
        int n5 = jCContourLevels.getNumLevels();
        ArrayList arrayList = jCContour.getContourStyles();
        JCContourMapping jCContourMapping = jCContour.getContourMapping();
        boolean bl = false;
        if (jCChart3dLegendTemplate != null) {
            bl = jCChart3dLegendTemplate.getDistributionRange() == 1;
        }
        double d2 = jCContourLevels.getMin();
        double d3 = jCContourLevels.getMax();
        if ((jCContourLevels.isDefault() || bl) && (n2 == 5 || n2 == 6)) {
            vector.add(new LegendEntry(new JCData3dContourIndex(chart3dDataView, -1, d2, d2), null));
        }
        int n6 = -1;
        int n7 = 0;
        while (n7 < n5) {
            double d4 = dArray[n7];
            if (!bl || !(d4 < d2) && !(d4 > d3)) {
                n3 = jCContourMapping.contourIndex(n7);
                jCContourStyle = (JCContourStyle)arrayList.get(n3);
                if (n2 == 4) {
                    vector.add(new LegendEntry(new JCData3dContourIndex(chart3dDataView, n7, dArray[n7], dArray[n7]), jCContourStyle));
                } else if (n6 < 0) {
                    if (jCContourLevels.isDefault() || bl) {
                        String string;
                        String string2 = JCNumberUtil.format(d2, n4);
                        if (!string2.equals(string = JCNumberUtil.format(dArray[n7], n4))) {
                            vector.add(new LegendEntry(new JCData3dContourIndex(chart3dDataView, n7, d2, dArray[n7]), jCContourStyle));
                        }
                    } else if (n2 == 5 || n2 == 6) {
                        vector.add(new LegendEntry(new JCData3dContourIndex(chart3dDataView, n7, dArray[n7], dArray[n7]), null));
                    }
                } else {
                    vector.add(new LegendEntry(new JCData3dContourIndex(chart3dDataView, n7, dArray[n6], dArray[n7]), jCContourStyle));
                }
                n6 = n7;
            }
            ++n7;
        }
        if ((jCContourLevels.isDefault() || bl) && (n2 == 5 || n2 == 6 || n2 == 1 || n2 == 2)) {
            if (n6 < 0) {
                int n8 = jCContourMapping.contourIndex(n5);
                JCContourStyle jCContourStyle2 = (JCContourStyle)arrayList.get(n8);
                vector.add(new LegendEntry(new JCData3dContourIndex(chart3dDataView, n5, d2, d3), jCContourStyle2));
            } else {
                String string;
                String string3 = JCNumberUtil.format(d3, n4);
                if (!string3.equals(string = JCNumberUtil.format(dArray[n6], n4))) {
                    n3 = jCContourMapping.contourIndex(n6 + 1);
                    jCContourStyle = (JCContourStyle)arrayList.get(n3);
                    vector.add(new LegendEntry(new JCData3dContourIndex(chart3dDataView, n6 + 1, dArray[n6], d3), jCContourStyle));
                }
            }
        }
        return vector;
    }

    public int getFieldGap() {
        return this.fieldGap;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public List getLegendItems(FontMetrics var1_1) {
        this.legendItems = new Vector<E>();
        var2_2 = this.chart3d.getOriginalDataView();
        var3_3 = var2_2.size();
        var4_4 = 0;
        while (var4_4 < var3_3) {
            this.legendItems.add(new Vector<E>());
            ++var4_4;
        }
        var5_5 = null;
        var6_6 = null;
        if (this.legend instanceof JCChart3dLegendTemplate) {
            var6_6 = (JCChart3dLegendTemplate)this.legend;
            var5_5 = var6_6.getLabels();
        }
        var7_7 = -1;
        var8_8 = this.legend.getSymbolSize();
        var9_9 = 0;
        while (var9_9 < var3_3) {
            block39: {
                block43: {
                    block44: {
                        block41: {
                            block42: {
                                block40: {
                                    block38: {
                                        var10_10 = (List)this.legendItems.get(var9_9);
                                        var11_11 = (Chart3dDataView)var2_2.get(var9_9);
                                        var12_12 = var11_11.getName();
                                        var13_13 = new JCLegendItem();
                                        if (var12_12 != null && var12_12.length() > 0) {
                                            var13_13.textDim = new Dimension(var1_1.stringWidth(var12_12), var1_1.getHeight());
                                            var13_13.contents = var12_12;
                                        } else {
                                            var13_13.textDim = new Dimension(0, 0);
                                            var13_13.contents = null;
                                        }
                                        var10_10.add(var13_13);
                                        var14_14 = var11_11.getChartType() == 2;
                                        var15_15 = null;
                                        if (var6_6 != null && var5_5 != null && var9_9 < var5_5.size()) {
                                            var15_15 = (List)var5_5.get(var9_9);
                                        }
                                        var16_16 = 0;
                                        var17_17 = var11_11.getElevationData();
                                        if (!var14_14 || !(var17_17 instanceof Chart3dPointData)) break block38;
                                        var16_16 = 1;
                                        var18_18 = (Chart3dPointData)var17_17;
                                        var19_19 = var18_18.getNumSeries();
                                        var20_20 = 0;
                                        while (var20_20 < var19_19) {
                                            var21_22 = var18_18.getSeries(var20_20);
                                            var22_23 = null;
                                            var22_23 = var15_15 != null && var20_20 < var15_15.size() ? var15_15.get(var20_20) : var21_22.getLabel();
                                            if (var22_23 != null) {
                                                var23_24 /* !! */  = new JCData3dPointIndex(var11_11, var20_20, -1);
                                                var24_25 /* !! */  = new LegendEntry((JCData3dIndex)var23_24 /* !! */ , var21_22.getChartStyle(), var21_22.getChartStyle().getSymbolStyle());
                                                var25_26 = new JCLegendItem();
                                                var7_7 = this.populate3dLegendItem(var25_26, var1_1, var22_23, 4, new Dimension(var8_8, var8_8), var24_25 /* !! */ , var7_7);
                                                var10_10.add(var25_26);
                                            }
                                            ++var20_20;
                                        }
                                        break block39;
                                    }
                                    var18_18 = null;
                                    var19_19 = 0;
                                    if (var14_14 && var17_17 instanceof Chart3dGridData) {
                                        var18_18 = (Chart3dGridData)var17_17;
                                        var19_19 = 1;
                                    }
                                    var20_21 = var11_11.getElevation();
                                    var21_22 = var11_11.getContour();
                                    var22_23 = var11_11.getChart3d().getChart3dArea();
                                    var23_24 /* !! */  = var22_23.getPlotCube().getFloor();
                                    var24_25 /* !! */  = var22_23.getPlotCube().getCeiling();
                                    var25_27 = var23_24 /* !! */ .isContoured() != false || var24_25 /* !! */ .isContoured() != false;
                                    var26_28 = var23_24 /* !! */ .isZoned() != false || var24_25 /* !! */ .isZoned() != false;
                                    var27_29 = var21_22.isContoured() != false || var25_27 != false;
                                    v0 = var28_30 = var21_22.isZoned() != false || var26_28 != false;
                                    if ((!var21_22.isZoned() || var20_21.isMeshed() && !var20_21.isShaded()) && !var26_28) break block40;
                                    if (var19_19 != 0) {
                                        var16_16 = 3;
                                    } else if (var6_6 != null) {
                                        if (var6_6.getLayoutStyle() == 0) {
                                            var16_16 = this.legend.getOrientation() == 0 ? 5 : 6;
                                            var6_6.setContinuousLayout(true);
                                        } else {
                                            var16_16 = 1;
                                            var6_6.setContinuousLayout(false);
                                        }
                                    } else {
                                        var16_16 = 1;
                                    }
                                    ** GOTO lbl-1000
                                }
                                if (!var21_22.isZoned() || !var20_21.isMeshed() || var20_21.isShaded()) break block41;
                                if (var19_19 == 0) break block42;
                                var16_16 = 3;
                                ** GOTO lbl-1000
                            }
                            var16_16 = 2;
                            if (var6_6 == null) ** GOTO lbl-1000
                            var6_6.setContinuousLayout(false);
                            ** GOTO lbl-1000
                        }
                        if (var21_22.isZoned() || !var27_29) break block43;
                        if (var19_19 == 0) break block44;
                        var16_16 = 3;
                        ** GOTO lbl-1000
                    }
                    var16_16 = 4;
                    if (var6_6 == null) ** GOTO lbl-1000
                    var6_6.setContinuousLayout(false);
                    ** GOTO lbl-1000
                }
                if (var19_19 != 0 && !var27_29 && !var28_30 && (var20_21.isMeshed() || var20_21.isShaded())) {
                    var16_16 = 1;
                    var29_31 = null;
                    var29_31 = var15_15 != null && var15_15.size() > 0 ? var15_15.get(var9_9) : var18_18.getName();
                    if (var29_31 != null) {
                        var30_32 = new JCData3dGridIndex(var11_11, 0x7FFFFFFF, 0x7FFFFFFF);
                        var31_33 /* !! */  = new LegendEntry((JCData3dIndex)var30_32, var18_18.getChartStyle(), var18_18.getChartStyle().getSymbolStyle());
                        var32_34 = new JCLegendItem();
                        var7_7 = this.populate3dLegendItem((JCLegendItem)var32_34, var1_1, var29_31, 4, new Dimension(var8_8, var8_8), var31_33 /* !! */ , var7_7);
                        var10_10.add(var32_34);
                    }
                } else if (var16_16 == 0) {
                    if (var10_10.size() > 0) {
                        var10_10.clear();
                    }
                } else {
                    var29_31 = null;
                    if (var6_6 != null) {
                        var29_31 = var6_6.getLabelGenerator();
                    }
                    var30_32 = this.filterLevels(var11_11, var16_16, var6_6, (JCContour)var21_22);
                    var31_33 /* !! */  = var21_22.getContourLevels();
                    var32_34 = var31_33 /* !! */ .getNumberFormatter();
                    var33_35 = var31_33 /* !! */ .getNFrac();
                    var34_36 = var30_32.size() - 1;
                    while (var34_36 >= 0) {
                        var35_37 = (LegendEntry)var30_32.get(var34_36);
                        var36_38 = this.getNonScatterLabel(var16_16, (JCChart3dNumberFormat)var32_34, var33_35, (Vector)var30_32, var15_15, var34_36, (JCChart3dLegendLabelGenerator)var29_31);
                        if (var36_38 != null) {
                            var37_39 = null;
                            if (var16_16 == 5 || var16_16 == 6) {
                                var37_39 = new JCLegendItem();
                                if (var35_37.parentStyle != null) {
                                    var35_37.drawStyle = ((JCContourStyle)var35_37.parentStyle).getFillStyle();
                                    if (var16_16 == 6) {
                                        var38_40 = var1_1.getHeight();
                                        var7_7 = this.populate3dLegendItem(var37_39, var1_1, var36_38, 6, new Dimension(var8_8 * 2, var38_40 + var6_6.getItemGap()), var35_37, var7_7);
                                    } else {
                                        var7_7 = this.populate3dLegendItem(var37_39, var1_1, var36_38, 6, new Dimension(0, var8_8), var35_37, var7_7);
                                    }
                                } else {
                                    var35_37.drawStyle = null;
                                    var7_7 = this.populate3dLegendItem(var37_39, var1_1, var36_38, 0, new Dimension(var8_8 * 2, var8_8), var35_37, var7_7);
                                }
                            } else {
                                var37_39 = new JCLegendItem();
                                var38_41 = new Dimension(var8_8 * 2, var8_8);
                                if (var16_16 == 1) {
                                    var35_37.drawStyle = ((JCContourStyle)var35_37.parentStyle).getFillStyle();
                                    var7_7 = this.populate3dLegendItem(var37_39, var1_1, var36_38, 1, var38_41, var35_37, var7_7);
                                } else if (var16_16 == 2) {
                                    var35_37.drawStyle = ((JCContourStyle)var35_37.parentStyle).getFillStyle();
                                    var7_7 = this.populate3dLegendItem(var37_39, var1_1, var36_38, 7, var38_41, var35_37, var7_7);
                                } else if (var16_16 == 3) {
                                    var35_37.drawStyle = ((JCContourStyle)var35_37.parentStyle).getSymbolStyle();
                                    var7_7 = this.populate3dLegendItem(var37_39, var1_1, var36_38, 4, new Dimension(var8_8, var8_8), var35_37, var7_7);
                                } else if (var16_16 == 4) {
                                    var35_37.drawStyle = ((JCContourStyle)var35_37.parentStyle).getLineStyle();
                                    var7_7 = this.populate3dLegendItem(var37_39, var1_1, var36_38, 7, var38_41, var35_37, var7_7);
                                }
                            }
                            if (var37_39 != null) {
                                var10_10.add(var37_39);
                            }
                        }
                        --var34_36;
                    }
                }
            }
            ++var9_9;
        }
        this.calcTextWidthsFromFields(var7_7, this.legendItems, var6_6, var1_1);
        return this.legendItems;
    }

    protected Object getNonScatterLabel(int n2, JCChart3dNumberFormat jCChart3dNumberFormat, int n3, Vector vector, List list, int n4, JCChart3dLegendLabelGenerator jCChart3dLegendLabelGenerator) {
        Object object = null;
        LegendEntry legendEntry = (LegendEntry)vector.get(n4);
        JCData3dContourIndex jCData3dContourIndex = (JCData3dContourIndex)legendEntry.dataIndex;
        double d2 = jCData3dContourIndex.getUpperContourRangeValue();
        double d3 = jCData3dContourIndex.getLowerContourRangeValue();
        String string = JCNumberUtil.format(d2, n3);
        String string2 = JCNumberUtil.format(d3, n3);
        string = jCChart3dNumberFormat.localize(string);
        string2 = jCChart3dNumberFormat.localize(string2);
        if (list != null && list.size() > n4) {
            object = list.get(n4);
        } else if (n2 == 5) {
            object = new JCMultiFieldString("\\c" + string);
            d2 = d3;
        } else if (n2 == 6) {
            object = new JCMultiFieldString("\\r" + string);
            d2 = d3;
        } else if (n2 == 1 || n2 == 2 || n2 == 3) {
            object = new JCMultiFieldString("\\r" + string2 + "\\c" + " .. " + "\\r" + string);
        } else if (n2 == 4) {
            object = new JCMultiFieldString("\\r" + string);
            d3 = d2;
        }
        if (jCChart3dLegendLabelGenerator != null) {
            object = jCChart3dLegendLabelGenerator.generateLegendLabel(this.chart3d, jCData3dContourIndex.getContourStyleIndex(), d3, d2, object);
        }
        return object;
    }

    public Color getOutlineColor(JCLegendItem jCLegendItem) {
        return this.outlineColor;
    }

    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        return jCLegendItem.itemInfo == null;
    }

    protected int populate3dLegendItem(JCLegendItem jCLegendItem, FontMetrics fontMetrics, Object object, int n2, Dimension dimension, Object object2, int n3) {
        if (jCLegendItem == null) {
            return n3;
        }
        int n4 = 0;
        int n5 = fontMetrics.getHeight();
        if (object != null) {
            if (object instanceof JCMultiFieldString) {
                JCMultiFieldString jCMultiFieldString = (JCMultiFieldString)object;
                List list = jCMultiFieldString.getContentList();
                n3 = Math.max(n3, list.size() / 2);
                n4 = 0;
            } else if (object instanceof String) {
                n4 = fontMetrics.stringWidth((String)object);
            }
        }
        jCLegendItem.contents = object;
        jCLegendItem.drawType = n2;
        jCLegendItem.textDim = new Dimension(n4, n5);
        jCLegendItem.symbolDim = dimension;
        jCLegendItem.itemInfo = object2;
        return n3;
    }

    public void setFieldGap(int n2) {
        this.fieldGap = n2;
    }

    public void setFillGraphics(Graphics graphics, JCLegendItem jCLegendItem) {
        if (jCLegendItem.itemInfo == null) {
            return;
        }
        if (jCLegendItem.itemInfo instanceof LegendEntry) {
            LegendEntry legendEntry = (LegendEntry)jCLegendItem.itemInfo;
            if (legendEntry.drawStyle instanceof JCSymbolStyle) {
                graphics.setColor(((JCSymbolStyle)legendEntry.drawStyle).getColor());
            } else if (legendEntry.drawStyle instanceof JCFillStyle) {
                graphics.setColor(((JCFillStyle)legendEntry.drawStyle).getColor());
            } else if (legendEntry.drawStyle instanceof JCLineStyle) {
                graphics.setColor(((JCLineStyle)legendEntry.drawStyle).getColor());
            }
        }
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }
}

